---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要・機能説明
- E-02: `src/apex/f141/application/pages/page_00001.sql` - ダッシュボード画面定義
- E-03: `src/apex/f141/application/pages/page_00002.sql` - ユニットテスト生成画面定義
- E-04: `src/apex/f141/application/pages/page_00003.sql` - ランタイムエラー画面定義
- E-05: `src/apex/f141/application/pages/page_00004.sql` - 違反オブジェクト画面定義
- E-06: `src/apex/f141/application/pages/page_00005.sql` - テスト結果ファイル画面定義
- E-07: `src/apex/f141/application/pages/page_00006.sql` - ルール一覧画面定義
- E-08: `src/apex/f141/application/pages/page_00007.sql` - ルール編集画面定義
- E-09: `src/apex/f141/application/pages/page_00008.sql` - ルールファイル画面定義
- E-10: `src/apex/f141/application/pages/page_00009.sql` - スケジューラ設定画面定義
- E-11: `src/apex/f141/application/shared_components/navigation/lists/navigation_menu.sql` - ナビゲーションメニュー定義
- E-12: `src/apex/f141/application/shared_components/security/authentications/oracle_apex_accounts.sql` - 認証設定
- E-13: `src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql` - 認可設定
- E-14: `src/apex/f141/application/create_application.sql` - アプリケーション定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001：品質ルール定義 - QA_RULESテーブルでルールを管理 | E-01, E-07, E-08 | ○ |
| C-02 | BR-002：品質ルール実行 - QA_API_PKG経由でルール実行 | E-01 | ○ |
| C-03 | BR-003：テスト結果表示 - ダッシュボードでの可視化 | E-02 | ○ |
| C-04 | BR-004：違反オブジェクト詳細表示 - モーダルダイアログ | E-05 | ○ |
| C-05 | BR-005：ユニットテスト自動生成 | E-01, E-03 | ○ |
| C-06 | BR-006：ユニットテスト削除 | E-03 | ○ |
| C-07 | BR-007：テスト結果ファイル管理 - XML形式 | E-06 | ○ |
| C-08 | BR-008：スケジューラジョブ設定 | E-10 | ○ |
| C-09 | BR-009：ジョブ実行履歴管理 | E-10 | ○ |
| C-10 | BR-010：ルールエクスポート - JSON形式 | E-09 | ○ |
| C-11 | BR-011：ルールインポート - JSON形式 | E-09 | ○ |
| C-12 | BR-012：オブジェクト除外設定 | E-01, E-08 | ○ |
| C-13 | BR-013：実行順序制御 - 前提条件定義 | E-01 | ○ |
| C-14 | BR-014：ランタイムエラー表示 | E-04 | ○ |
| C-15 | BR-015：ユーザー認証 - Oracle APEXアカウント | E-12 | ○ |
| C-16 | BR-016：管理者権限制御 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません
- 全ての業務要件はソースコードまたはREADME.mdから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対してソースコードまたはドキュメントの根拠が存在
- 注意点：PL/SQLパッケージ（QA_API_PKG、QA_UNIT_TESTS_PKG、qa_apex_app_pkg）の実装詳細は本プロジェクトのソースには含まれていない可能性あり（データベース側で管理）

## 6) レビュアーチェックリスト（最小）
- [ ] 業務要件の優先度（高/中/低）が適切か確認
- [ ] 関連機能のページ番号が正しいか確認
- [ ] 備考欄の技術的詳細が正確か確認
- [ ] 不足している業務要件がないか確認（ログ機能、エラーハンドリング等）
- [ ] カテゴリ分類が適切か確認
