---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 54
  claims_with_evidence: 51
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：51 / 54、根拠なし：3
- 優先レビュー（高）
  1. **No.51-54（インストール/アンインストール機能）**：スクリプトファイルの存在は確認したが、内部実装の詳細は未検証
  2. **No.47-50（オブジェクト型）**：型定義ファイルは確認したが、全てのメンバー属性は未検証
  3. **APEXアプリケーション画面機能**：コードは確認したが、APEXエクスポートファイルは大規模なため部分的検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理コア機能
- E-03: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - ルールエクスポート/インポート
- E-04: `src/plsql/pkg/qa_unit_tests_pkg.sql` - utPLSQL連携機能
- E-05: `src/plsql/pkg/qa_apex_api_pkg.sql` - APEX連携API
- E-06: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEXアプリケーション機能
- E-07: `src/plsql/pkg/qa_logger_pkg.sql` - ロギング機能
- E-08: `src/plsql/pkg/qa_utils_pkg.sql` - ユーティリティ機能
- E-09: `src/ddl/tab/qa_rules.sql` - ルールテーブル定義
- E-10: `src/ddl/tab/qa_import_files.sql` - インポートファイルテーブル定義
- E-11: `src/ddl/tab/qa_test_results.sql` - テスト結果テーブル定義
- E-12: `src/ddl/tab/qa_test_runs.sql` - テスト実行履歴テーブル定義
- E-13: `src/ddl/tab/qa_test_run_invalid_objects.sql` - 無効オブジェクトテーブル定義
- E-14: `src/plsql/typ/` - オブジェクト型定義
- E-15: `src/scripts/install.sql` - インストールスクリプト
- E-16: `src/scripts/uninstall.sql` - アンインストールスクリプト
- E-17: `README.md` - プロジェクト説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルール定義機能 | E-09, E-02 | ○ |
| C-02 | 単一ルール実行（qa_api_pkg.tf_run_rule） | E-01 | ○ |
| C-03 | 全ルール実行（qa_api_pkg.tf_run_rules） | E-01 | ○ |
| C-04 | ルール有効/無効制御（qaru_is_active） | E-09 | ○ |
| C-05 | オブジェクト除外（qaru_exclude_objects） | E-09, E-02 | ○ |
| C-06 | 先行ルール依存関係（qaru_predecessor_ids） | E-09, E-02 | ○ |
| C-07 | ルール属性取得（qa_main_pkg.f_get_rule系） | E-02 | ○ |
| C-08 | ルール存在確認（qa_main_pkg.f_exist_rules） | E-02 | ○ |
| C-09 | ルール挿入（qa_main_pkg.f_insert_rule） | E-02 | ○ |
| C-10 | ルールJSONエクスポート | E-03 | ○ |
| C-11 | ルールJSONインポート | E-03 | ○ |
| C-12 | インポートファイル管理 | E-03, E-10 | ○ |
| C-13 | ルールスクリプトエクスポート | E-03 | ○ |
| C-14 | ユニットテストパッケージ生成 | E-04 | ○ |
| C-15 | ユニットテストパッケージ削除 | E-04 | ○ |
| C-16 | 全ユニットテスト実行 | E-04 | ○ |
| C-17 | 単一ユニットテスト実行 | E-04 | ○ |
| C-18 | カスタムテストジョブ作成 | E-04 | ○ |
| C-19 | スケジューラジョブ制御 | E-04 | ○ |
| C-20 | テスト結果処理 | E-04 | ○ |
| C-21 | テスト例外処理 | E-04 | ○ |
| C-22 | テスト結果インポート | E-04 | ○ |
| C-23 | テスト結果エクスポート | E-04 | ○ |
| C-24 | APEXルール実行 | E-05 | ○ |
| C-25 | APEXブラックリスト除外 | E-05 | ○ |
| C-26 | ダッシュボードデータ取得 | E-06 | ○ |
| C-27 | ルールJSONアップロード | E-06 | ○ |
| C-28 | ルールJSONダウンロード | E-06 | ○ |
| C-29 | テスト結果XMLアップロード | E-06 | ○ |
| C-30 | テスト結果XMLダウンロード | E-06 | ○ |
| C-31 | ファセット検索コレクション生成 | E-06 | ○ |
| C-32 | パラメータログ | E-07 | ○ |
| C-33 | エラーログ | E-07 | ○ |
| C-34 | 型変換 | E-07 | ○ |
| C-35 | テーブル文字列変換 | E-08 | ○ |
| C-36 | 文字列テーブル変換 | E-08 | ○ |
| C-37 | 文字列統一化 | E-08 | ○ |
| C-38 | 文字列置換 | E-08 | ○ |
| C-39 | DBMS出力 | E-08 | ○ |
| C-40 | 定数値取得 | E-08 | ○ |
| C-41 | ブラックリスト判定 | E-02 | ○ |
| C-42 | ルール格納（QA_RULESテーブル） | E-09 | ○ |
| C-43 | インポートファイル格納 | E-10 | ○ |
| C-44 | テスト結果XML格納 | E-11 | ○ |
| C-45 | テスト実行履歴格納 | E-12 | ○ |
| C-46 | 無効オブジェクト格納 | E-13 | ○ |
| C-47 | ルール型定義 | E-14 | ○ |
| C-48 | 実行中ルール型定義 | E-14 | ○ |
| C-49 | スキーマオブジェクト量型定義 | E-14 | ○ |
| C-50 | テスト結果型定義 | E-14 | ○ |
| C-51 | QUASTOインストール | E-15 | △ |
| C-52 | utPLSQLオブジェクトインストール | E-15 | △ |
| C-53 | APEXオブジェクトインストール | E-15 | △ |
| C-54 | アンインストール | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- インストール関連スクリプト（No.51-53）：スクリプトファイルの存在は確認したが、内部で呼び出される個別スクリプトの詳細は未検証
  - 候補：install_quasto_objects.sql / install_utplsql_objects.sql / install_apex_objects.sql の内容確認
- APEXエクスポートファイル：f104.sql が大規模なため、画面機能の詳細は部分的検証のみ
  - 候補：APEXアプリケーションの各ページ機能の詳細分析

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ルール管理、エクスポート/インポート、ロギング、ユーティリティ - ソースコードで直接確認
- 0（低リスク）：utPLSQL連携 - パッケージ仕様部・本体で関数/プロシージャを確認
- 0（低リスク）：データ管理 - DDLスクリプトで全テーブル構造を確認
- 1（中リスク）：インストール/アンインストール - スクリプトの存在は確認したが、実行フローは未検証
- 1（中リスク）：オブジェクト型 - 型定義ディレクトリの存在は確認したが、個別ファイルの詳細は部分的確認

## 6) レビュアーチェックリスト（最小）
- [ ] ルール管理機能（No.1-9）が要件と一致しているか確認
- [ ] エクスポート/インポート機能（No.10-13）のファイル形式が正しいか確認
- [ ] utPLSQL連携機能（No.14-23）がutPLSQLフレームワークと互換性があるか確認
- [ ] APEX連携機能（No.24-31）がAPEXアプリケーションと正しく連携しているか確認
- [ ] インストール/アンインストールスクリプト（No.51-54）の実行順序が正しいか確認
- [ ] オブジェクト型（No.47-50）が全パッケージで正しく使用されているか確認
