# 機能設計書 1-ルール定義

## 概要

本ドキュメントは、QUASTOシステムにおけるルール定義機能の設計仕様を記述する。

### 本機能の処理概要

ルール定義機能は、QA_RULESテーブルにSQLベースの品質チェックルールを定義し、データモデル（DDL）、PL/SQLコード（DML）、APEXアプリケーションの品質検証を実行するための基盤を提供する機能である。

**業務上の目的・背景**：データベースオブジェクトやAPEXアプリケーションの品質を一貫した基準で検証するために、SQLクエリベースのルールを定義・管理する必要がある。開発チームが独自の品質基準を定義し、それを自動的にチェックできる仕組みを提供することで、コード品質の均一化とレビュー工数の削減を実現する。

**機能の利用シーン**：
- 新規プロジェクト開始時にプロジェクト固有の品質ルールを定義する場合
- 既存ルールを確認・修正する場合
- ルールの有効/無効を切り替える場合
- ルール一覧を確認し、適用されているルールを把握する場合

**主要な処理内容**：
1. QA_RULESテーブルにルール情報（ルール番号、クライアント名、カテゴリ、SQLクエリ等）を格納する
2. DDL、DML、APEXの3つのカテゴリに対応したルールを管理する
3. ルールのエラーレベル（1=Error、2=Warning、4=Info）を設定する
4. ルール実行時に除外するオブジェクトを指定する
5. 先行ルールの依存関係を定義する
6. ルールのレイヤー（PAGE、APPLICATION、DATABASE）を設定する

**関連システム・外部連携**：APEXアプリケーションとの連携により、GUI上からルールの参照・編集が可能。utPLSQL連携によりユニットテストとしてルールを実行可能。

**権限による制御**：ルールの作成・編集・削除はAPEXの管理権限（Administration Rights）を持つユーザーのみ実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Rules | 主画面 | ルール一覧を表示、Interactive Reportでルールを検索・フィルタリング |
| 8 | Add/Edit Rule | 結果表示画面 | ルールの新規作成・編集フォームを表示 |

## 機能種別

データ定義 / CRUD操作 / バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| qaru_rule_number | VARCHAR2(20 CHAR) | Yes | ルール番号 | NOT NULL、クライアント名との組み合わせで一意 |
| qaru_client_name | VARCHAR2(100 CHAR) | Yes | クライアント/プロジェクト名 | NOT NULL |
| qaru_name | VARCHAR2(100 CHAR) | Yes | ルール名 | NOT NULL |
| qaru_category | VARCHAR2(100 CHAR) | Yes | カテゴリ（APEX/DDL/DML） | NOT NULL、DDL/DML/APEXのいずれか |
| qaru_object_types | VARCHAR2(4000 CHAR) | Yes | 対象オブジェクトタイプ（コロン区切り） | NOT NULL |
| qaru_error_message | VARCHAR2(4000 CHAR) | Yes | エラーメッセージ | NOT NULL |
| qaru_comment | VARCHAR2(4000 CHAR) | No | コメント | - |
| qaru_exclude_objects | VARCHAR2(4000 CHAR) | No | 除外オブジェクト（コロン区切り） | - |
| qaru_error_level | NUMBER | Yes | エラーレベル（1/2/4） | NOT NULL、1=Error, 2=Warning, 4=Info |
| qaru_is_active | NUMBER | Yes | 有効フラグ | NOT NULL、0=無効、1=有効（デフォルト1） |
| qaru_sql | CLOB | Yes | 品質チェック用SQLクエリ | NOT NULL、QUASTO形式のSQL |
| qaru_predecessor_ids | VARCHAR2(4000 CHAR) | No | 先行ルールID（コロン区切り） | - |
| qaru_layer | VARCHAR2(100 CHAR) | Yes | レイヤー（PAGE/APPLICATION/DATABASE） | NOT NULL |
| qaru_app_id | VARCHAR2(4000 CHAR) | No | 対象APEXアプリケーションID（カンマ区切り） | - |
| qaru_page_id | VARCHAR2(4000 CHAR) | No | 対象APEXページID（カンマ区切り） | - |

### 入力データソース

- APEX画面（Add/Edit Rule画面）からのフォーム入力
- JSONファイルからのインポート（qa_export_import_rules_pkg経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qaru_id | NUMBER | ルールの一意識別子（自動採番） |
| qaru_rule_number | VARCHAR2(20 CHAR) | ルール番号 |
| qaru_client_name | VARCHAR2(100 CHAR) | クライアント名 |
| qaru_name | VARCHAR2(100 CHAR) | ルール名 |
| qaru_category | VARCHAR2(100 CHAR) | カテゴリ |
| qaru_created_on | DATE | 作成日時 |
| qaru_created_by | VARCHAR2(255 CHAR) | 作成者 |
| qaru_updated_on | DATE | 更新日時 |
| qaru_updated_by | VARCHAR2(255 CHAR) | 更新者 |

### 出力先

- QA_RULESテーブル（永続化）
- APEX画面（Rules画面のInteractive Report）

## 処理フロー

### 処理シーケンス

```
1. ルール情報の入力
   └─ APEX画面またはJSONインポートからルール情報を受け取る
2. バリデーション実行
   └─ 必須項目チェック、カテゴリ値チェック、一意制約チェック
3. QA_RULESテーブルへの登録/更新
   └─ INSERT（新規）またはMERGE（更新）でデータを永続化
4. 監査情報の記録
   └─ 作成者/更新者、作成日時/更新日時を自動設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ルール情報入力]
    B --> C{バリデーション}
    C -->|OK| D{既存ルール?}
    C -->|NG| E[エラー表示]
    E --> B
    D -->|新規| F[INSERT実行]
    D -->|既存| G[UPDATE実行]
    F --> H[監査情報記録]
    G --> H
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ルール一意性 | ルール番号とクライアント名の組み合わせは一意でなければならない | ルール登録時 |
| BR-02 | カテゴリ制約 | カテゴリはDDL、DML、APEXのいずれかでなければならない | ルール登録時 |
| BR-03 | エラーレベル制約 | エラーレベルは1（Error）、2（Warning）、4（Info）のいずれかでなければならない | ルール登録時 |
| BR-04 | APEX除外 | gc_apex_flagが0の場合、APEXカテゴリのルールは実行対象から除外される | ルール実行時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール登録 | QA_RULES | INSERT | 新規ルールをテーブルに挿入 |
| ルール更新 | QA_RULES | UPDATE | 既存ルールの属性を更新 |
| ルール取得 | QA_RULES | SELECT | ルール情報を取得 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qaru_id | シーケンスから自動採番 | 主キー |
| INSERT | qaru_created_on | SYSDATE | 自動設定 |
| INSERT | qaru_created_by | USER | 自動設定 |
| INSERT | qaru_updated_on | SYSDATE | 自動設定 |
| INSERT | qaru_updated_by | USER | 自動設定 |
| UPDATE | qaru_updated_on | SYSDATE | 更新時に自動設定 |
| UPDATE | qaru_updated_by | USER | 更新時に自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | 同一のルール番号とクライアント名の組み合わせが既存 | 別のルール番号を使用 |
| ORA-01400 | NOT NULL制約違反 | 必須項目が未入力 | 必須項目を入力 |

### リトライ仕様

リトライは不要。エラー発生時はユーザーに入力修正を促す。

## トランザクション仕様

- 単一ルールの登録/更新は1トランザクションとして処理
- JSONインポート時は全ルールの処理完了後にコミット
- エラー発生時はロールバック

## パフォーマンス要件

- ルール一覧の表示：1秒以内
- 単一ルールの登録/更新：1秒以内

## セキュリティ考慮事項

- qaru_sqlには任意のSQLを格納可能なため、実行権限の制御が必要
- authid current_userにより、実行ユーザーの権限でSQLが実行される
- ブラックリストスキーマ（SYS、SYSTEM等）への操作は制限される

## 備考

- QA_RULESテーブルは21列で構成される
- DDL、DML、APEXの3カテゴリをサポート
- エラーレベルは4以下のルールのみ実行対象

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ルール情報を格納するテーブル構造と型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | QA_RULESテーブルの21列の構造、各カラムの用途とコメントを確認 |
| 1-2 | qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | ルール情報を保持するオブジェクト型の属性とコンストラクタを確認 |
| 1-3 | qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | qa_rule_tのテーブル型（コレクション）定義を確認 |

**読解のコツ**:
- DDLファイル内のコメント文（execute immediate q'#comment on...）でカラムの用途を把握
- qa_rule_tには4つのコンストラクタがあり、用途に応じて使い分けられる

#### Step 2: エントリーポイントを理解する

ルール管理の主要なAPIを提供するパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ルール操作の中核となるパッケージ仕様を確認 |

**主要処理フロー**:
1. **1-202行目**: パッケージ仕様部でルール操作関連の関数・プロシージャを宣言
2. **151-166行目**: f_insert_rule関数の仕様（ルール挿入の主要API）
3. **749-838行目**: f_insert_rule関数の実装（INSERT文の実行）

#### Step 3: ルール属性取得機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_get_rule関数でルール属性の取得方法を確認 |

**主要処理フロー**:
- **213-256行目**: f_get_rule関数の実装
- **230-240行目**: qa_rule_tコンストラクタを使用してルール情報を構築

#### Step 4: ビュー定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_predecessor_order_v.sql | `src/plsql/vw/qa_predecessor_order_v.sql` | ルール実行順序を決定するビューの構造を確認 |
| 4-2 | qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | テスト対象スキーマのフィルタリングを確認 |

### プログラム呼び出し階層図

```
APEX画面 (Rules / Add/Edit Rule)
    │
    ├─ qa_main_pkg.f_insert_rule
    │      └─ INSERT INTO qa_rules
    │
    ├─ qa_main_pkg.f_get_rule
    │      └─ SELECT FROM qa_rules
    │
    └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table
           └─ MERGE INTO qa_rules
```

### データフロー図

```
[入力]                    [処理]                           [出力]

APEX画面入力 ─────────▶ qa_main_pkg.f_insert_rule ─────▶ QA_RULESテーブル
                              │
JSONファイル ─────────▶ qa_export_import_rules_pkg    ─▶ QA_RULESテーブル
                        .p_import_clob_to_rules_table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | QA_RULESテーブル定義 |
| qa_rules.sql | `src/ddl/cons/qa_rules.sql` | DDL | QA_RULESテーブル制約定義 |
| qa_rules.sql | `src/ddl/ind/qa_rules.sql` | DDL | QA_RULESテーブルインデックス定義 |
| qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | TYPE | ルール型定義 |
| qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | TYPE | ルールコレクション型定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | ルール管理の中核パッケージ |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | PKG | ルールのエクスポート/インポートパッケージ |
| qa_predecessor_order_v.sql | `src/plsql/vw/qa_predecessor_order_v.sql` | VIEW | ルール実行順序ビュー |
| qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | VIEW | テスト対象スキーマビュー |
| qa_rules_p0007_v.sql | `src/plsql/vw/qa_rules_p0007_v.sql` | VIEW | Rules画面用ビュー |
