# 機能設計書 11-ルールJSONインポート

## 概要

本ドキュメントは、QUASTOシステムにおける「ルールJSONインポート」機能の設計内容を記述するものである。本機能は、外部からエクスポートされたJSON形式のルール定義をQA_RULESテーブルにインポートし、品質チェックルールを移行・復元することを目的としている。

### 本機能の処理概要

本機能は、JSON形式で記述されたQUASTO品質チェックルールをデータベースにインポートする機能である。

**業務上の目的・背景**：品質チェックルールは開発環境や本番環境間で共有される必要があり、また災害復旧やバージョン管理の観点からもルールのバックアップ・復元機能が求められる。本機能により、ルール定義の環境間移行、バックアップからの復旧、およびチーム間でのルール共有が実現できる。

**機能の利用シーン**：開発環境で作成したルールを本番環境に移行する場合、別プロジェクトで定義済みのルールを流用する場合、バックアップファイルからルールを復元する場合に利用される。APEXアプリケーションの「Rule Files」画面から操作可能。

**主要な処理内容**：
1. APEXアプリケーションからアップロードされたJSONファイルの読み込み
2. MIMEタイプの検証（application/json）
3. QA_IMPORT_FILESテーブルへのCLOBデータの保存
4. JSON_TABLE関数を用いたJSONパース処理
5. MERGE文によるQA_RULESテーブルへの挿入/更新

**関連システム・外部連携**：APEXアプリケーション（Rule Files画面）からのファイルアップロード連携、APEX_APPLICATION_TEMP_FILESを介した一時ファイル取得

**権限による制御**：特定のロールや権限による制御はコード上確認されない。APEXアプリケーションレベルの認証・認可設定に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Rule Files | 主画面 | JSONファイルをアップロードしてルールをインポート |

## 機能種別

データ連携（インポート）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_file_name | VARCHAR2 | Yes | APEXアップロードファイル名 | APEX_APPLICATION_TEMP_FILESに存在する必要がある |
| pi_qaif_id | NUMBER | Yes（内部処理用） | QA_IMPORT_FILESテーブルの主キー | 該当レコードが存在する必要がある |

### 入力データソース

- APEXアプリケーションからのファイルアップロード（APEX_APPLICATION_TEMP_FILES）
- QA_IMPORT_FILESテーブル（中間保存されたCLOBデータ）

### JSON入力フォーマット

```json
{
  "version": 1.1,
  "qa_rules": [
    {
      "client_names": [
        {
          "client_name": "クライアント名",
          "categories": [
            {
              "category": "カテゴリ名",
              "rules": [
                {
                  "rule_number": "ルール番号",
                  "name": "ルール名",
                  "object_types": "オブジェクトタイプ",
                  "error_message": "エラーメッセージ",
                  "comment": "コメント",
                  "exclude_objects": "除外オブジェクト",
                  "error_level": 1,
                  "is_active": 1,
                  "sql": "SELECT文",
                  "predecessor_ids": "",
                  "layer": "レイヤー"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qaif_id | NUMBER | インポートファイルID（f_import_clob_to_qa_import_filesの戻り値） |

### 出力先

- QA_IMPORT_FILESテーブル（インポートファイル履歴）
- QA_RULESテーブル（品質チェックルール定義）

## 処理フロー

### 処理シーケンス

```
1. APEXからのファイルアップロード処理（p_upload_rules_json）
   └─ APEX_APPLICATION_TEMP_FILESからファイル情報取得
2. MIMEタイプ検証
   └─ application/json以外はエラー
3. QA_IMPORT_FILESへの保存（f_import_clob_to_qa_import_files）
   └─ CLOBデータ、ファイル名、MIMEタイプを保存
4. QA_RULESへのインポート（p_import_clob_to_rules_table）
   └─ JSON_TABLEでパース
   └─ MERGE文で挿入/更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[APEX_APPLICATION_TEMP_FILESからファイル取得]
    B --> C{MIMEタイプ = application/json?}
    C -->|No| D[エラー: Invalid MIME type]
    C -->|Yes| E[f_import_clob_to_qa_import_files呼出]
    E --> F[QA_IMPORT_FILESにINSERT]
    F --> G[p_import_clob_to_rules_table呼出]
    G --> H[QA_IMPORT_FILESからCLOB取得]
    H --> I[JSON_TABLEでパース]
    I --> J{各ルールに対してループ}
    J --> K[MERGE INTO QA_RULES]
    K --> J
    J -->|終了| L[正常終了]
    D --> M[例外処理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | MIMEタイプ検証 | インポートファイルはapplication/json形式でなければならない | ファイルアップロード時 |
| BR-02 | ルール一意性 | client_nameとrule_numberの組み合わせが一意である | MERGE実行時 |
| BR-03 | 既存ルール更新 | 同一キーのルールが存在する場合は更新、存在しない場合は挿入 | MERGE実行時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル保存 | QA_IMPORT_FILES | INSERT | アップロードファイルのCLOBデータを保存 |
| ルールインポート | QA_RULES | MERGE (INSERT/UPDATE) | JSONからパースしたルールを挿入または更新 |

### テーブル別操作詳細

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qaif_filename | pi_filename（入力パラメータ） | ファイル名 |
| INSERT | qaif_mimetype | pi_mimetype（入力パラメータ） | MIMEタイプ |
| INSERT | qaif_clob_data | to_clob(pi_clob) | JSONデータ本体 |
| INSERT | qaif_created_on | DEFAULT（sysdate） | 作成日時 |
| INSERT | qaif_created_by | DEFAULT（user） | 作成者 |

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| MERGE | qaru_client_name | JSON path: $.client_name | マッチキー |
| MERGE | qaru_rule_number | JSON path: $.rule_number | マッチキー |
| MERGE | qaru_category | JSON path: $.category | 更新/挿入 |
| MERGE | qaru_name | JSON path: $.name | 更新/挿入 |
| MERGE | qaru_object_types | JSON path: $.object_types | 更新/挿入 |
| MERGE | qaru_error_message | JSON path: $.error_message | 更新/挿入 |
| MERGE | qaru_comment | JSON path: $.comment | 更新/挿入 |
| MERGE | qaru_exclude_objects | JSON path: $.exclude_objects | 更新/挿入 |
| MERGE | qaru_error_level | JSON path: $.error_level | 更新/挿入 |
| MERGE | qaru_is_active | JSON path: $.is_active | 更新/挿入 |
| MERGE | qaru_sql | JSON path: $.sql | 更新/挿入 |
| MERGE | qaru_predecessor_ids | JSON path: $.predecessor_ids | 更新/挿入 |
| MERGE | qaru_layer | JSON path: $.layer | 更新/挿入 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | MIMEタイプがapplication/json以外 | 正しいJSON形式のファイルをアップロード |
| NO_DATA_FOUND | システムエラー | 指定されたqaif_idが存在しない | ファイルアップロードを再実行 |
| OTHERS | システムエラー | その他のランタイムエラー | ログを確認し問題を特定 |

### リトライ仕様

特になし（手動での再アップロードが必要）

## トランザクション仕様

- f_import_clob_to_qa_import_files: 暗黙コミット（RETURNING句使用のため）
- p_import_clob_to_rules_table: 暗黙コミット（MERGE文実行後）

## パフォーマンス要件

- JSON_TABLE関数による効率的なパース処理
- MERGE文による一括挿入/更新

## セキュリティ考慮事項

- MIMEタイプ検証によるファイル形式の制限
- qa_logger_pkgによる操作ログの記録
- SQLインジェクション対策（パラメータバインド使用）

## 備考

- JSONバージョン番号（version）はエクスポート時に1.1として出力されるが、インポート時には検証されない
- DBMS_OUTPUT.PUT_LINEによる処理経過の出力あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、入出力に関わるテーブル構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | インポートファイル保存先テーブルの構造（qaif_id, qaif_clob_data等） |
| 1-2 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | ルール定義テーブルの構造（qaru_client_name, qaru_rule_number等） |

**読解のコツ**: Oracle DDLの`VARCHAR2(200 CHAR)`はCHARセマンティクスで200文字を意味する。CLOBはLarge Objectで大容量テキストを格納。

#### Step 2: エントリーポイントを理解する

APEX画面からの呼び出し起点となるプロシージャを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_json（117-161行目）がAPEXからのエントリーポイント |

**主要処理フロー**:
1. **134-141行目**: APEX_APPLICATION_TEMP_FILESからBLOBをCLOBに変換して取得
2. **143-146行目**: MIMEタイプ検証（application/json以外はエラー）
3. **148-150行目**: f_import_clob_to_qa_import_files呼び出し
4. **152行目**: p_import_clob_to_rules_table呼び出し

#### Step 3: コアロジックを理解する

インポート処理の本体となるパッケージを解析する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_import_clob_to_qa_import_files（318-364行目）とp_import_clob_to_rules_table（367-463行目） |

**主要処理フロー**:
- **340-348行目**: QA_IMPORT_FILESへのINSERT（RETURNING句でIDを取得）
- **378-381行目**: QA_IMPORT_FILESからCLOBデータを取得
- **385-399行目**: JSON_TABLEによるJSONパース（ネストされたパス指定に注目）
- **403-447行目**: MERGE文による挿入/更新処理

**読解のコツ**: JSON_TABLEの`nested path`句は階層的なJSONを平坦化する。`columns`句で各階層からフィールドを抽出。

### プログラム呼び出し階層図

```
qa_apex_app_pkg.p_upload_rules_json
    │
    ├─ APEX_APPLICATION_TEMP_FILES (SELECT)
    │
    ├─ qa_export_import_rules_pkg.f_import_clob_to_qa_import_files
    │      └─ QA_IMPORT_FILES (INSERT)
    │
    └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table
           ├─ QA_IMPORT_FILES (SELECT)
           └─ QA_RULES (MERGE)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

JSONファイル                   p_upload_rules_json
(APEX Upload)                        │
     │                               ▼
     └───▶ APEX_APPLICATION_TEMP_FILES
                 │                   │
                 ▼                   ▼
          BLOBをCLOBに変換   f_import_clob_to_qa_import_files ───▶ QA_IMPORT_FILES
                                     │                            (インポート履歴)
                                     ▼
                         p_import_clob_to_rules_table
                                     │
                                     ▼
                              JSON_TABLE (パース)
                                     │
                                     ▼
                              MERGE INTO QA_RULES ───────────────▶ QA_RULES
                                                                  (ルール定義)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | エクスポート/インポートの主要ロジック |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEXアプリケーション向けインターフェース |
| qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | DDL | インポートファイル格納テーブル |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | ルール定義格納テーブル |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | ロギング処理 |
