# 機能設計書 12-インポートファイル管理

## 概要

本ドキュメントは、QUASTOシステムにおける「インポートファイル管理」機能の設計内容を記述するものである。本機能は、インポートされたJSONルールファイルをQA_IMPORT_FILESテーブルに永続的に保存し、インポート履歴の追跡と管理を行う。

### 本機能の処理概要

本機能は、ルールJSONインポート時にアップロードされたファイルをデータベースに保存し、インポート履歴として管理する機能である。

**業務上の目的・背景**：ルールのインポート操作はシステム設定変更に相当する重要な操作であり、いつ・誰が・どのようなファイルをインポートしたかを追跡できることが運用上必要である。本機能により、インポート履歴の監査、問題発生時のトレーサビリティ確保、およびインポートファイルの再参照が可能となる。

**機能の利用シーン**：ルールJSONインポート時に自動的に履歴が保存される。また、過去のインポート内容を確認する際や、インポート問題の調査時に参照される。

**主要な処理内容**：
1. JSONファイルのCLOBデータ受け取り
2. ファイル名、MIMEタイプとともにテーブルに保存
3. 作成者・作成日時の自動記録
4. インポートファイルIDの発行と返却

**関連システム・外部連携**：ルールJSONインポート機能（No.11）から内部呼び出しされる。直接的な画面からの操作はない。

**権限による制御**：特定のロールや権限による制御はコード上確認されない。呼び出し元の権限設定に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | 内部処理 | ルールJSONインポート時に内部的に呼び出される |

## 機能種別

データ管理（履歴保存）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_clob | CLOB | Yes | インポートファイルの内容 | NULL不可 |
| pi_filename | VARCHAR2(200 CHAR) | Yes | ファイル名 | NULL不可 |
| pi_mimetype | VARCHAR2(200 CHAR) | Yes | MIMEタイプ | NULL不可 |

### 入力データソース

- ルールJSONインポート機能（qa_apex_app_pkg.p_upload_rules_json）からの内部呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qaif_id | NUMBER | 生成されたインポートファイルID（シーケンスによる採番） |

### 出力先

- QA_IMPORT_FILESテーブル
- 戻り値としてqaif_id

## 処理フロー

### 処理シーケンス

```
1. パラメータのログ記録
   └─ qa_logger_pkg.append_paramでパラメータを記録
2. QA_IMPORT_FILESへのINSERT
   └─ ファイル名、MIMEタイプ、CLOBデータを保存
   └─ RETURNING句でqaif_idを取得
3. qaif_idの返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータをログに記録]
    B --> C[QA_IMPORT_FILESにINSERT]
    C --> D[RETURNING句でqaif_idを取得]
    D --> E{INSERT成功?}
    E -->|Yes| F[qaif_idを返却]
    E -->|No| G[例外処理]
    G --> H[qa_logger_pkg.p_qa_logでエラー記録]
    H --> I[例外を再スロー]
    F --> J[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須フィールド | ファイル名、MIMEタイプ、CLOBデータはすべて必須 | INSERT時 |
| BR-02 | 自動採番 | qaif_idはシーケンスにより自動採番される | INSERT時 |
| BR-03 | 作成情報自動設定 | qaif_created_on、qaif_created_byはDEFAULT値で自動設定 | INSERT時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル保存 | QA_IMPORT_FILES | INSERT | インポートファイル情報を保存 |

### テーブル別操作詳細

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qaif_id | シーケンス自動採番 | 主キー |
| INSERT | qaif_filename | pi_filename | ファイル名 |
| INSERT | qaif_mimetype | pi_mimetype | MIMEタイプ |
| INSERT | qaif_clob_data | to_clob(pi_clob) | ファイル内容 |
| INSERT | qaif_status | NULL（省略） | ステータス |
| INSERT | qaif_error_log | NULL（省略） | エラーログ |
| INSERT | qaif_created_on | DEFAULT sysdate | 作成日時 |
| INSERT | qaif_created_by | DEFAULT user | 作成者 |
| INSERT | qaif_updated_on | DEFAULT sysdate | 更新日時 |
| INSERT | qaif_updated_by | DEFAULT user | 更新者 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_DATA_FOUND | システムエラー | INSERT失敗時（通常発生しない） | ログを確認し問題を特定 |
| OTHERS | システムエラー | その他のランタイムエラー | ログを確認し問題を特定 |

### リトライ仕様

特になし（呼び出し元でのリトライが必要）

## トランザクション仕様

- 本関数自体ではCOMMIT/ROLLBACKを発行しない
- 呼び出し元でトランザクション制御を行う

## パフォーマンス要件

- 単一INSERT処理のため、特段のパフォーマンス要件なし
- CLOB格納のため、大容量ファイルの場合はI/O負荷に注意

## セキュリティ考慮事項

- qa_logger_pkgによる操作パラメータのログ記録（CLOBは先頭4000バイトのみ）
- ユーザー情報の自動記録（qaif_created_by）

## 備考

- qaif_statusおよびqaif_error_logカラムは本機能では使用されていない（将来拡張用と推測）
- 本機能は内部関数であり、直接の画面呼び出しはない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | テーブル構造（10カラム）とDEFAULT値の設定 |

**読解のコツ**: DEFAULT値が設定されたカラム（qaif_created_on、qaif_created_by等）はINSERT時に省略可能。CLOB型は大容量テキストを格納するOracle固有のデータ型。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_import_clob_to_qa_import_files関数（318-364行目） |

**主要処理フロー**:
1. **325-326行目**: 定数定義（c_unit: スコープ名）
2. **331-338行目**: パラメータのログ記録（CLOBは先頭4000バイトのみ）
3. **340-348行目**: QA_IMPORT_FILESへのINSERT（RETURNING句でID取得）
4. **350行目**: qaif_idの返却

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_json（148-150行目）からの呼び出し |

**読解のコツ**: RETURNING句は、INSERT文の実行と同時に生成されたシーケンス値を取得する効率的な方法。

### プログラム呼び出し階層図

```
qa_apex_app_pkg.p_upload_rules_json
    │
    └─ qa_export_import_rules_pkg.f_import_clob_to_qa_import_files
           │
           ├─ qa_logger_pkg.append_param (パラメータログ)
           │
           └─ QA_IMPORT_FILES (INSERT)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_clob                   f_import_clob_to_qa_import_files
(CLOB)                           │
     │                           ▼
pi_filename               qa_logger_pkg.append_param
(VARCHAR2)                       │
     │                           ▼
pi_mimetype               INSERT INTO QA_IMPORT_FILES ───────────▶ QA_IMPORT_FILES
(VARCHAR2)                       │                                 (永続化)
                                 ▼
                          RETURNING qaif_id ─────────────────────▶ 戻り値
                                                                   (NUMBER)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | f_import_clob_to_qa_import_files関数を含む |
| qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | DDL | インポートファイル格納テーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | ロギング処理 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | 呼び出し元（参考） |
