# 機能設計書 14-ユニットテストパッケージ生成

## 概要

本ドキュメントは、QUASTOシステムにおける「ユニットテストパッケージ生成」機能の設計内容を記述するものである。本機能は、定義されたルールに基づいてutPLSQL準拠のユニットテストパッケージを自動生成し、品質チェックルールの自動テスト実行基盤を構築する。

### 本機能の処理概要

本機能は、QA_RULESテーブルに定義されたルールを元に、utPLSQLフレームワークで実行可能なPL/SQLパッケージを動的に生成する機能である。

**業務上の目的・背景**：品質チェックルールを継続的に実行し、データモデルやコードの品質を維持するためには、自動化されたテスト実行基盤が必要である。本機能により、手動でのテスト作成負荷を削減し、utPLSQLの標準的なテスト実行フローに統合することで、CI/CD環境での品質チェック自動化が実現できる。

**機能の利用シーン**：新規ルール追加後のテスト環境構築、テスト対象スキーマの変更時、定期的なテストパッケージ再生成時に利用される。APEXアプリケーションの「Unit Test Generation」画面から操作可能。

**主要な処理内容**：
1. 入力パラメータの検証（オプション値、スキーマ名の存在確認）
2. ルール定義の存在確認
3. 既存テストパッケージの削除（再生成のため）
4. スキーマ名リストの取得（指定なしの場合は全スキーマ）
5. オプションに応じたパッケージ生成（単一パッケージまたはルール単位パッケージ）
6. EXECUTE IMMEDIATEによるパッケージ作成

**関連システム・外部連携**：utPLSQLフレームワークとの連携（suitepath、test annotation使用）、DBMS_SCHEDULERとの連携（定期実行）

**権限による制御**：パッケージ作成権限（CREATE PROCEDURE）が必要。AUTHID DEFINER権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Unit Test Generation | 主画面 | スキーム選択後、Generateボタン押下でユニットテストパッケージを生成 |

## 機能種別

コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_option | NUMBER | Yes | 生成方式（1:単一パッケージ、2:ルール単位パッケージ） | 1または2のみ有効 |
| pi_scheme_names | VARCHAR2_TAB_T | No | 対象スキーマ名配列 | NULL許可（全スキーマ対象）、指定時は存在確認 |

### 入力データソース

- QA_RULESテーブル（ルール定義）
- qa_scheme_names_for_testing_vビュー（テスト対象スキーマ一覧）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テストパッケージ | PL/SQL PACKAGE | utPLSQL準拠のテストパッケージ（spec + body） |

### 出力先

- データベースオブジェクトとして生成（user_objects）
- DBMS_OUTPUTへのログ出力

### 生成パッケージ形式

```sql
CREATE OR REPLACE PACKAGE qa_ut_{scheme}_{client}_pkg IS
  --%suite(Tests of {client} on {SCHEME})
  --%suitepath(quasto.{client}.{scheme})

  c_scheme_name constant varchar2_tab_t := new varchar2_tab_t('{SCHEME}');
  c_client_name constant qa_rules.qaru_client_name%type := '{client}';

  --%test(quasto_test_rule_{rule_number}_{rule_name})
  PROCEDURE p_ut_rule_{rule_number};
END qa_ut_{scheme}_{client}_pkg;
```

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ検証（p_validate_input）
   └─ pi_optionが1または2であることを確認
   └─ pi_scheme_namesの各スキーマが存在することを確認
2. ルール存在確認（p_verify_rules）
   └─ qa_main_pkg.f_exist_rulesでルール有無を確認
3. 既存パッケージ削除（p_delete_unit_test_packages）
   └─ QA_UT_プレフィックスのパッケージをDROP
4. スキーマ名リスト取得
   └─ 指定なしの場合はf_get_all_scheme_namesで全取得
5. オプション別パッケージ生成
   └─ オプション1：クライアント単位でパッケージ生成
   └─ オプション2：ルール単位でパッケージ生成
6. EXECUTE IMMEDIATEでパッケージ作成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[p_validate_input]
    B --> C{検証OK?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[p_verify_rules]
    E --> F{ルール存在?}
    F -->|No| G[エラー: No rules defined]
    F -->|Yes| H[p_delete_unit_test_packages]
    H --> I{pi_scheme_names指定?}
    I -->|No| J[f_get_all_scheme_names]
    I -->|Yes| K[指定スキーマを使用]
    J --> L{pi_option?}
    K --> L
    L -->|1| M[単一パッケージ生成]
    L -->|2| N[ルール単位パッケージ生成]
    M --> O[EXECUTE IMMEDIATE]
    N --> O
    O --> P[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | オプション制限 | pi_optionは1（gc_utplsql_single_package）または2（gc_utplsql_single_package_per_rule）のみ | パラメータ検証時 |
| BR-02 | スキーマ存在確認 | 指定されたスキーマはqa_scheme_names_for_testing_vに存在する必要がある | パラメータ検証時 |
| BR-03 | ルール必須 | アクティブなルールが1件以上存在する必要がある | ルール検証時 |
| BR-04 | アクティブルールのみ | qaru_is_active = 1のルールのみテスト生成対象 | パッケージ生成時 |
| BR-05 | 既存削除 | 生成前に既存の同名パッケージを削除 | パッケージ生成時 |

### 計算ロジック

- パッケージ名: `qa_ut_{scheme}_{client}_pkg`（オプション1）または `qa_ut_{scheme}_{client}_{rule_name}_pkg`（オプション2）
- suitepath: `quasto.{client_unified}.{scheme}`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール取得 | QA_RULES | SELECT | アクティブなルール一覧を取得 |
| スキーマ取得 | qa_scheme_names_for_testing_v | SELECT | テスト対象スキーマ一覧を取得 |
| パッケージ削除 | user_objects | SELECT + DDL | 既存パッケージの検索と削除 |
| パッケージ作成 | - | DDL | CREATE PACKAGE文の実行 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_client_name | WHERE qaru_is_active = 1 | クライアント名取得 |
| SELECT | qaru_rule_number | WHERE qaru_is_active = 1 | ルール番号取得 |
| SELECT | qaru_name | WHERE qaru_is_active = 1 | ルール名取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | pi_optionが1,2以外 | 有効なオプション値を指定 |
| -20001 | ユーザー定義エラー | スキーマ名が存在しない | 存在するスキーマ名を指定 |
| -20001 | ユーザー定義エラー | ルールが定義されていない | ルールを定義してから実行 |
| OTHERS | システムエラー | パッケージ作成失敗 | ログを確認し問題を特定 |

### リトライ仕様

特になし（エラー原因を解消後に再実行）

## トランザクション仕様

- DDL文（CREATE/DROP PACKAGE）は暗黙コミットを発生させる
- 途中でエラーが発生した場合、それまでに作成されたパッケージは残る

## パフォーマンス要件

- dbms_output.enable(buffer_size => 10000000)で十分なバッファを確保
- 多数のルール・スキーマの組み合わせでは生成時間に注意

## セキュリティ考慮事項

- AUTHID DEFINER権限での実行（パッケージ所有者の権限）
- CREATE PROCEDURE権限が必要
- qa_logger_pkgによる操作ログの記録

## 備考

- 生成されるパッケージはutPLSQLの%suite、%suitepath、%testアノテーションを使用
- パッケージプレフィックスはqa_constant_pkg.gc_utplsql_ut_test_packages_prefix（'QA_UT_'）で定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | ルール定義テーブル構造（qaru_client_name, qaru_rule_number等） |
| 1-2 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | 定数定義（gc_utplsql_single_package等） |

**読解のコツ**: 定数パッケージは動的生成されるため、install_constant_package.sqlで定義を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_unit_test_packages（657-823行目）がメイン処理 |

**主要処理フロー**:
1. **673-674行目**: p_validate_input呼び出し（入力検証）
2. **676行目**: p_verify_rules呼び出し（ルール存在確認）
3. **678行目**: p_delete_unit_test_packages呼び出し（既存削除）
4. **680-684行目**: スキーマ名リスト取得
5. **686-752行目**: オプション1の処理（単一パッケージ）
6. **754-807行目**: オプション2の処理（ルール単位パッケージ）

#### Step 3: 検証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_validate_input（299-344行目） |
| 3-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_verify_rules（346-370行目） |

**主要処理フロー**:
- **312-315行目**: pi_optionの検証（gc_utplsql_single_package, gc_utplsql_single_package_per_rule）
- **318-330行目**: スキーマ名の存在確認（qa_scheme_names_for_testing_vとの照合）
- **353-358行目**: ルール存在確認（qa_main_pkg.f_exist_rules呼び出し）

#### Step 4: パッケージ生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_package_spec_header（403-457行目） |
| 4-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_package_spec_content（459-491行目） |
| 4-3 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_package_body_content（556-623行目） |

**読解のコツ**: パッケージ生成は header → content（ループ） → footer の順で文字列を連結。EXECUTE IMMEDIATEで実行。

### プログラム呼び出し階層図

```
p_create_unit_test_packages
    │
    ├─ qa_logger_pkg.append_param (パラメータログ)
    │
    ├─ p_validate_input
    │      └─ qa_scheme_names_for_testing_v (SELECT)
    │
    ├─ p_verify_rules
    │      └─ qa_main_pkg.f_exist_rules
    │
    ├─ p_delete_unit_test_packages
    │      └─ user_objects (SELECT)
    │      └─ DROP PACKAGE
    │
    ├─ f_get_all_scheme_names
    │      └─ qa_scheme_names_for_testing_v (SELECT)
    │
    ├─ f_get_package_spec_header
    │      └─ f_get_suitepath
    │
    ├─ f_get_package_spec_content
    │
    ├─ f_get_package_spec_footer
    │
    ├─ f_get_package_body_header
    │
    ├─ f_get_package_body_content
    │
    ├─ f_get_package_body_footer
    │
    └─ EXECUTE IMMEDIATE (CREATE PACKAGE)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_option          ───▶ p_validate_input
(1 or 2)                       │
                               ▼
pi_scheme_names    ───▶ p_verify_rules
(VARCHAR2_TAB_T)               │
                               ▼
QA_RULES          ───▶ p_delete_unit_test_packages ───▶ DROP PACKAGE
(SELECT)                       │
                               ▼
qa_scheme_names    ───▶ パッケージコード生成
_for_testing_v            │
(SELECT)                  ▼
                   f_get_package_spec_* / f_get_package_body_*
                               │
                               ▼
                   EXECUTE IMMEDIATE ──────────────────▶ QA_UT_*_PKG
                                                        (PL/SQL Package)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | メイン処理パッケージ |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | ルール定義テーブル |
| qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | ビュー | テスト対象スキーマ一覧 |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | 定数パッケージ定義 |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | f_get_unified_string等のユーティリティ |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | f_exist_rules等のルール操作 |
