# 機能設計書 15-ユニットテストパッケージ削除

## 概要

本ドキュメントは、QUASTOシステムにおける「ユニットテストパッケージ削除」機能の設計内容を記述するものである。本機能は、自動生成されたutPLSQL準拠のユニットテストパッケージをデータベースから削除する。

### 本機能の処理概要

本機能は、p_create_unit_test_packagesで生成されたQA_UT_プレフィックスを持つテストパッケージを削除する機能である。

**業務上の目的・背景**：テストパッケージの再生成時には既存パッケージの削除が必要であり、また不要になったテストパッケージのクリーンアップ機能も運用上必要である。本機能により、テスト環境のクリーンアップ、パッケージ再生成前の準備、特定スキーマのテスト削除が実現できる。

**機能の利用シーン**：テストパッケージ再生成時の前処理、テスト対象スキーマの削除・変更時、テスト環境のリセット時に利用される。APEXアプリケーションの「Unit Test Generation」画面から操作可能。

**主要な処理内容**：
1. スキーマ名指定の有無による処理分岐
2. user_objectsからQA_UT_プレフィックスのパッケージを検索
3. DROP PACKAGE文による削除実行
4. 削除結果のDBMS_OUTPUT出力

**関連システム・外部連携**：ユニットテストパッケージ生成機能（No.14）から内部呼び出しされる。また、単独でも利用可能。

**権限による制御**：DROP ANY PROCEDUREまたは自スキーマのパッケージ削除権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Unit Test Generation | 主画面 | Deleteボタン押下で既存のユニットテストパッケージを削除 |

## 機能種別

メンテナンス処理（オブジェクト削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_scheme_names | VARCHAR2_TAB_T | No | 対象スキーマ名配列 | NULL許可（全パッケージ対象） |

### 入力データソース

- user_objectsビュー（既存パッケージ検索）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | - | プロシージャのため戻り値なし |

### 出力先

- データベースオブジェクトの削除
- DBMS_OUTPUTへのログ出力

## 処理フロー

### 処理シーケンス

```
1. スキーマ名指定の確認
   └─ 指定あり：スキーマ単位でループ処理
   └─ 指定なし：全QA_UT_パッケージを対象
2. user_objectsからパッケージ検索
   └─ LIKE条件でQA_UT_プレフィックスを検索
   └─ スキーマ指定時は追加条件を付与
3. DROP PACKAGE実行
   └─ EXECUTE IMMEDIATEで動的実行
4. 削除結果のログ出力
   └─ DBMS_OUTPUT.PUT_LINEで出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{pi_scheme_names指定?}
    B -->|Yes| C[スキーマごとにループ]
    B -->|No| D[全パッケージを対象]
    C --> E[user_objectsからパッケージ検索]
    D --> F[user_objectsからパッケージ検索]
    E --> G{パッケージあり?}
    F --> G
    G -->|Yes| H[DROP PACKAGE実行]
    G -->|No| I[次のスキーマへ]
    H --> J[削除ログ出力]
    J --> G
    I --> K{全スキーマ完了?}
    K -->|No| C
    K -->|Yes| L[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | プレフィックス一致 | QA_UT_プレフィックスを持つパッケージのみ削除対象 | 全検索 |
| BR-02 | スキーマ限定 | スキーマ名指定時はそのスキーマのパッケージのみ削除 | スキーマ指定時 |
| BR-03 | PACKAGE型のみ | object_type = 'PACKAGE'のオブジェクトのみ対象 | 検索条件 |

### 計算ロジック

- LIKE条件: `object_name LIKE replace(upper(gc_utplsql_ut_test_packages_prefix || pi_scheme_names) || '_%', '_', '\_') escape '\'`
- プレフィックスのアンダースコアをエスケープ処理

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッケージ検索 | user_objects | SELECT | 削除対象パッケージの検索 |
| パッケージ削除 | - | DDL | DROP PACKAGE文の実行 |

### テーブル別操作詳細

#### user_objects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | object_name | WHERE object_type = 'PACKAGE' AND object_name LIKE 'QA_UT_%' | パッケージ名取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OTHERS | システムエラー | DROP PACKAGE失敗 | ログを確認し問題を特定 |

### リトライ仕様

特になし

## トランザクション仕様

- DDL文（DROP PACKAGE）は暗黙コミットを発生させる
- 途中でエラーが発生した場合、それまでに削除されたパッケージは復元されない

## パフォーマンス要件

- 多数のパッケージ削除時はDDL実行回数に応じた処理時間

## セキュリティ考慮事項

- パッケージ削除権限が必要
- qa_logger_pkgによる操作ログの記録

## 備考

- p_create_unit_test_packagesから内部的に呼び出される
- p_delete_unit_tests_for_schemesがラッパー関数として提供される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | gc_utplsql_ut_test_packages_prefixの定義（'QA_UT_'） |

**読解のコツ**: パッケージ名のプレフィックスは定数で定義されているため、変更時は定数パッケージを確認。

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_delete_unit_test_packages（825-871行目） |

**主要処理フロー**:
1. **834-847行目**: スキーマ名指定時の処理
   - スキーマごとにループ
   - `QA_UT_{scheme}_%`パターンでパッケージ検索
   - DROP PACKAGE実行
2. **848-858行目**: スキーマ名未指定時の処理
   - `QA_UT_%`パターンで全パッケージ検索
   - DROP PACKAGE実行
3. **845, 856行目**: DBMS_OUTPUT.PUT_LINEでログ出力

**読解のコツ**: LIKE条件でアンダースコアをエスケープするため、`replace(..., '_', '\_') escape '\'`を使用。

#### Step 3: ラッパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_delete_unit_tests_for_schemes（1523-1552行目） |

**主要処理フロー**:
- **1536-1538行目**: スキーマ名未指定時は全削除
- **1540-1542行目**: コロン区切り文字列をVARCHAR2_TAB_Tに変換して呼び出し

### プログラム呼び出し階層図

```
p_delete_unit_tests_for_schemes (ラッパー)
    │
    └─ p_delete_unit_test_packages
           │
           ├─ qa_logger_pkg.p_qa_log (エラー時)
           │
           ├─ user_objects (SELECT)
           │
           └─ DROP PACKAGE (EXECUTE IMMEDIATE)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_scheme_names    ───▶ p_delete_unit_test_packages
(VARCHAR2_TAB_T)               │
                               ▼
                        ┌─────────────────┐
                        │ スキーマ指定?   │
                        └────────┬────────┘
                    ┌────────────┴────────────┐
                    ▼                         ▼
             スキーマ別検索              全パッケージ検索
             QA_UT_{scheme}_%          QA_UT_%
                    │                         │
                    └────────────┬────────────┘
                                 ▼
user_objects ───▶      パッケージ一覧取得
(SELECT)                         │
                                 ▼
                        DROP PACKAGE ───────────────▶ パッケージ削除
                                 │
                                 ▼
                        DBMS_OUTPUT ────────────────▶ ログ出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | p_delete_unit_test_packages関数を含む |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_utplsql_ut_test_packages_prefix定義 |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | f_get_string_as_table（ラッパーで使用） |
