# 機能設計書 16-全ユニットテスト実行

## 概要

本ドキュメントは、QUASTOシステムにおける「全ユニットテスト実行」機能の設計内容を記述するものである。本機能は、生成された全てのutPLSQLユニットテストを実行し、結果をXML形式でデータベースに保存する。

### 本機能の処理概要

本機能は、utPLSQLフレームワークを使用して全ての品質チェックルールのテストを一括実行し、JUnit形式のXML結果を生成・保存する機能である。

**業務上の目的・背景**：品質チェックルールを定期的または任意のタイミングで一括実行し、システム全体の品質状態を把握する必要がある。本機能により、スケジューラによる定期実行、手動での一括テスト実行、XML形式での結果取得が実現できる。

**機能の利用シーン**：夜間バッチでの定期品質チェック、リリース前の品質確認、ダッシュボードでの結果表示用データ取得時に利用される。APEXアプリケーションの「Config Scheduler Job」画面から「Run Cronjob Now」ボタンで手動実行も可能。

**主要な処理内容**：
1. 入力パラメータの検証
2. suitepathの決定（クライアント名・スキーマ名指定時は絞り込み）
3. utPLSQL ut.run関数の呼び出し
4. XML結果のCLOB変換
5. QA_TEST_RESULTSテーブルへの保存

**関連システム・外部連携**：utPLSQLフレームワーク（ut.run関数、ut_junit_reporter）、DBMS_SCHEDULER（定期実行ジョブ）

**権限による制御**：utPLSQL実行権限、QA_TEST_RESULTSへのINSERT権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | Config Scheduler Job | API連携 | Run Cronjob Nowボタン押下で全ユニットテストを手動実行 |

## 機能種別

テスト実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_client_name | VARCHAR2 | No | 対象クライアント名 | NULL許可 |
| pi_scheme_name | VARCHAR2 | No | 対象スキーマ名 | NULL許可 |
| pi_quasto_scheme | VARCHAR2 | No | QUASTOスキーマ名（デフォルト: 現在のユーザー） | 必須 |
| pi_character_set | VARCHAR2 | No | XMLエンコーディング（デフォルト: Windows-1251） | 必須 |

### 入力データソース

- 生成済みのユニットテストパッケージ（QA_UT_*）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | CLOB | JUnit形式のXMLテスト結果（f_run_all_unit_tests） |

### 出力先

- QA_TEST_RESULTSテーブル（XML結果）
- 関数戻り値（f_run_all_unit_testsの場合）

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ検証
   └─ pi_quasto_scheme、pi_character_setがNULLでないことを確認
2. suitepath決定
   └─ クライアント名・スキーマ名指定：特定パス
   └─ 未指定：ルートパス（quasto）
3. DBMS_OUTPUT有効化
   └─ buffer_size = 1000000
4. utPLSQL実行
   └─ ut.run関数呼び出し
   └─ ut_junit_reporter()でJUnit形式出力
5. XML結果取得
   └─ XMLAGG、XMLELEMENTでCLOB変換
6. QA_TEST_RESULTSへINSERT
   └─ 実行説明とともに保存
7. 結果返却（f_run_all_unit_testsの場合）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|NG| C[エラー: Missing parameter]
    B -->|OK| D{クライアント名/スキーマ名指定?}
    D -->|Yes| E[特定suitepath設定]
    D -->|No| F[ルートsuitepath設定]
    E --> G[DBMS_OUTPUT有効化]
    F --> G
    G --> H[ut.run実行]
    H --> I[XML結果をCLOB変換]
    I --> J[QA_TEST_RESULTSにINSERT]
    J --> K{関数呼び出し?}
    K -->|Yes| L[CLOB返却]
    K -->|No| M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須パラメータ | pi_quasto_schemeとpi_character_setは必須 | パラメータ検証時 |
| BR-02 | suitepath決定 | クライアント名・スキーマ名両方指定時のみ特定パスを使用 | suitepath設定時 |
| BR-03 | 結果保存 | すべての実行結果をQA_TEST_RESULTSに保存 | 実行完了時 |

### 計算ロジック

- suitepath計算: `{quasto_scheme}:quasto.{client_unified}.{scheme}` または `{quasto_scheme}:quasto`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト実行 | QA_UT_* | EXECUTE | 生成されたテストパッケージの実行 |
| 結果保存 | QA_TEST_RESULTS | INSERT | XML結果の保存 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_xml_result | l_xml_result（CLOB） | テスト結果XML |
| INSERT | qatr_description | 'Executed by Suite Path: ' + suitepath | 実行説明 |
| INSERT | qatr_added_on | DEFAULT（トリガー/シーケンス） | 追加日時 |
| INSERT | qatr_added_by | DEFAULT（トリガー/シーケンス） | 追加者 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | pi_quasto_schemeまたはpi_character_setがNULL | 有効な値を指定 |
| OTHERS | システムエラー | utPLSQL実行エラー | ログを確認し問題を特定 |

### リトライ仕様

特になし（スケジューラジョブによる再実行が可能）

## トランザクション仕様

- QA_TEST_RESULTSへのINSERTは暗黙コミット
- 個々のテスト結果（QA_TEST_RUNS, QA_TEST_RUN_INVALID_OBJECTS）はp_handle_test_result内でautonomous_transactionにより個別コミット

## パフォーマンス要件

- dbms_output.enable(buffer_size => 1000000)で十分なバッファを確保
- 多数のテスト実行時は処理時間に注意

## セキュリティ考慮事項

- utPLSQL実行権限が必要
- qa_logger_pkgによる操作ログの記録

## 備考

- p_run_all_unit_testsはf_run_all_unit_testsのラッパー（戻り値なし）
- スケジューラジョブから呼び出される場合はp_run_all_unit_testsを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | XML結果格納テーブル構造 |

**読解のコツ**: qatr_xml_resultがCLOB型でJUnit形式XMLを格納。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_run_all_unit_tests（935-988行目） |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_run_all_unit_tests（918-933行目）- ラッパー |

**主要処理フロー**:
1. **958-961行目**: パラメータ検証
2. **963-968行目**: suitepath決定
3. **970行目**: DBMS_OUTPUT有効化
4. **971-973行目**: ut.run実行とXML変換
5. **976-977行目**: QA_TEST_RESULTSへINSERT
6. **979行目**: CLOB返却

#### Step 3: utPLSQL連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_suitepath（216-249行目） |

**主要処理フロー**:
- **235-238行目**: クライアント名・スキーマ名指定時のsuitepath生成
- **240行目**: 未指定時はルートパス（gc_quasto_name = 'QUASTO'）

**読解のコツ**: utPLSQLのut.run関数はa_pathパラメータでsuitepathを指定。ut_junit_reporter()でJUnit形式出力。

### プログラム呼び出し階層図

```
p_run_all_unit_tests (プロシージャ版)
    │
    └─ f_run_all_unit_tests (関数版)
           │
           ├─ qa_logger_pkg.append_param (パラメータログ)
           │
           ├─ f_get_suitepath (suitepath決定)
           │      └─ qa_utils_pkg.f_get_unified_string
           │
           ├─ ut.run (utPLSQL実行)
           │      └─ ut_junit_reporter() (レポーター)
           │
           └─ QA_TEST_RESULTS (INSERT)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_qaru_client_name    f_run_all_unit_tests
(VARCHAR2)                     │
                               ▼
pi_scheme_name         f_get_suitepath ───▶ suitepath文字列
(VARCHAR2)                     │
                               ▼
pi_quasto_scheme       ut.run(a_path => suitepath,
(VARCHAR2)             a_reporter => ut_junit_reporter())
                               │
                               ▼
pi_character_set       XMLAGG/XMLELEMENT
(VARCHAR2)                     │
                               ▼
                        DBMS_XMLGEN.CONVERT
                               │
                               ▼
                        l_xml_result (CLOB) ─────────▶ QA_TEST_RESULTS
                               │                      (INSERT)
                               ▼
                        RETURN l_xml_result ─────────▶ 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_run_all_unit_tests、p_run_all_unit_tests |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | XML結果格納テーブル |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_quasto_name定義 |
