# 機能設計書 17-単一ユニットテスト実行

## 概要

本ドキュメントは、QUASTOシステムにおける「単一ユニットテスト実行」機能の設計内容を記述するものである。本機能は、指定したルールのユニットテストのみを実行し、結果をデータベースに保存する。

### 本機能の処理概要

本機能は、特定のルール番号・クライアント名・スキーマ名を指定して、該当するユニットテストのみを実行する機能である。

**業務上の目的・背景**：全テストの一括実行は時間がかかるため、特定のルールのみを迅速にテストしたい場面がある。本機能により、個別ルールの検証、テスト開発時のデバッグ、特定スキーマの部分テストが実現できる。

**機能の利用シーン**：ルール定義変更後の即時検証、特定ルールの問題調査、テスト開発時のデバッグ実行時に利用される。APEXアプリケーションの「Restart Unit Test」画面から操作可能。

**主要な処理内容**：
1. 入力パラメータの検証
2. ユニットテスト呼び出しパスの取得
3. utPLSQL ut.run関数の呼び出し（特定プロシージャ指定）
4. XML結果のCLOB変換
5. QA_TEST_RESULTSテーブルへの保存

**関連システム・外部連携**：utPLSQLフレームワーク（ut.run関数）、生成済みテストパッケージ（QA_UT_*）

**権限による制御**：utPLSQL実行権限、QA_TEST_RESULTSへのINSERT権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | Restart Unit Test | 主画面 | 指定したルール・スキームのユニットテストを再実行 |

## 機能種別

テスト実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2(20 CHAR) | Yes | ルール番号 | NULL不可 |
| pi_qaru_client_name | VARCHAR2(100 CHAR) | Yes | クライアント名 | NULL不可 |
| pi_scheme_name | VARCHAR2 | Yes | スキーマ名 | NULL不可 |
| pi_character_set | VARCHAR2 | No | XMLエンコーディング（デフォルト: Windows-1251） | NULL不可 |

### 入力データソース

- 生成済みのユニットテストパッケージ（QA_UT_*）
- QA_RULESテーブル（ルール定義の検索）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | - | プロシージャのため戻り値なし |

### 出力先

- QA_TEST_RESULTSテーブル（XML結果）

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータ検証
   └─ 全パラメータがNULLでないことを確認
2. ユニットテスト呼び出しパス取得
   └─ f_get_unit_test_call関数でパッケージ.プロシージャ名を取得
3. DBMS_OUTPUT有効化
   └─ buffer_size = 1000000
4. utPLSQL実行
   └─ ut.run関数呼び出し（a_path = 直接呼び出しパス）
5. XML結果取得
   └─ XMLAGG、XMLELEMENTでCLOB変換
6. QA_TEST_RESULTSへINSERT
   └─ 'Executed by PL/SQL Call: {path}'を説明として保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|NG| C[エラー: Missing parameter]
    B -->|OK| D[f_get_unit_test_call呼び出し]
    D --> E[DBMS_OUTPUT有効化]
    E --> F[ut.run実行]
    F --> G[XML結果をCLOB変換]
    G --> H[QA_TEST_RESULTSにINSERT]
    H --> I[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 全パラメータ必須 | pi_qaru_rule_number、pi_qaru_client_name、pi_scheme_name、pi_character_setはすべて必須 | パラメータ検証時 |
| BR-02 | パッケージ存在確認 | 指定条件に該当するテストパッケージが存在する必要がある | f_get_unit_test_call内 |

### 計算ロジック

- 呼び出しパス計算: `{package_name}.p_ut_rule_{rule_number_unified}`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッケージ検索 | user_objects | SELECT | テストパッケージ名の検索 |
| ルール情報取得 | QA_RULES | SELECT | ルール名の取得 |
| テスト実行 | QA_UT_* | EXECUTE | テストプロシージャの実行 |
| 結果保存 | QA_TEST_RESULTS | INSERT | XML結果の保存 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_xml_result | l_xml_result（CLOB） | テスト結果XML |
| INSERT | qatr_description | 'Executed by PL/SQL Call: ' + l_utplsql_call | 実行説明 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | 必須パラメータがNULL | すべてのパラメータを指定 |
| OTHERS | システムエラー | パッケージが存在しない、utPLSQL実行エラー | ログを確認し問題を特定 |

### リトライ仕様

特になし

## トランザクション仕様

- QA_TEST_RESULTSへのINSERTは暗黙コミット

## パフォーマンス要件

- 単一テストのため、通常は短時間で完了

## セキュリティ考慮事項

- qa_logger_pkgによる操作ログの記録

## 備考

- f_get_unit_test_callでパッケージ名を動的に検索
- オプション1（単一パッケージ）とオプション2（ルール単位パッケージ）の両方に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_run_custom_unit_test（990-1036行目） |

**主要処理フロー**:
1. **1002-1010行目**: パラメータログ記録
2. **1012-1015行目**: パラメータ検証（全パラメータ必須）
3. **1017行目**: f_get_unit_test_call呼び出し
4. **1019-1023行目**: ut.run実行とXML変換
5. **1025-1026行目**: QA_TEST_RESULTSへINSERT

#### Step 2: 呼び出しパス取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_unit_test_call（251-297行目） |

**主要処理フロー**:
1. **273-277行目**: QA_RULESからルール名を取得し正規化
2. **279-280行目**: クライアント名・ルール番号を正規化
3. **282-287行目**: user_objectsからパッケージ名を検索（オプション1/2両対応）
4. **289行目**: `{package_name}.p_ut_rule_{rule_number_unified}`形式で返却

**読解のコツ**: パッケージ名検索でIN句を使用し、オプション1（クライアント単位）とオプション2（ルール単位）の両方のパッケージ命名規則に対応。

### プログラム呼び出し階層図

```
p_run_custom_unit_test
    │
    ├─ qa_logger_pkg.append_param (パラメータログ)
    │
    ├─ f_get_unit_test_call
    │      ├─ QA_RULES (SELECT: ルール名取得)
    │      ├─ qa_utils_pkg.f_get_unified_string (名前正規化)
    │      └─ user_objects (SELECT: パッケージ名検索)
    │
    ├─ ut.run (utPLSQL実行)
    │      └─ ut_junit_reporter() (レポーター)
    │
    └─ QA_TEST_RESULTS (INSERT)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_qaru_rule_number    f_get_unit_test_call
(VARCHAR2)                     │
                               ▼
pi_qaru_client_name    QA_RULES (SELECT) + user_objects (SELECT)
(VARCHAR2)                     │
                               ▼
pi_scheme_name         l_utplsql_call
(VARCHAR2)             (package.procedure形式)
                               │
                               ▼
pi_character_set       ut.run(a_path => l_utplsql_call)
(VARCHAR2)                     │
                               ▼
                        XMLAGG/XMLELEMENT
                               │
                               ▼
                        l_xml_result (CLOB) ─────────▶ QA_TEST_RESULTS
                                                       (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | p_run_custom_unit_test |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | ルール定義テーブル |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | XML結果格納テーブル |
