# 機能設計書 18-カスタムテストジョブ作成

## 概要

本ドキュメントは、QUASTOシステムにおける「カスタムテストジョブ作成」機能の設計内容を記述するものである。本機能は、単一ユニットテストを実行するDBMS_SCHEDULERジョブを作成し、非同期でテストを実行する。

### 本機能の処理概要

本機能は、指定したルール・クライアント・スキーマに対するユニットテストを、DBMS_SCHEDULERジョブとしてスケジュールし、バックグラウンドで実行する機能である。

**業務上の目的・背景**：APEXアプリケーションからテストを実行する際、同期実行では画面がブロックされるため、ジョブとして非同期実行することでユーザー体験を向上させる。本機能により、非同期テスト実行、実行状態の追跡、自動クリーンアップ（auto_drop）が実現できる。

**機能の利用シーン**：APEXアプリケーションの「Restart Unit Test」画面からテストを開始する際に利用される。ユーザーは即座に画面操作を継続でき、テスト結果は後でダッシュボードで確認できる。

**主要な処理内容**：
1. ジョブ名の生成（パラメータ + タイムスタンプ）
2. ジョブ開始時刻の設定（5秒後）
3. DBMS_SCHEDULER.CREATE_JOBによるジョブ作成
4. p_run_custom_unit_testを呼び出すPL/SQLブロックの設定

**関連システム・外部連携**：DBMS_SCHEDULER、単一ユニットテスト実行機能（No.17）

**権限による制御**：DBMS_SCHEDULER使用権限（CREATE JOB）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | Restart Unit Test | 主画面 | 単一ユニットテスト実行用のスケジューラジョブを作成 |

## 機能種別

ジョブスケジューリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2(20 CHAR) | Yes | ルール番号 | NULL不可 |
| pi_qaru_client_name | VARCHAR2(100 CHAR) | Yes | クライアント名 | NULL不可 |
| pi_scheme_name | VARCHAR2 | Yes | スキーマ名 | NULL不可 |

### 入力データソース

- 画面からの入力値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | - | プロシージャのため戻り値なし |

### 出力先

- USER_SCHEDULER_JOBS（ジョブ登録）

## 処理フロー

### 処理シーケンス

```
1. パラメータログ記録
2. ジョブ開始時刻設定
   └─ systimestamp + interval '5' second
3. ジョブ名生成
   └─ f_get_job_nameでベース名取得
   └─ タイムスタンプを付加
4. DBMS_SCHEDULER.CREATE_JOB呼び出し
   └─ job_type: PLSQL_BLOCK
   └─ enabled: true
   └─ auto_drop: true
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータログ記録]
    B --> C[ジョブ開始時刻設定 +5秒]
    C --> D[f_get_job_nameでベース名取得]
    D --> E[タイムスタンプ付加]
    E --> F[DBMS_SCHEDULER.CREATE_JOB]
    F --> G[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 遅延開始 | ジョブは作成から5秒後に開始 | ジョブ作成時 |
| BR-02 | 自動削除 | ジョブ完了後に自動削除（auto_drop: true） | ジョブ完了時 |
| BR-03 | 即時有効化 | ジョブは作成と同時に有効化（enabled: true） | ジョブ作成時 |
| BR-04 | 一意ジョブ名 | ジョブ名にタイムスタンプを付加して一意性を確保 | ジョブ名生成時 |

### 計算ロジック

- ジョブ名: `JOB_RUN_UNIT_TEST_{SCHEME}_{CLIENT}_{RULE}_{YYYYMMDDHH24MISS}`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ジョブ作成 | USER_SCHEDULER_JOBS | INSERT | DBMS_SCHEDULER.CREATE_JOBによる登録 |

### テーブル別操作詳細

#### USER_SCHEDULER_JOBS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | job_name | l_job_name | 一意なジョブ名 |
| INSERT | job_type | 'PLSQL_BLOCK' | PL/SQLブロック実行 |
| INSERT | job_action | p_run_custom_unit_test呼び出し | 実行内容 |
| INSERT | start_date | l_job_start_date | 開始時刻 |
| INSERT | enabled | true | 有効状態 |
| INSERT | auto_drop | true | 完了後削除 |
| INSERT | comments | ジョブ説明 | コメント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OTHERS | システムエラー | ジョブ作成失敗 | ログを確認し問題を特定 |

### リトライ仕様

特になし（再度ジョブ作成を試行）

## トランザクション仕様

- DBMS_SCHEDULER.CREATE_JOBは暗黙コミットを発生させる

## パフォーマンス要件

- ジョブ作成自体は即座に完了
- テスト実行はバックグラウンドで非同期実行

## セキュリティ考慮事項

- DBMS_SCHEDULER使用権限（CREATE JOB）が必要
- qa_logger_pkgによる操作ログの記録

## 備考

- auto_drop: trueにより、ジョブ完了後は自動削除される
- 同一パラメータでも複数回実行可能（タイムスタンプで一意化）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_create_custom_unit_test_job（873-916行目） |

**主要処理フロー**:
1. **884-890行目**: パラメータログ記録
2. **892行目**: 開始時刻設定（5秒後）
3. **893-896行目**: ベースジョブ名取得
4. **897行目**: タイムスタンプ付加
5. **899-907行目**: DBMS_SCHEDULER.CREATE_JOB呼び出し

#### Step 2: ジョブ名生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_get_job_name（1170-1220行目） |

**主要処理フロー**:
- **1201-1203行目**: cronjobの場合はgc_utplsql_scheduler_cronjob_nameを返却
- **1205-1209行目**: カスタムジョブの場合は`gc_utplsql_custom_scheduler_job_name + {SCHEME} + {CLIENT} + {RULE}`

**読解のコツ**: f_get_job_nameはpi_is_cronjobパラメータで定期ジョブとカスタムジョブを区別。

### プログラム呼び出し階層図

```
p_create_custom_unit_test_job
    │
    ├─ qa_logger_pkg.append_param (パラメータログ)
    │
    ├─ f_get_job_name (ジョブ名生成)
    │      └─ qa_utils_pkg.f_get_unified_string (名前正規化)
    │
    └─ DBMS_SCHEDULER.CREATE_JOB
           │
           └─ [ジョブ実行時]
                  └─ p_run_custom_unit_test
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_qaru_rule_number    p_create_custom_unit_test_job
(VARCHAR2)                     │
                               ▼
pi_qaru_client_name    f_get_job_name ───▶ l_job_name
(VARCHAR2)                     │
                               ▼
pi_scheme_name         タイムスタンプ付加
(VARCHAR2)                     │
                               ▼
                        DBMS_SCHEDULER.CREATE_JOB ───▶ USER_SCHEDULER_JOBS
                               │                       (ジョブ登録)
                               ▼
                        [5秒後にジョブ開始]
                               │
                               ▼
                        p_run_custom_unit_test ───────▶ QA_TEST_RESULTS
                        (バックグラウンド実行)          (テスト結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | p_create_custom_unit_test_job、f_get_job_name |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_utplsql_custom_scheduler_job_name定義 |
