# 機能設計書 19-スケジューラジョブ制御

## 概要

本ドキュメントは、QUASTOシステムにおける「スケジューラジョブ制御」機能の設計内容を記述するものである。本機能は、定期実行用スケジューラジョブ（cronjob）の有効/無効切り替えおよび手動トリガーを行う。

### 本機能の処理概要

本機能は、全ユニットテストを定期実行するスケジューラジョブの制御を行う機能である。

**業務上の目的・背景**：品質チェックを定期的に実行するためのスケジューラジョブを運用管理する必要がある。本機能により、定期実行の一時停止/再開、手動での即時実行、ジョブ状態の確認が実現できる。

**機能の利用シーン**：メンテナンス時の定期実行停止、緊急の品質チェック実行、ジョブスケジュール変更時に利用される。APEXアプリケーションの「Config Scheduler Job」画面から操作可能。

**主要な処理内容**：
1. ジョブ有効化：DBMS_SCHEDULER.ENABLEによる有効化
2. ジョブ無効化：DBMS_SCHEDULER.DISABLEによる無効化
3. 手動トリガー：DBMS_SCHEDULER.RUN_JOBによる即時実行
4. 状態確認：USER_SCHEDULER_JOBSからの状態取得

**関連システム・外部連携**：DBMS_SCHEDULER、全ユニットテスト実行機能（No.16）

**権限による制御**：DBMS_SCHEDULER使用権限（ALTER ANY JOB）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | Config Scheduler Job | 主画面 | 定期実行用スケジューラジョブの有効/無効を設定・保存 |

## 機能種別

システム管理

## 入力仕様

### 入力パラメータ

#### p_enable_scheduler_cronjob

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_status | VARCHAR2 | Yes | 有効/無効（'Y' or 'N'） | 'Y'または'N'のみ |

#### p_trigger_scheduler_cronjob

パラメータなし

### 入力データソース

- 画面からの入力値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| f_is_scheduler_cronjob_enabled | VARCHAR2 | ジョブ有効状態（'Y' or 'N'） |

### 出力先

- USER_SCHEDULER_JOBS（ジョブ状態変更）
- 関数戻り値（状態確認）

## 処理フロー

### 処理シーケンス

#### 有効/無効切り替え（p_enable_scheduler_cronjob）

```
1. パラメータ検証
   └─ pi_statusが'Y'または'N'であることを確認
2. ジョブ状態変更
   └─ 'Y': DBMS_SCHEDULER.ENABLE呼び出し
   └─ 'N': DBMS_SCHEDULER.DISABLE呼び出し
```

#### 手動トリガー（p_trigger_scheduler_cronjob）

```
1. 実行中確認
   └─ f_is_job_runningでジョブ実行状態を確認
2. ジョブ実行
   └─ 未実行: DBMS_SCHEDULER.RUN_JOB呼び出し（use_current_session => false）
   └─ 実行中: エラー
```

### フローチャート

```mermaid
flowchart TD
    subgraph Enable/Disable
    A1[開始] --> B1{pi_status検証}
    B1 -->|Invalid| C1[エラー: Invalid status]
    B1 -->|Y| D1[DBMS_SCHEDULER.ENABLE]
    B1 -->|N| E1[DBMS_SCHEDULER.DISABLE]
    D1 --> F1[終了]
    E1 --> F1
    end

    subgraph Trigger
    A2[開始] --> B2{ジョブ実行中?}
    B2 -->|Yes| C2[エラー: Job is running]
    B2 -->|No| D2[DBMS_SCHEDULER.RUN_JOB]
    D2 --> E2[終了]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ステータス制限 | pi_statusは'Y'または'N'のみ許可 | p_enable_scheduler_cronjob |
| BR-02 | 重複実行防止 | ジョブ実行中の場合は手動トリガー不可 | p_trigger_scheduler_cronjob |
| BR-03 | 非同期実行 | 手動トリガーは非同期で実行（use_current_session => false） | p_trigger_scheduler_cronjob |

### 計算ロジック

- ジョブ名: `gc_utplsql_scheduler_cronjob_name`（'CRONJOB_RUN_UNIT_TESTS'）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 状態確認 | USER_SCHEDULER_JOBS | SELECT | ジョブ有効状態の確認 |
| 実行中確認 | USER_SCHEDULER_RUNNING_JOBS | SELECT | 実行中ジョブの確認 |
| 有効化/無効化 | USER_SCHEDULER_JOBS | UPDATE | DBMS_SCHEDULER.ENABLE/DISABLE |

### テーブル別操作詳細

#### USER_SCHEDULER_JOBS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | enabled | WHERE job_name = gc_utplsql_scheduler_cronjob_name | 有効状態確認 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | pi_statusが'Y','N'以外 | 有効な値を指定 |
| -20001 | ユーザー定義エラー | ジョブ実行中に手動トリガー | 実行完了を待つ |
| OTHERS | システムエラー | DBMS_SCHEDULER操作失敗 | ログを確認 |

### リトライ仕様

特になし

## トランザクション仕様

- DBMS_SCHEDULER操作は暗黙コミットを発生させる

## パフォーマンス要件

- 制御操作は即座に完了

## セキュリティ考慮事項

- DBMS_SCHEDULER使用権限が必要
- qa_logger_pkgによる操作ログの記録

## 備考

- ジョブ名は定数パッケージで定義（gc_utplsql_scheduler_cronjob_name = 'CRONJOB_RUN_UNIT_TESTS'）
- f_is_job_runningは汎用関数で、任意のジョブ名の実行状態を確認可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 状態確認関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_is_scheduler_cronjob_enabled（1304-1333行目） |
| 1-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_is_job_running（1269-1302行目） |

**主要処理フロー**:
- **1312-1318行目**: USER_SCHEDULER_JOBSからenabledがTRUEのジョブを検索
- **1282-1287行目**: USER_SCHEDULER_RUNNING_JOBSから実行中ジョブを検索

#### Step 2: 制御プロシージャを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_enable_scheduler_cronjob（1335-1364行目） |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_trigger_scheduler_cronjob（1366-1386行目） |

**主要処理フロー**:
- **1345-1349行目**: pi_status検証
- **1351-1356行目**: 'Y'ならENABLE、'N'ならDISABLE
- **1372-1377行目**: 実行中でなければRUN_JOB

**読解のコツ**: DBMS_SCHEDULER.RUN_JOBのuse_current_session => falseは非同期実行を意味する。

### プログラム呼び出し階層図

```
f_is_scheduler_cronjob_enabled
    │
    └─ USER_SCHEDULER_JOBS (SELECT)

p_enable_scheduler_cronjob
    │
    ├─ qa_logger_pkg.append_param (パラメータログ)
    │
    └─ DBMS_SCHEDULER.ENABLE / DISABLE

p_trigger_scheduler_cronjob
    │
    ├─ f_is_job_running
    │      └─ USER_SCHEDULER_RUNNING_JOBS (SELECT)
    │
    └─ DBMS_SCHEDULER.RUN_JOB
           │
           └─ p_run_all_unit_tests (ジョブ実行内容)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_status              p_enable_scheduler_cronjob
('Y' or 'N')                   │
                               ▼
                   ┌───────────┴───────────┐
                   │                       │
                   ▼                       ▼
               ENABLE                  DISABLE
                   │                       │
                   └───────────┬───────────┘
                               ▼
                   USER_SCHEDULER_JOBS (UPDATE) ───▶ ジョブ状態変更

---

(なし)                 p_trigger_scheduler_cronjob
                               │
                               ▼
                   f_is_job_running ───▶ 実行中確認
                               │
                               ▼
                   DBMS_SCHEDULER.RUN_JOB ─────────▶ ジョブ実行開始
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 制御関数群 |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_utplsql_scheduler_cronjob_name定義 |
| qa_job_details_P0009_v.sql | `src/plsql/vw/qa_job_details_P0009_v.sql` | ビュー | ジョブ詳細表示用 |
