# 機能設計書 2-単一ルール実行

## 概要

本ドキュメントは、QUASTOシステムにおける単一ルール実行機能の設計仕様を記述する。

### 本機能の処理概要

単一ルール実行機能は、指定したルール番号とクライアント名に基づいて特定のルールを実行し、品質基準に適合しないデータベースオブジェクトを検出・返却する機能である。qa_api_pkg.tf_run_rule関数として実装されており、QUASTOの品質チェックの基本単位となる。

**業務上の目的・背景**：データベースオブジェクトの品質を個別に検証するために、特定のルールを単独で実行できる必要がある。これにより、新規ルール作成後の動作確認や、特定の品質問題の調査が可能となる。開発者は特定のルールだけを実行して、そのルールに違反するオブジェクトを即座に特定できる。

**機能の利用シーン**：
- 新規作成したルールの動作確認を行う場合
- 特定のルールによる品質チェック結果を確認する場合
- APEXリージョンプラグインから個別ルールを実行する場合
- デバッグ目的で特定のルールのみを実行する場合

**主要な処理内容**：
1. 入力パラメータ（ルール番号、クライアント名、対象スキーマ）のバリデーション
2. 対象スキーマがブラックリストに含まれていないかチェック
3. 指定されたルールが有効（アクティブ）かどうかを確認
4. ルール定義（SQLクエリ）をQA_RULESテーブルから取得
5. 動的SQLとしてルールのSQLクエリを実行
6. APEXルールの場合、ブラックリストAPEXアプリを結果から除外
7. 除外オブジェクト設定に基づいて結果をフィルタリング
8. 品質基準に適合しないオブジェクトをqa_rules_t型で返却

**関連システム・外部連携**：APEXリージョンプラグインから呼び出され、検出結果を画面上に表示する。APEXカテゴリのルール実行時はqa_apex_api_pkgと連携してブラックリストアプリを除外する。

**権限による制御**：authid current_userにより実行ユーザーの権限でSQLが実行される。ブラックリストスキーマ（SYS、SYSTEM等）への操作は自動的にブロックされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Region Plugin | 主画面 | 選択したルール番号とクライアント名でAPEXルールを実行 |

## 機能種別

データ検索 / 品質検証 / 動的SQL実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2 | Yes | ルール番号 | NOT NULL、QA_RULESに存在すること |
| pi_qaru_client_name | VARCHAR2 | Yes | クライアント名 | NOT NULL、QA_RULESに存在すること |
| pi_target_scheme | VARCHAR2 | No | テスト対象スキーマ名 | デフォルト: USER、ブラックリスト外であること |

### 入力データソース

- APIパラメータとして直接指定
- APEXリージョンプラグインからの呼び出し
- 他のPL/SQLプログラムからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qaru_id | NUMBER | ルールID |
| qaru_category | VARCHAR2(10) | ルールカテゴリ |
| qaru_error_level | NUMBER | エラーレベル |
| qaru_error_message | VARCHAR2(4000) | エラーメッセージ |
| qaru_object_types | VARCHAR2(4000) | 対象オブジェクトタイプ |
| qaru_sql | CLOB | 実行されたSQLクエリ |
| scheme_name | VARCHAR2(100) | オブジェクトの所有者スキーマ |
| object_id | NUMBER | オブジェクトID |
| object_name | VARCHAR2(1000) | オブジェクト名 |
| object_details | VARCHAR2(2000) | オブジェクト詳細情報 |
| object_type | VARCHAR2(100) | オブジェクトタイプ |
| object_value | VARCHAR2(4000) | オブジェクト値 |
| apex_app_id | NUMBER | APEXアプリケーションID（APEXルールの場合） |
| apex_page_id | NUMBER | APEXページID（APEXルールの場合） |

### 出力先

- 関数の戻り値としてqa_rules_t型（qa_rule_tのコレクション）を返却
- APEXリージョンプラグインに表示
- 呼び出し元プログラムで処理

## 処理フロー

### 処理シーケンス

```
1. パラメータバリデーション
   └─ ルール番号、クライアント名、対象スキーマのNULLチェック
2. ブラックリストチェック
   └─ 対象スキーマがqa_scheme_names_for_testing_vに存在するか確認
3. ルールアクティブ確認
   └─ f_is_rule_active関数でルールが有効か確認
4. ルール定義取得
   └─ f_get_rule関数でルール情報を取得
5. 動的SQL実行
   └─ カテゴリ（APEX/非APEX）に応じてバインド変数を設定し実行
6. APEXブラックリスト除外（APEXルールの場合）
   └─ p_exclude_not_whitelisted_apex_entries呼び出し
7. 除外オブジェクトフィルタリング
   └─ p_exclude_objects呼び出し
8. 結果返却
   └─ qa_rules_t型で検出されたオブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|NG| C[例外発生 -20001]
    B -->|OK| D{ブラックリストチェック}
    D -->|ブラックリスト| E[NULLを返却]
    D -->|OK| F{ルールアクティブ?}
    F -->|No| G[例外発生 -20001]
    F -->|Yes| H[ルール定義取得]
    H --> I{カテゴリ判定}
    I -->|非APEX| J[SQL実行 7バインド変数]
    I -->|APEX| K[SQL実行 9バインド変数]
    J --> L{APEXカテゴリ?}
    K --> L
    L -->|Yes| M[APEXブラックリスト除外]
    L -->|No| N[除外オブジェクト処理]
    M --> N
    N --> O[結果返却]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須パラメータ | ルール番号、クライアント名、対象スキーマはすべて必須 | 関数呼び出し時 |
| BR-02 | ブラックリスト除外 | ブラックリストスキーマに対してはルールを実行しない | 対象スキーマ指定時 |
| BR-03 | アクティブルールのみ | 非アクティブ（qaru_is_active=0）のルールは実行不可 | ルール実行時 |
| BR-04 | APEX条件付きコンパイル | gc_apex_flag=1の場合のみAPEXブラックリスト除外を実行 | APEXルール実行時 |

### 計算ロジック

特になし（SQLクエリの実行結果をそのまま返却）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール定義取得 | QA_RULES | SELECT | ルール情報の取得 |
| 動的SQL実行 | 各種テーブル/ビュー | SELECT | ルールのSQLクエリを動的実行 |
| ブラックリストチェック | qa_scheme_names_for_testing_v | SELECT | スキーマの有効性確認 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_id, qaru_category, qaru_error_level, qaru_error_message, qaru_object_types, qaru_sql | WHERE qaru_rule_number = pi_qaru_rule_number AND qaru_client_name = pi_qaru_client_name | f_get_rule関数内 |
| SELECT | qaru_is_active | 同上 | f_is_rule_active関数内 |
| SELECT | qaru_exclude_objects | 同上 | p_exclude_objects内 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | アプリケーションエラー | 必須パラメータがNULL | パラメータを正しく指定 |
| -20001 | アプリケーションエラー | ルールが非アクティブ | ルールを有効化 |
| -20007 | アプリケーションエラー | スキーマがブラックリスト | 有効なスキーマを指定 |
| NO_DATA_FOUND | データなし | 指定ルールが存在しない | 正しいルール番号/クライアント名を指定 |

### リトライ仕様

リトライは不要。エラー発生時はloggerにログを記録し、例外を再スローする。

## トランザクション仕様

- 参照のみの処理のためトランザクション管理は不要
- 動的SQLはSELECTのみでデータ更新なし

## パフォーマンス要件

- 単一ルール実行：ルールのSQLクエリの複雑さに依存
- 目安：数秒以内（大規模スキーマでも10秒以内を推奨）

## セキュリティ考慮事項

- authid current_userにより実行ユーザーの権限でのみオブジェクトにアクセス可能
- ブラックリストスキーマ（SYS、SYSTEM等）へのアクセスは自動的にブロック
- 動的SQLはバインド変数を使用してSQLインジェクションを防止

## 備考

- 関数はqa_api_pkg.tf_run_ruleとして公開
- APEXルールとそれ以外でバインド変数の数が異なる（7個 vs 9個）
- APEX連携は条件付きコンパイル（$IF....$END）で制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ルール実行結果を格納する型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | 実行結果の各属性（scheme_name, object_name等）の意味を確認 |
| 1-2 | qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | コレクション型として複数の結果を格納することを確認 |

**読解のコツ**:
- qa_rule_tには入力用（ルール定義情報）と出力用（検出オブジェクト情報）の属性が混在
- APEXルール用にapex_app_id, apex_page_id属性が存在

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | tf_run_rule関数の仕様と実装を確認 |

**主要処理フロー**:
1. **24-29行目**: tf_run_rule関数の仕様宣言（3つのパラメータ）
2. **49-151行目**: tf_run_rule関数の実装本体
3. **66-72行目**: パラメータのログ記録
4. **74-80行目**: 必須パラメータのNULLチェック
5. **82-83行目**: ブラックリストチェック
6. **85-91行目**: ルールアクティブチェック
7. **93-94行目**: ルール定義取得
8. **97-122行目**: カテゴリ別の動的SQL実行
9. **124-132行目**: APEXブラックリスト除外（条件付きコンパイル）
10. **134行目**: 除外オブジェクト処理

#### Step 3: 補助関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_is_rule_active, f_get_rule, p_exclude_objects, f_is_owner_black_listedの実装を確認 |

**主要処理フロー**:
- **290-326行目**: f_is_rule_active - ルールの有効性チェック
- **213-256行目**: f_get_rule - ルール定義の取得
- **842-897行目**: p_exclude_objects - 除外オブジェクトのフィルタリング
- **1006-1056行目**: f_is_owner_black_listed - ブラックリストスキーマ判定

#### Step 4: ビュー定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | ブラックリストスキーマの定義を確認 |

### プログラム呼び出し階層図

```
qa_api_pkg.tf_run_rule
    │
    ├─ qa_main_pkg.f_is_owner_black_listed
    │      └─ SELECT FROM qa_scheme_names_for_testing_v
    │
    ├─ qa_main_pkg.f_is_rule_active
    │      └─ SELECT FROM qa_rules
    │
    ├─ qa_main_pkg.f_get_rule
    │      └─ SELECT FROM qa_rules
    │
    ├─ EXECUTE IMMEDIATE (動的SQL)
    │
    ├─ qa_apex_api_pkg.p_exclude_not_whitelisted_apex_entries
    │      └─ (APEXルールの場合のみ)
    │
    └─ qa_main_pkg.p_exclude_objects
           └─ SELECT FROM qa_rules (qaru_exclude_objects)
```

### データフロー図

```
[入力]                     [処理]                              [出力]

pi_qaru_rule_number ──▶ qa_api_pkg.tf_run_rule ──────────▶ qa_rules_t
pi_qaru_client_name        │                               (検出オブジェクト)
pi_target_scheme           │
                           ├─▶ QA_RULES (ルール定義取得)
                           │
                           ├─▶ EXECUTE IMMEDIATE (動的SQL)
                           │        │
                           │        └─▶ 各種テーブル/ビュー
                           │
                           └─▶ フィルタリング処理
                                    │
                                    └─▶ 除外オブジェクト削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | PKG | 単一ルール実行の公開API |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | ルール操作の補助関数群 |
| qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | TYPE | ルール/結果型定義 |
| qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | TYPE | ルール/結果コレクション型 |
| qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | PKG | APEXルール用API |
| qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | VIEW | テスト対象スキーマビュー |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | PKG | ログ記録パッケージ |
