# 機能設計書 20-テスト結果処理

## 概要

本ドキュメントは、QUASTOシステムにおける「テスト結果処理」機能の設計内容を記述するものである。本機能は、ユニットテストの結果を処理し、XML形式での出力とデータベースへの保存を行う。

### 本機能の処理概要

本機能は、utPLSQLユニットテストの実行結果を受け取り、テスト結果のXML出力とデータベースへの永続化を行う機能である。

**業務上の目的・背景**：utPLSQLテスト実行後、その結果を構造化されたXML形式で出力し、同時にデータベースに保存することで、テスト結果の可視化とレポーティングを可能にする。本機能により、テスト結果のXML出力、スキーマ別結果保存、無効オブジェクト詳細の記録が実現できる。

**機能の利用シーン**：utPLSQLテスト実行時に自動的に呼び出される。テストパッケージ内のアサーション処理の一部として機能し、テスト結果をXMLとデータベースの両方に出力する。

**主要な処理内容**：
1. utPLSQLアサーション（ut.expect）の実行
2. ルール属性情報の取得
3. スキーマごとの結果判定とXML出力
4. QA_TEST_RUNSテーブルへの結果保存
5. QA_TEST_RUN_INVALID_OBJECTSテーブルへの無効オブジェクト保存

**関連システム・外部連携**：utPLSQL（ut.expect）、DBMS_OUTPUT、DBMS_XMLGEN

**権限による制御**：QA_TEST_RUNS、QA_TEST_RUN_INVALID_OBJECTSテーブルへのINSERT権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 参照画面 | テスト結果の表示（QA_TEST_RUNSからデータ取得） |
| 5 | Invalid Objects | 参照画面 | 無効オブジェクト詳細の表示 |

## 機能種別

テスト結果処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2(20 CHAR) | Yes | ルール番号 | QA_RULESに存在すること |
| pi_qaru_client_name | VARCHAR2(100 CHAR) | Yes | クライアント名 | QA_RULESに存在すること |
| pi_scheme_objects | qa_scheme_object_amounts_t | Yes | スキーマごとの無効オブジェクト数 | コレクション型 |
| pi_invalid_objects | qa_rules_t | Yes | 無効オブジェクトの詳細情報 | コレクション型 |
| pi_result | NUMBER | Yes | テスト結果（0:失敗, 1:成功） | 0または1 |
| pi_program_name | VARCHAR2 | Yes | テストプログラム名 | NULL不可 |

### 入力データソース

- utPLSQLテストプロシージャからの呼び出し
- qa_scheme_object_amounts_tコレクション：スキーマ名とオブジェクト数のペア
- qa_rules_tコレクション：無効オブジェクトの詳細情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| XML出力 | CLOB | DBMS_OUTPUT経由でXML形式のテスト結果を出力 |

### 出力先

- DBMS_OUTPUT（XML形式のテスト結果）
- QA_TEST_RUNS（テスト実行結果）
- QA_TEST_RUN_INVALID_OBJECTS（無効オブジェクト詳細）

## 処理フロー

### 処理シーケンス

```
1. utPLSQLアサーション実行
   └─ ut.expect(pi_result).to_equal(1)
2. ルール情報取得
   └─ qa_main_pkgからID、カテゴリ、名前、レイヤー、エラーレベルを取得
3. XMLルート要素出力
   └─ <Results>タグを出力
4. スキーマごとの処理（ループ）
   └─ object_amount = 0: 成功として保存
   └─ object_amount > 0: 失敗として保存、無効オブジェクト詳細を保存
5. XML終了タグ出力
6. コミット
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ut.expect実行]
    B --> C[ルール情報取得]
    C --> D[Results XMLタグ出力]
    D --> E{スキーマループ}
    E --> F{object_amount = 0?}
    F -->|Yes| G[成功として保存]
    F -->|No| H[失敗として保存]
    H --> I{無効オブジェクトループ}
    I --> J[Object XMLタグ出力]
    J --> K[p_save_scheme_faulty_objects]
    K --> I
    I -->|終了| L[Scheme終了タグ出力]
    G --> E
    L --> E
    E -->|終了| M[Results終了タグ出力]
    M --> N[COMMIT]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 成功判定 | object_amount = 0 の場合、テスト成功（gc_utplsql_scheme_result_success = 1） | スキーマ処理時 |
| BR-02 | 失敗判定 | object_amount > 0 の場合、テスト失敗（gc_utplsql_scheme_result_failure = 0） | スキーマ処理時 |
| BR-03 | 自律トランザクション | 結果保存は自律トランザクション（pragma autonomous_transaction）で実行 | 常時 |
| BR-04 | XML整形 | オブジェクト名・詳細はDBMS_XMLGEN.CONVERTでエスケープ | XML出力時 |

### 計算ロジック

- テスト結果コード
  - gc_utplsql_scheme_result_success = 1（成功）
  - gc_utplsql_scheme_result_failure = 0（失敗）
  - gc_utplsql_scheme_result_error = 2（エラー）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 結果保存 | QA_TEST_RUNS | INSERT | スキーマごとのテスト結果を保存 |
| 無効オブジェクト保存 | QA_TEST_RUN_INVALID_OBJECTS | INSERT | 無効オブジェクトの詳細を保存 |
| ルール情報取得 | QA_RULES | SELECT | ルールのID、カテゴリ、名前等を取得 |

### テーブル別操作詳細

#### QA_TEST_RUNS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_scheme_name | pi_scheme_name | スキーマ名 |
| INSERT | qatr_date | sysdate | 実行日時 |
| INSERT | qatr_result | pi_result (0, 1, or 2) | テスト結果 |
| INSERT | qatr_qaru_id | l_qaru_id | ルールID（FK） |
| INSERT | qatr_program_name | pi_program_name | プログラム名 |

#### QA_TEST_RUN_INVALID_OBJECTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qato_object_name | pi_object_name | オブジェクト名 |
| INSERT | qato_object_details | pi_object_details | 詳細情報 |
| INSERT | qato_qatr_id | pi_qatr_id | テスト実行ID（FK） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | ユーザー定義エラー | pi_resultが無効な値（f_save_scheme_result内） | 有効な値（0, 1, 2）を指定 |
| OTHERS | システムエラー | データベース操作失敗 | ログを確認し問題を特定 |

### リトライ仕様

特になし（自律トランザクションのため、メイントランザクションに影響なし）

## トランザクション仕様

- pragma autonomous_transaction による自律トランザクション
- 処理完了時にコミット実行
- メイントランザクション（utPLSQLテスト実行）には影響しない

## パフォーマンス要件

- スキーマ数 × 無効オブジェクト数分のINSERTが発生
- DBMS_OUTPUT のバッファサイズに依存（バッファオーバーフロー注意）

## セキュリティ考慮事項

- DBMS_XMLGEN.CONVERTによるXMLインジェクション防止
- 自律トランザクションによるテスト実行への影響分離

## 備考

- 本プロシージャはutPLSQLテストパッケージから自動呼び出しされる
- XML出力はJenkins等のCI/CDツールでのレポート表示に使用可能
- f_save_scheme_result、p_save_scheme_faulty_objectsは内部関数/プロシージャ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_result（1072-1141行目） |

**主要処理フロー**:
1. **1081行目**: pragma autonomous_transaction宣言
2. **1090行目**: ut.expect(pi_result).to_equal(1)によるアサーション
3. **1091-1100行目**: qa_main_pkgから各種ルール属性を取得
4. **1102行目**: XMLの<Results>タグを出力
5. **1103-1137行目**: スキーマごとのループ処理
6. **1139行目**: COMMIT

**読解のコツ**: autonomous_transactionにより、テスト実行のトランザクションとは独立して結果保存が行われる。

#### Step 2: 結果保存関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_save_scheme_result（1038-1060行目） |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_save_scheme_faulty_objects（1062-1070行目） |

**主要処理フロー**:
- **1047-1053行目**: pi_resultの検証（0, 1, 2のみ許可）
- **1055-1057行目**: QA_TEST_RUNSへのINSERTとqatr_idの取得
- **1068-1069行目**: QA_TEST_RUN_INVALID_OBJECTSへのINSERT

#### Step 3: 定数定義を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | 結果コード定義（21-23行目） |

**定数値**:
- **gc_utplsql_scheme_result_failure = 0**: 失敗
- **gc_utplsql_scheme_result_success = 1**: 成功
- **gc_utplsql_scheme_result_error = 2**: エラー

### プログラム呼び出し階層図

```
p_handle_test_result
    │
    ├─ ut.expect (utPLSQLアサーション)
    │
    ├─ qa_main_pkg.f_get_rule_pk (ルールID取得)
    │
    ├─ qa_main_pkg.f_get_rule_category (カテゴリ取得)
    │
    ├─ qa_main_pkg.f_get_rule_name (ルール名取得)
    │
    ├─ qa_main_pkg.f_get_rule_layer (レイヤー取得)
    │
    ├─ qa_main_pkg.f_get_rule_error_level (エラーレベル取得)
    │
    ├─ DBMS_OUTPUT.PUT_LINE (XML出力)
    │      └─ DBMS_XMLGEN.CONVERT (エスケープ処理)
    │
    ├─ f_save_scheme_result (結果保存)
    │      └─ QA_TEST_RUNS (INSERT)
    │
    └─ p_save_scheme_faulty_objects (無効オブジェクト保存)
           └─ QA_TEST_RUN_INVALID_OBJECTS (INSERT)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

pi_qaru_rule_number    p_handle_test_result
(VARCHAR2)                     │
                               ▼
pi_qaru_client_name    qa_main_pkg.f_get_rule_* ───▶ ルール属性取得
(VARCHAR2)                     │
                               ▼
pi_scheme_objects      スキーマループ処理
(qa_scheme_object_amounts_t)   │
                               ├───▶ DBMS_OUTPUT (XML出力)
                               │
                               ▼
pi_invalid_objects     f_save_scheme_result ─────────▶ QA_TEST_RUNS
(qa_rules_t)                   │                       (INSERT)
                               ▼
pi_result              p_save_scheme_faulty_objects ─▶ QA_TEST_RUN_INVALID_OBJECTS
(NUMBER)                       │                       (INSERT)
                               ▼
pi_program_name        COMMIT
(VARCHAR2)

XML出力形式:
<Results rulenumber="..." category="..." name="..." layer="..." errorlevel="..." result="...">
  <Scheme name="..." testresultid="..." result="..." datetime="...">
    <Object name="..." details="...">エラーメッセージ</Object>
  </Scheme>
</Results>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | p_handle_test_result、f_save_scheme_result、p_save_scheme_faulty_objects |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_utplsql_scheme_result_*定数定義 |
| qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | DDL | QA_TEST_RUNSテーブル定義 |
| qa_test_run_invalid_objects.sql | `src/ddl/tab/qa_test_run_invalid_objects.sql` | DDL | QA_TEST_RUN_INVALID_OBJECTSテーブル定義 |
