# 機能設計書 21-テスト例外処理

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト例外処理機能の設計を記述したものである。ユニットテスト実行時に発生するランタイムエラーを捕捉し、エラー情報をデータベースに記録する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：ユニットテスト実行時にランタイムエラーが発生した場合、そのエラー情報を適切に記録することで、テスト失敗の原因分析とデバッグを支援する。エラー情報が記録されていないと、テスト失敗の原因特定が困難となり、品質管理プロセスに支障をきたす。

**機能の利用シーン**：utPLSQL連携によるユニットテスト実行時、テスト対象のルール実行中に予期しないエラーが発生した場合に自動的に呼び出される。生成されたテストパッケージの例外ハンドラから直接呼び出され、エラー情報を永続化する。

**主要な処理内容**：
1. スキーマ名配列を区切り文字付き文字列に変換する
2. ルールの主キー（qaru_id）を取得する
3. テスト実行結果をエラー状態としてQA_TEST_RUNSテーブルに記録する
4. ランタイムエラーのバックトレース情報をQA_TEST_RUNSテーブルに更新する
5. 自律トランザクションとしてコミットを実行する

**関連システム・外部連携**：utPLSQLフレームワークと連携し、生成されたテストパッケージ内の例外ハンドラから呼び出される。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | Runtime Error | 主画面 | テスト実行時のランタイムエラーバックトレースを表示 |

## 機能種別

データ登録処理 / エラーハンドリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | Yes | ルール番号 | NOT NULL |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | Yes | クライアント名 | NOT NULL |
| pi_scheme_name | varchar2_tab_t | Yes | スキーマ名配列 | NOT NULL |
| pi_program_name | varchar2 | Yes | ユニットテストプロシージャの修飾名（package.procedure） | NOT NULL |
| pi_runtime_error | varchar2 | Yes | エラーバックトレース情報（SQLERRM || ' - ' || DBMS_UTILITY.format_error_backtrace） | NOT NULL |

### 入力データソース

- 生成されたutPLSQLテストパッケージの例外ハンドラから渡される

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qatr_id | NUMBER | QA_TEST_RUNSテーブルに挿入されたテスト実行レコードのID |
| qatr_scheme_name | VARCHAR2 | カンマ区切りのスキーマ名文字列 |
| qatr_result | NUMBER | テスト結果（エラー状態を示す定数値） |
| qatr_runtime_error | VARCHAR2 | ランタイムエラーのバックトレース情報 |

### 出力先

- QA_TEST_RUNSテーブルへのINSERT/UPDATE

## 処理フロー

### 処理シーケンス

```
1. スキーマ名配列を文字列に変換
   └─ qa_utils_pkg.f_get_table_as_stringを呼び出し、カンマ区切り文字列に変換

2. ルール主キーの取得
   └─ qa_main_pkg.f_get_rule_pkを呼び出し、qaru_idを取得

3. テスト実行結果の保存
   └─ f_save_scheme_resultを呼び出し、エラー状態としてQA_TEST_RUNSに挿入

4. ランタイムエラー情報の更新
   └─ QA_TEST_RUNSテーブルのqatr_runtime_error列を更新

5. トランザクションのコミット
   └─ 自律トランザクションとしてコミット実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[スキーマ名配列を文字列に変換]
    B --> C[ルール主キーを取得]
    C --> D[テスト実行結果を保存]
    D --> E[ランタイムエラー情報を更新]
    E --> F[コミット]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | 自律トランザクション | 例外処理は自律トランザクションとして実行され、呼び出し元のトランザクションに影響を与えない | 常に適用 |
| BR-21-02 | エラー状態記録 | テスト結果は常にqa_constant_pkg.gc_utplsql_scheme_result_error（エラー状態）として記録される | 常に適用 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト実行結果保存 | QA_TEST_RUNS | INSERT | エラー状態のテスト実行レコードを挿入 |
| ランタイムエラー更新 | QA_TEST_RUNS | UPDATE | ランタイムエラー情報を更新 |
| ルールPK参照 | QA_RULES | SELECT | ルール番号とクライアント名からqaru_idを取得 |

### テーブル別操作詳細

#### QA_TEST_RUNS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_scheme_name | カンマ区切りのスキーマ名文字列 | f_save_scheme_resultで実行 |
| INSERT | qatr_date | sysdate | テスト実行日時 |
| INSERT | qatr_result | gc_utplsql_scheme_result_error | エラー状態 |
| INSERT | qatr_qaru_id | ルールの主キー | qa_main_pkg.f_get_rule_pkで取得 |
| INSERT | qatr_program_name | ユニットテストプロシージャ名 | package.procedure形式 |
| UPDATE | qatr_runtime_error | エラーバックトレース情報 | INSERT後に更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NO_DATA_FOUND | 指定されたルールが存在しない場合 | qa_main_pkg.f_get_rule_pk内で発生、上位に伝播 |

### リトライ仕様

リトライは行わない。自律トランザクションのため、エラー発生時はロールバックされる。

## トランザクション仕様

**PRAGMA AUTONOMOUS_TRANSACTION**を使用し、呼び出し元のトランザクションとは独立して処理される。処理完了時に自動的にCOMMITが実行される。これにより、例外発生後に呼び出し元でRAISEされても、エラー情報は確実にデータベースに記録される。

## パフォーマンス要件

- 単一レコードのINSERT/UPDATEのため、特別なパフォーマンス要件なし
- 自律トランザクションによるオーバーヘッドは許容範囲内

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- エラー情報にはスタックトレースが含まれるため、データベースの内部構造が露出する可能性がある

## 備考

- 本プロシージャは、qa_unit_tests_pkg.p_create_unit_test_packagesで生成されるテストパッケージの例外ハンドラから呼び出される
- エラーバックトレースはSQLERRM || ' - ' || DBMS_UTILITY.format_error_backtraceの形式で渡される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト実行結果を保存するテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | QA_TEST_RUNSテーブルの構造、特にqatr_runtime_error列の定義を確認 |

**読解のコツ**: PL/SQLのテーブル定義ではカラムコメントが付与されており、各カラムの用途を理解できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_exceptionプロシージャの仕様（パッケージ仕様部） |

**主要処理フロー**:
1. **106-113行目**: プロシージャのシグネチャ定義
2. **1143-1168行目**: プロシージャの実装

#### Step 3: 内部ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_save_scheme_result関数の実装 |

**主要処理フロー**:
- **1038-1060行目**: f_save_scheme_result関数がテスト結果をQA_TEST_RUNSに挿入する処理

#### Step 4: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | 生成されるテストパッケージのテンプレート |

**主要処理フロー**:
- **600-607行目**: f_get_package_body_content関数内で、生成されるテストパッケージの例外ハンドラからp_handle_test_exceptionが呼び出されるコードを生成

### プログラム呼び出し階層図

```
生成されたテストパッケージ.p_ut_rule_xxx
    │
    └─ EXCEPTION WHEN OTHERS
           │
           └─ qa_unit_tests_pkg.p_handle_test_exception
                  │
                  ├─ qa_utils_pkg.f_get_table_as_string
                  │
                  ├─ qa_main_pkg.f_get_rule_pk
                  │
                  ├─ qa_unit_tests_pkg.f_save_scheme_result (内部)
                  │      └─ INSERT INTO QA_TEST_RUNS
                  │
                  └─ UPDATE QA_TEST_RUNS (qatr_runtime_error)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_scheme_name       ───▶ f_get_table_as_string ───▶ l_scheme_name (文字列)
(varchar2_tab_t)

pi_qaru_rule_number  ───▶ f_get_rule_pk ───▶ l_qaru_id
pi_qaru_client_name

l_scheme_name        ───▶ f_save_scheme_result ───▶ QA_TEST_RUNS (INSERT)
l_qaru_id                                           └─ l_qatr_id
pi_program_name

pi_runtime_error     ───▶ UPDATE QA_TEST_RUNS ───▶ qatr_runtime_error更新
l_qatr_id
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | p_handle_test_exceptionを含むメインパッケージ |
| qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | DDL | テスト実行結果を格納するテーブル定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | f_get_rule_pk関数を提供 |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | f_get_table_as_string関数を提供 |
