# 機能設計書 22-テスト結果インポート

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果インポート機能の設計を記述したものである。XML形式のユニットテスト結果ファイルをQA_TEST_RESULTSテーブルにインポートする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：他環境で実行されたutPLSQLテスト結果を現環境に取り込むことで、複数環境間でのテスト結果の共有・集約を可能にする。CI/CDパイプラインで生成されたテスト結果を手動でインポートする場合や、バックアップからのリストアなどのユースケースに対応する。

**機能の利用シーン**：APEXアプリケーションの「Test Result Files」画面からXMLファイルをアップロードする際に使用される。ユーザーはXML形式のテスト結果ファイルを選択し、アップロードボタンをクリックすることでインポートを実行する。

**主要な処理内容**：
1. XML CLOBデータを受け取る
2. QA_TEST_RESULTSテーブルに新規レコードを挿入する
3. 挿入されたレコードのIDを返却する

**関連システム・外部連携**：utPLSQLフレームワークが生成するJUnit形式のXMLテスト結果と連携する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Test Result Files | 主画面 | XMLファイルをアップロードしてテスト結果をインポート |

## 機能種別

データ登録処理 / ファイルインポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_xml_clob | CLOB | Yes | XML形式のテスト結果データ | NOT NULL |

### 入力データソース

- APEXアプリケーションからアップロードされたXMLファイルのCLOBデータ
- qa_apex_app_pkg.p_upload_unit_test_xml経由で呼び出される

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qatr_id | NUMBER | QA_TEST_RESULTSテーブルに挿入されたレコードのID |

### 出力先

- QA_TEST_RESULTSテーブルへのINSERT
- 戻り値として挿入されたレコードのID

## 処理フロー

### 処理シーケンス

```
1. XML CLOBデータの受け取り
   └─ 入力パラメータpi_xml_clobを受け取る

2. QA_TEST_RESULTSテーブルへの挿入
   └─ qatr_xml_result列にXML CLOBを設定
   └─ qatr_description列に'Imported by User'を設定
   └─ RETURNING句でqatr_idを取得

3. IDの返却
   └─ 挿入されたレコードのqatr_idを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[XML CLOBデータを受け取り]
    B --> C[QA_TEST_RESULTSにINSERT]
    C --> D[RETURNING句でqatr_idを取得]
    D --> E[qatr_idを返却]
    E --> F[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | インポート説明固定 | qatr_description列には'Imported by User'が固定で設定される | 常に適用 |
| BR-22-02 | XML形式チェック | インポート前にMIMEタイプがapplication/xmlであることを確認（呼び出し元で実施） | APEXからのアップロード時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト結果保存 | QA_TEST_RESULTS | INSERT | XMLテスト結果を新規レコードとして挿入 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_id | シーケンス自動採番 | 主キー |
| INSERT | qatr_xml_result | pi_xml_clob | XML CLOBデータ |
| INSERT | qatr_added_on | sysdate（デフォルト） | 追加日時 |
| INSERT | qatr_added_by | USER（デフォルト） | 追加ユーザー |
| INSERT | qatr_description | 'Imported by User' | 固定値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | OTHERS | INSERT失敗時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

呼び出し元のトランザクション内で実行される。コミット/ロールバックは呼び出し元の制御に委ねられる。

## パフォーマンス要件

- 単一レコードのINSERTのため、特別なパフォーマンス要件なし
- CLOBデータのサイズに応じてI/O負荷が発生する可能性がある

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- XMLデータの内容検証は行われないため、不正なXMLがインポートされる可能性がある
- APEXからのアップロード時はMIMEタイプのチェックが行われる

## 備考

- 本関数はqa_apex_app_pkg.p_upload_unit_test_xml経由で呼び出されることを想定している
- XMLデータのパース・検証は本機能では行わない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト結果を保存するテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | QA_TEST_RESULTSテーブルの構造、特にqatr_xml_result列（CLOB型）の定義を確認 |

**読解のコツ**: テーブル定義のコメントから各カラムの用途を理解できる。qatr_added_onとqatr_added_byはデフォルト値が設定されている可能性がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_import_test_result関数の仕様（パッケージ仕様部） |

**主要処理フロー**:
1. **182-186行目**: 関数のシグネチャ定義
2. **1435-1458行目**: 関数の実装

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_unit_test_xmlプロシージャの実装 |

**主要処理フロー**:
- **209-246行目**: p_upload_unit_test_xmlがAPEX_APPLICATION_TEMP_FILESからファイルを取得し、MIMEタイプをチェックした後、f_import_test_resultを呼び出す
- **237行目**: f_import_test_resultの呼び出し

### プログラム呼び出し階層図

```
APEXアプリケーション (Test Result Files画面)
    │
    └─ qa_apex_app_pkg.p_upload_unit_test_xml
           │
           ├─ SELECT FROM APEX_APPLICATION_TEMP_FILES
           │
           ├─ MIMEタイプチェック (application/xml)
           │
           └─ qa_unit_tests_pkg.f_import_test_result
                  │
                  └─ INSERT INTO QA_TEST_RESULTS
```

### データフロー図

```
[入力]                           [処理]                              [出力]

XMLファイル          ───▶ APEX_APPLICATION_TEMP_FILES ───▶ l_clob_content
(ユーザーアップロード)

l_clob_content       ───▶ MIMEタイプチェック ───▶ application/xml確認
l_mime_type

pi_xml_clob          ───▶ f_import_test_result ───▶ QA_TEST_RESULTS (INSERT)
                                                    └─ l_qatr_id (戻り値)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_import_test_resultを含むメインパッケージ |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_upload_unit_test_xmlを含むAPEX連携パッケージ |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果XMLを格納するテーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
