# 機能設計書 23-テスト結果エクスポート

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果エクスポート機能の設計を記述したものである。QA_TEST_RESULTSテーブルに保存されているユニットテスト結果をXML形式（CLOB）で取得する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：実行されたutPLSQLテスト結果を外部に出力することで、テスト結果のバックアップ、他環境への移行、レポート生成ツールへの入力データとしての活用を可能にする。CI/CDパイプラインやテスト結果集約システムとの連携においても重要な役割を果たす。

**機能の利用シーン**：APEXアプリケーションの「Test Result Files」画面からテスト結果をXML形式でダウンロードする際に使用される。ユーザーはテスト結果IDを指定し、ダウンロードボタンをクリックすることでエクスポートを実行する。

**主要な処理内容**：
1. テスト結果ID（qatr_id）を受け取る
2. QA_TEST_RESULTSテーブルから該当レコードのXML CLOBを取得する
3. XML CLOBを返却する

**関連システム・外部連携**：utPLSQLフレームワークが生成するJUnit形式のXMLテスト結果と連携する。エクスポートされたXMLは外部のCI/CDツールやテスト管理システムで利用可能。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Test Result Files | 主画面 | テスト結果をXML形式でダウンロード |

## 機能種別

データ取得処理 / ファイルエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qatr_id | qa_test_results.qatr_id%type | Yes | テスト結果ID | NOT NULL |

### 入力データソース

- APEXアプリケーションから選択されたテスト結果ID
- qa_apex_app_pkg.p_download_unit_test_xml経由で呼び出される

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| l_return | CLOB | QA_TEST_RESULTSテーブルから取得したXML CLOBデータ |

### 出力先

- 戻り値としてXML CLOBを返却
- APEXアプリケーション経由でブラウザにダウンロード

## 処理フロー

### 処理シーケンス

```
1. テスト結果IDの受け取り
   └─ 入力パラメータpi_qatr_idを受け取る

2. ログパラメータの設定
   └─ qa_logger_pkgでパラメータをログ設定

3. QA_TEST_RESULTSテーブルからXML取得
   └─ qatr_idをキーにqatr_xml_resultを取得

4. XML CLOBの返却
   └─ 取得したCLOBデータを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[テスト結果IDを受け取り]
    B --> C[ログパラメータ設定]
    C --> D[QA_TEST_RESULTSからXML取得]
    D --> E[XML CLOBを返却]
    E --> F[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | 単一レコード取得 | 指定されたqatr_idに対応する単一のXML CLOBを取得する | 常に適用 |
| BR-23-02 | 存在チェック | 指定されたqatr_idが存在しない場合はNO_DATA_FOUND例外が発生する | 常に適用 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト結果取得 | QA_TEST_RESULTS | SELECT | 指定IDのXML CLOBを取得 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qatr_xml_result | WHERE qatr_id = pi_qatr_id | 取得対象カラム |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NO_DATA_FOUND | 指定されたqatr_idが存在しない場合 | qa_logger_pkgでエラーログ記録後、例外を再スロー（暗黙的） |
| - | OTHERS | その他のエラー発生時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- 単一レコードのSELECTのため、特別なパフォーマンス要件なし
- CLOBデータのサイズに応じてI/O負荷が発生する可能性がある
- qatr_id列にはインデックスが設定されていることが望ましい

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- テスト結果にはデータベース構造に関する情報が含まれる可能性があるため、アクセス制御に注意が必要

## 備考

- 本関数はqa_apex_app_pkg.p_download_unit_test_xml経由で呼び出されることを想定している
- エクスポートされるXMLはJUnit形式のテスト結果

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト結果を保存するテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | QA_TEST_RESULTSテーブルの構造、特にqatr_xml_result列（CLOB型）とqatr_id列（主キー）の定義を確認 |

**読解のコツ**: テーブル定義のコメントから各カラムの用途を理解できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_export_test_result関数の仕様（パッケージ仕様部） |

**主要処理フロー**:
1. **188-193行目**: 関数のシグネチャ定義
2. **1460-1486行目**: 関数の実装

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_download_unit_test_xmlプロシージャの実装 |

**主要処理フロー**:
- **248-295行目**: p_download_unit_test_xmlがf_export_test_resultを呼び出し、HTTPレスポンスとしてXMLをダウンロードさせる
- **264行目**: f_export_test_resultの呼び出し

### プログラム呼び出し階層図

```
APEXアプリケーション (Test Result Files画面)
    │
    └─ qa_apex_app_pkg.p_download_unit_test_xml
           │
           ├─ qa_unit_tests_pkg.f_export_test_result
           │      │
           │      └─ SELECT FROM QA_TEST_RESULTS
           │
           ├─ SELECT FROM QA_TEST_RESULTS (qatr_added_on取得)
           │
           ├─ HTP.init / OWA_UTIL.mime_header
           │
           └─ HTP.prn (XMLをチャンク出力)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_qatr_id           ───▶ f_export_test_result ───▶ l_clob_xml
(テスト結果ID)               │
                             └─ SELECT FROM QA_TEST_RESULTS

l_clob_xml           ───▶ HTTPレスポンス生成 ───▶ XMLファイルダウンロード
l_added_on                   │
                             ├─ mime_header設定
                             └─ チャンク単位で出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_export_test_resultを含むメインパッケージ |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_download_unit_test_xmlを含むAPEX連携パッケージ |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果XMLを格納するテーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
