# 機能設計書 24-APEXルール実行

## 概要

本ドキュメントは、QUASTOシステムにおけるAPEXルール実行機能の設計を記述したものである。APEXアプリケーション/ページを対象としたQUASTOルールを実行し、品質基準に適合しないオブジェクトを返す機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：APEXアプリケーションの品質を自動的にチェックし、コーディング規約違反やベストプラクティスに反するオブジェクトを検出することで、APEXアプリケーションの品質向上を支援する。開発中のAPEXアプリケーションに対してリアルタイムで品質チェックを行い、問題を早期に発見できる。

**機能の利用シーン**：APEXアプリケーションの「Region Plugin」画面で使用される。ユーザーはAPEXアプリケーションID、ページID、ルール番号、クライアント名を指定してルールを実行し、違反オブジェクトの一覧を取得する。

**主要な処理内容**：
1. 入力パラメータの検証（ルール番号、クライアント名の必須チェック）
2. ルールのアクティブ状態を確認
3. ルール情報を取得
4. ルールカテゴリに応じてSQLを動的実行（APEXカテゴリの場合はapp_id、page_idをバインド）
5. ブラックリスト登録されたAPEXアプリケーションを結果から除外
6. 違反オブジェクトの一覧を返却

**関連システム・外部連携**：APEX APIを使用してAPEXアプリケーションのメタデータにアクセスする。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Region Plugin | 主画面 | 選択したルール番号とクライアント名でAPEXルールを実行 |

## 機能種別

データ取得処理 / ルール実行

## 入力仕様

### 入力パラメータ

#### tf_run_rule関数

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_app_id | apex_application_items.application_id%type | No | APEXアプリケーションID | - |
| pi_page_id | apex_application_pages.page_id%type | No | APEXページID | - |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | Yes | ルール番号 | NOT NULL |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | Yes | クライアント名 | NOT NULL |
| pi_target_scheme | varchar2 | No | 対象スキーマ（デフォルト: user） | - |

#### tf_run_rules関数

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_app_id | apex_application_items.application_id%type | No | APEXアプリケーションID | - |
| pi_page_id | apex_application_pages.page_id%type | No | APEXページID | - |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | No | クライアント名（NULLの場合は全クライアント） | - |
| pi_target_scheme | varchar2 | No | 対象スキーマ（デフォルト: user） | - |
| pi_rule_number | qa_rules.qaru_rule_number%type | No | ルール番号（NULLの場合は全ルール） | - |

### 入力データソース

- APEXアプリケーション（Region Plugin）からのユーザー入力
- QA_RULESテーブルのルール定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_rules_t | コレクション型 | 品質基準に適合しないオブジェクトのコレクション |

### 出力先

- 戻り値としてqa_rules_t型コレクションを返却
- APEXアプリケーションで結果を表示

## 処理フロー

### 処理シーケンス（tf_run_rule）

```
1. 入力パラメータの検証
   └─ ルール番号、クライアント名の必須チェック

2. ルールのアクティブ状態確認
   └─ qa_main_pkg.f_is_rule_activeを呼び出し

3. ルール情報の取得
   └─ qa_main_pkg.f_get_ruleを呼び出し

4. ルールカテゴリの判定
   ├─ APEXカテゴリの場合: app_id、page_idをバインドしてSQL実行
   └─ その他のカテゴリの場合: 標準のバインド変数でSQL実行

5. ブラックリスト除外
   └─ p_exclude_not_whitelisted_apex_entriesを呼び出し

6. 結果の返却
   └─ qa_rules_t型コレクションを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ルール番号/クライアント名がNULL?}
    B -->|Yes| C[例外: 必須パラメータ不足]
    B -->|No| D{ルールがアクティブ?}
    D -->|No| E[例外: ルールが非アクティブ]
    D -->|Yes| F[ルール情報を取得]
    F --> G{カテゴリがAPEX?}
    G -->|Yes| H[app_id/page_idをバインドしてSQL実行]
    G -->|No| I[標準バインド変数でSQL実行]
    H --> J[ブラックリスト除外処理]
    I --> K[結果を返却]
    J --> K
    K --> L[終了]
    C --> L
    E --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | ルールアクティブ必須 | 非アクティブなルールは実行できない | 常に適用 |
| BR-24-02 | APEXカテゴリ判定 | qaru_categoryが'APEX'の場合、追加のバインド変数（app_id、page_id）を使用 | カテゴリがAPEXの場合 |
| BR-24-03 | ブラックリスト除外 | ブラックリスト登録されたAPEXアプリケーションは結果から除外される | APEXカテゴリの場合 |
| BR-24-04 | 動的SQL実行 | ルールのSQLは動的に実行され、結果はqa_rules_t型に格納される | 常に適用 |

### 計算ロジック

- ルールSQL内のバインド変数
  - :1 - scheme（スキーマ名）
  - :2 - qaru_id（ルールID）
  - :3 - qaru_category（ルールカテゴリ）
  - :4 - qaru_error_level（エラーレベル）
  - :5 - qaru_object_types（対象オブジェクト型）
  - :6 - qaru_error_message（エラーメッセージ）
  - :7 - qaru_sql（ルールSQL）
  - :8 - app_id（APEXアプリケーションID）※APEXカテゴリのみ
  - :9 - page_id（APEXページID）※APEXカテゴリのみ

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール情報取得 | QA_RULES | SELECT | ルール定義を取得 |
| ルールSQL実行 | 動的SQL | SELECT | ルールに定義されたSQLを動的実行 |
| ブラックリスト参照 | qa_apex_blacklisted_apps_v | SELECT | ブラックリストを確認 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_sql | WHERE qaru_rule_number = pi_qaru_rule_number AND qaru_client_name = pi_qaru_client_name | ルールSQLを取得 |
| SELECT | qaru_category | 同上 | ルールカテゴリを取得 |
| SELECT | その他のqaru_*列 | 同上 | ルール属性を取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | APPLICATION_ERROR | ルール番号またはクライアント名がNULL | 必須パラメータを指定してください |
| -20001 | APPLICATION_ERROR | ルールが非アクティブ | ルールをアクティブ状態にしてください |
| - | NO_DATA_FOUND | 指定されたルールが存在しない | ログ記録後、処理継続（結果なしで返却） |
| - | OTHERS | SQL実行エラーなど | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- ルールSQLの実行時間は、SQLの複雑さとAPEXアプリケーションの規模に依存
- 大規模なAPEXアプリケーションに対しては、ページ単位での実行を推奨

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- ルールSQLは動的に実行されるため、SQLインジェクションのリスクがある（ルール定義時の検証が必要）
- ブラックリスト機能により、特定のAPEXアプリケーションをチェック対象から除外可能

## 備考

- tf_run_rule: 単一ルールを実行
- tf_run_rules: 条件に合致する複数ルールを一括実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ルール実行結果を格納する型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rule_t | 型定義ファイル | qa_rule_tオブジェクト型の属性（qaru_id、scheme_name、object_name等） |
| 1-2 | qa_rules_t | 型定義ファイル | qa_rule_tのコレクション型 |

**読解のコツ**: 戻り値の型であるqa_rules_tがどのような属性を持つかを理解することで、実行結果の構造を把握できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | tf_run_rule関数の仕様（パッケージ仕様部） |

**主要処理フロー**:
1. **19-26行目**: tf_run_rule関数のシグネチャ
2. **28-35行目**: tf_run_rules関数のシグネチャ
3. **99-182行目**: tf_run_rule関数の実装
4. **184-233行目**: tf_run_rules関数の実装

#### Step 3: ブラックリスト除外処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | p_exclude_not_whitelisted_apex_entriesプロシージャの実装 |

**主要処理フロー**:
- **41-96行目**: ブラックリスト除外処理の実装
- **63-64行目**: qa_apex_blacklisted_apps_vビューへのアクセス
- **71行目**: コレクションからの要素削除

### プログラム呼び出し階層図

```
APEXアプリケーション (Region Plugin)
    │
    ├─ qa_apex_api_pkg.tf_run_rule (単一ルール実行)
    │      │
    │      ├─ qa_main_pkg.f_is_rule_active
    │      │
    │      ├─ qa_main_pkg.f_get_rule
    │      │
    │      ├─ EXECUTE IMMEDIATE (動的SQL実行)
    │      │
    │      └─ qa_apex_api_pkg.p_exclude_not_whitelisted_apex_entries
    │             │
    │             └─ SELECT FROM qa_apex_blacklisted_apps_v
    │
    └─ qa_apex_api_pkg.tf_run_rules (複数ルール実行)
           │
           ├─ FOR loop: QA_RULESからAPEXカテゴリのアクティブルールを取得
           │
           └─ tf_run_rule (各ルールに対して呼び出し)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_app_id            ───▶ tf_run_rule ───▶ qa_rules_t (違反オブジェクト)
pi_page_id                   │
pi_qaru_rule_number          ├─ ルールアクティブ確認
pi_qaru_client_name          ├─ ルール情報取得
pi_target_scheme             ├─ 動的SQL実行
                             └─ ブラックリスト除外

qa_rules_t           ───▶ p_exclude_not_whitelisted_apex_entries ───▶ フィルタ済みqa_rules_t
                             │
                             └─ qa_apex_blacklisted_apps_v参照
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | ソース | tf_run_rule、tf_run_rules、p_exclude_not_whitelisted_apex_entriesを含むメインパッケージ |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | f_is_rule_active、f_get_rule関数を提供 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
