# 機能設計書 25-APEXブラックリスト除外

## 概要

本ドキュメントは、QUASTOシステムにおけるAPEXブラックリスト除外機能の設計を記述したものである。ブラックリスト登録されたAPEXアプリケーションやページをルール実行結果から除外する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：特定のAPEXアプリケーションやページを品質チェックの対象外とすることで、レガシーアプリケーションや外部ライブラリなど、品質ルールの適用が適切でないオブジェクトを除外する。これにより、実際に管理対象とすべきオブジェクトに焦点を当てた品質チェックが可能となる。

**機能の利用シーン**：APEXルール実行（tf_run_rule）の内部で自動的に呼び出される。ルール実行後、結果セットに含まれるAPEXアプリケーション/ページをブラックリストと照合し、該当するエントリを除外する。

**主要な処理内容**：
1. ルール実行結果（qa_rules_t型コレクション）を受け取る
2. ルールに定義されたqaru_app_id、qaru_page_idを取得
3. 各結果エントリについて以下をチェック：
   - qa_apex_blacklisted_apps_vビューにアプリケーションIDが登録されているか
   - ルールに定義されたapp_idリストに含まれているか
   - ルールに定義されたpage_idリストに含まれているか
4. 条件に合致しないエントリをコレクションから削除
5. フィルタリング済みのコレクションを返却（IN OUTパラメータ）

**関連システム・外部連携**：qa_apex_blacklisted_apps_vビューを参照してブラックリストを取得する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

本機能は内部処理として使用され、直接関連する画面はない。ただし、以下の画面でのルール実行時に間接的に使用される：

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Region Plugin | 間接利用 | APEXルール実行時にブラックリスト除外処理が適用される |

## 機能種別

データフィルタリング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qa_rules_t | qa_rules_t | Yes | ルール実行結果のコレクション（IN OUT） | NOT NULL |

### 入力データソース

- qa_apex_api_pkg.tf_run_rule関数からのルール実行結果
- QA_RULESテーブルのqaru_app_id、qaru_page_id列

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pi_qa_rules_t | qa_rules_t | ブラックリストエントリを除外した後のコレクション（IN OUT） |

### 出力先

- 入力パラメータを直接変更（IN OUTパラメータ）

## 処理フロー

### 処理シーケンス

```
1. 入力コレクションの空チェック
   └─ コレクションが空の場合は処理終了

2. ルール定義からapp_id/page_idリストを取得
   └─ コレクションの最初の要素のqaru_idを使用してQA_RULESテーブルからqaru_app_id、qaru_page_idを取得

3. 各エントリのフィルタリング
   └─ コレクションの各要素に対してループ処理
       ├─ qa_apex_blacklisted_apps_vでアプリケーションIDのブラックリストチェック
       ├─ ルール定義のapp_idリストとの照合
       ├─ ルール定義のpage_idリストとの照合
       └─ 条件に合致しない場合はコレクションから削除

4. 処理完了
   └─ フィルタリング済みのコレクションを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{コレクションが空?}
    B -->|Yes| M[終了]
    B -->|No| C[ルール定義からapp_id/page_idリスト取得]
    C --> D[各エントリに対してループ開始]
    D --> E{ブラックリストに登録?}
    E -->|Yes| F[エントリを削除]
    E -->|No| G{ルールのapp_idリストに含まれる?}
    G -->|No| F
    G -->|Yes| H{page_idリストの指定あり?}
    H -->|No| I[次のエントリへ]
    H -->|Yes| J{page_idリストに含まれる?}
    J -->|No| F
    J -->|Yes| I
    F --> I
    I --> K{全エントリ処理完了?}
    K -->|No| D
    K -->|Yes| L[フィルタリング済みコレクションを返却]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | ブラックリスト除外 | qa_apex_blacklisted_apps_vビューに登録されたアプリケーションは結果から除外される | 常に適用 |
| BR-25-02 | アプリケーションIDフィルタ | ルールにqaru_app_idが定義されている場合、リストに含まれないアプリケーションは除外される | qaru_app_idが定義されている場合 |
| BR-25-03 | ページIDフィルタ | ルールにqaru_page_idが定義されている場合、リストに含まれないページは除外される | qaru_page_idが定義されている場合 |
| BR-25-04 | IN OUTパラメータ | 入力コレクションを直接変更し、除外されたエントリは完全に削除される | 常に適用 |

### 計算ロジック

- app_idリストチェック: `instr(',' || l_app_ids || ',', ',' || apex_app_id || ',') = 0`の場合、除外対象
- page_idリストチェック: `instr(',' || l_page_ids || ',', ',' || page_id || ',') > 0`の場合、含まれていると判定

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル/ビュー | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール定義取得 | QA_RULES | SELECT | qaru_app_id、qaru_page_idを取得 |
| ブラックリスト参照 | qa_apex_blacklisted_apps_v | SELECT | アプリケーションIDがブラックリストに登録されているかチェック |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_app_id | WHERE qaru_id = コレクションの最初の要素のqaru_id | アプリケーションIDリスト（カンマ区切り） |
| SELECT | qaru_page_id | 同上 | ページIDリスト（カンマ区切り） |

#### qa_apex_blacklisted_apps_v

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | COUNT(1) | WHERE application_id = apex_app_id | ブラックリスト登録チェック |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | OTHERS | 処理中にエラーが発生した場合 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。ただし、入力コレクションを直接変更するため、呼び出し元での取り扱いに注意が必要。

## パフォーマンス要件

- コレクションの各要素に対してループ処理を行うため、要素数に比例して処理時間が増加
- qa_apex_blacklisted_apps_vへのアクセスは要素ごとに行われるため、大量の要素がある場合はパフォーマンスに影響

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- ブラックリストの管理はデータベース側で行われ、本機能は参照のみを行う

## 備考

- 本プロシージャはIN OUTパラメータを使用し、入力コレクションを直接変更する
- apex_string.split関数を使用してpage_idのカンマ区切りを解析する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィルタリング対象となるコレクション型と、ルール定義テーブルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rule_t / qa_rules_t | 型定義ファイル | qa_rule_tの属性（特にapex_app_id、apex_page_id）を確認 |

**読解のコツ**: コレクション内の各要素がどのような属性を持つかを理解することで、フィルタリングロジックの理解が容易になる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | p_exclude_not_whitelisted_apex_entriesプロシージャの仕様 |

**主要処理フロー**:
1. **17行目**: プロシージャのシグネチャ定義（IN OUTパラメータ）
2. **41-96行目**: プロシージャの実装

#### Step 3: フィルタリングロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | フィルタリングループの処理 |

**主要処理フロー**:
- **49-56行目**: ルール定義からqaru_app_id、qaru_page_idを取得
- **58-87行目**: 各エントリに対するフィルタリングループ
- **60-64行目**: ブラックリストチェック
- **66-70行目**: app_idリストチェック
- **72-85行目**: page_idリストチェック（apex_string.splitを使用）
- **71行目、83行目**: コレクションからの要素削除

### プログラム呼び出し階層図

```
qa_apex_api_pkg.tf_run_rule
    │
    └─ qa_apex_api_pkg.p_exclude_not_whitelisted_apex_entries
           │
           ├─ SELECT FROM QA_RULES (qaru_app_id, qaru_page_id取得)
           │
           ├─ FOR loop: コレクションの各要素
           │      │
           │      ├─ SELECT FROM qa_apex_blacklisted_apps_v
           │      │
           │      ├─ instr (app_idリストチェック)
           │      │
           │      ├─ apex_string.split (page_idリスト分割)
           │      │
           │      └─ pi_qa_rules_t.delete (条件に合致しない場合)
           │
           └─ 処理完了 (IN OUTパラメータで結果を返却)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_qa_rules_t        ───▶ p_exclude_not_whitelisted_apex_entries ───▶ pi_qa_rules_t (フィルタ済み)
(IN OUT)                   │
                           ├─ QA_RULESから設定取得
                           │      └─ qaru_app_id, qaru_page_id
                           │
                           ├─ 各要素をチェック
                           │      ├─ ブラックリストチェック
                           │      ├─ app_idリストチェック
                           │      └─ page_idリストチェック
                           │
                           └─ 条件に合致しない要素を削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | ソース | p_exclude_not_whitelisted_apex_entriesを含むメインパッケージ |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
