# 機能設計書 26-ダッシュボードデータ取得

## 概要

本ドキュメントは、QUASTOシステムにおけるダッシュボードデータ取得機能の設計を記述したものである。APEXダッシュボードページ用のテスト結果データをパイプライン関数で取得する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：ダッシュボード画面でテスト実行結果を一覧表示するためのデータを効率的に取得する。APEX Regionのクエリコンテキストを使用することで、ファセット検索との連携やフィルタリング機能との統合を実現する。

**機能の利用シーン**：APEXアプリケーションの「Dashboard」画面で使用される。テスト実行結果の一覧表示、Quota円グラフ、タイムラインチャートなどのデータソースとして機能する。

**主要な処理内容**：
1. ページIDとリージョン静的IDを受け取る
2. APEX_APPLICATION_PAGE_REGIONSからリージョンIDを取得
3. apex_region.open_query_contextでリージョンのクエリコンテキストを開く
4. 各カラムのインデックスを取得
5. コンテキストから行を読み取りながら、パイプラインでqa_test_results_row_t型のレコードを返却
6. コンテキストをクローズ

**関連システム・外部連携**：APEX APIのapex_region、apex_execパッケージを使用してリージョンのクエリ結果にアクセスする。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 主画面 | テスト実行結果の一覧表示、Quota円グラフ、タイムラインチャートのデータを取得 |

## 機能種別

データ取得処理 / パイプライン関数

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_page_id | NUMBER | Yes | APEXページID | NOT NULL |
| pi_region_static_id | VARCHAR2 | Yes | リージョンの静的ID | NOT NULL |

### 入力データソース

- APEXアプリケーションのセッション情報（V('APP_ID')）
- APEX_APPLICATION_PAGE_REGIONSビュー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_test_results_table_t | テーブル型（パイプライン） | テスト結果のコレクション |

### 出力データ詳細（qa_test_results_row_t型）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qatr_id | NUMBER | テスト実行ID |
| qatr_date | DATE | テスト実行日時 |
| qatr_scheme_name | VARCHAR2(100) | スキーマ名 |
| qatr_category | VARCHAR2(100) | ルールカテゴリ |
| qatr_result | VARCHAR2(20) | テスト結果 |
| qaru_name | VARCHAR2(100) | ルール名 |
| qaru_layer | VARCHAR2(20) | ルールレイヤー |
| qaru_error_level | VARCHAR2(20) | エラーレベル |
| qaru_is_active | VARCHAR2(10) | ルールアクティブ状態 |
| qaru_client_name | VARCHAR2(4000) | クライアント名 |
| qatr_program_name | VARCHAR2(500) | プログラム名 |

### 出力先

- パイプライン関数として結果セットを返却
- APEXリージョンでの表示

## 処理フロー

### 処理シーケンス

```
1. リージョンIDの取得
   └─ APEX_APPLICATION_PAGE_REGIONSからregion_idを取得

2. クエリコンテキストのオープン
   └─ apex_region.open_query_contextを呼び出し

3. カラムインデックスの取得
   └─ get_column_indexesプロシージャで11カラムのインデックスを取得

4. 行データの読み取りとパイプライン出力
   └─ apex_exec.next_rowでループしながらPIPE ROWで出力

5. コンテキストのクローズ
   └─ apex_exec.closeを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リージョンIDを取得]
    B --> C[クエリコンテキストをオープン]
    C --> D[カラムインデックスを取得]
    D --> E{次の行あり?}
    E -->|Yes| F[qa_test_results_row_tを生成]
    F --> G[PIPE ROW]
    G --> E
    E -->|No| H[コンテキストをクローズ]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | パイプライン関数 | PIPELINED関数として実装され、行ごとにデータを返却する | 常に適用 |
| BR-26-02 | APEXコンテキスト使用 | APEXリージョンのクエリコンテキストを使用してデータを取得する | 常に適用 |
| BR-26-03 | セッション依存 | V('APP_ID')を使用してAPEXアプリケーションIDを取得する | 常に適用 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル/ビュー | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リージョンID取得 | APEX_APPLICATION_PAGE_REGIONS | SELECT | リージョンIDを取得 |
| クエリコンテキスト | APEXリージョン定義 | SELECT | リージョンに定義されたクエリを実行 |

### テーブル別操作詳細

#### APEX_APPLICATION_PAGE_REGIONS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | region_id | WHERE application_id = V('APP_ID') AND page_id = pi_page_id AND static_id = pi_region_static_id | リージョンIDを取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NO_DATA_NEEDED | パイプライン出力が不要になった場合 | コンテキストをクローズして正常終了 |
| - | OTHERS | その他のエラー発生時 | コンテキストをクローズして例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- パイプライン関数により、大量データでもメモリ効率的に処理可能
- クエリコンテキストの使用により、APEXリージョンのフィルタリングと連携

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- APEXセッション情報を使用するため、認証されたユーザーのコンテキストで実行される

## 備考

- 本関数はAPEXアプリケーション内からのみ呼び出されることを想定している
- リージョンの静的ID「TEST_REPORT」が使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パイプライン関数の戻り値型を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | qa_test_results_row_tオブジェクト型の11属性を確認 |
| 1-2 | qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | qa_test_results_row_tのテーブル型 |

**読解のコツ**: パイプライン関数の戻り値型がqa_test_results_table_tであり、各行がqa_test_results_row_t型であることを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | get_faceted_search_dashboard_data関数の仕様 |

**主要処理フロー**:
1. **19-23行目**: 関数のシグネチャ定義（PIPELINED）
2. **59-115行目**: 関数の実装

#### Step 3: APEX API呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | apex_region、apex_exec APIの使用方法 |

**主要処理フロー**:
- **80-85行目**: APEX_APPLICATION_PAGE_REGIONSからリージョンIDを取得
- **87-88行目**: apex_region.open_query_contextでコンテキストをオープン
- **90行目**: get_column_indexesで11カラムのインデックスを取得
- **92-105行目**: apex_exec.next_rowでループしながらPIPE ROW
- **107行目**: apex_exec.closeでコンテキストをクローズ

### プログラム呼び出し階層図

```
APEXアプリケーション (Dashboard画面)
    │
    └─ qa_apex_app_pkg.get_faceted_search_dashboard_data
           │
           ├─ SELECT FROM APEX_APPLICATION_PAGE_REGIONS
           │
           ├─ apex_region.open_query_context
           │
           ├─ get_column_indexes (内部プロシージャ)
           │      │
           │      └─ apex_exec.get_column_position × 11カラム
           │
           ├─ WHILE apex_exec.next_row LOOP
           │      │
           │      ├─ apex_exec.get_number / get_date / get_varchar2
           │      │
           │      └─ PIPE ROW (qa_test_results_row_t)
           │
           └─ apex_exec.close
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_page_id           ───▶ get_faceted_search_dashboard_data ───▶ qa_test_results_table_t
pi_region_static_id        │                                        (PIPELINED)
                           ├─ リージョンID取得
                           │
                           ├─ クエリコンテキストオープン
                           │
                           ├─ カラムインデックス取得
                           │
                           └─ 行ループ → PIPE ROW
                                  │
                                  └─ qa_test_results_row_t
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | get_faceted_search_dashboard_dataを含むメインパッケージ |
| qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | 型定義 | 戻り値行の型定義 |
| qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | 型定義 | 戻り値テーブルの型定義 |
