# 機能設計書 27-ルールJSONアップロード

## 概要

本ドキュメントは、QUASTOシステムにおけるルールJSONアップロード機能の設計を記述したものである。APEXアプリケーションからJSON形式のルールファイルをアップロードし、QA_RULESテーブルにインポートする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：他環境で定義されたQUASTOルールを現環境に取り込むことで、ルール定義の共有・移行を可能にする。開発環境で作成したルールを本番環境にデプロイする際や、ルール定義のバックアップからのリストアなどのユースケースに対応する。

**機能の利用シーン**：APEXアプリケーションの「Rule Files」画面で使用される。ユーザーはJSON形式のルールファイルを選択し、アップロードボタンをクリックすることでインポートを実行する。

**主要な処理内容**：
1. ファイル名を受け取る
2. APEX_APPLICATION_TEMP_FILESからファイル内容（BLOB）をCLOBに変換して取得
3. MIMEタイプが「application/json」であることを検証
4. qa_export_import_rules_pkg.f_import_clob_to_qa_import_filesでインポートファイルテーブルに保存
5. qa_export_import_rules_pkg.p_import_clob_to_rules_tableでQA_RULESテーブルにインポート

**関連システム・外部連携**：APEXのファイルアップロード機能（APEX_APPLICATION_TEMP_FILES）を使用する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Rule Files | 主画面 | JSONファイルをアップロードしてルールをインポート |

## 機能種別

ファイルインポート / データ登録処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_file_name | VARCHAR2 | Yes | アップロードされたファイルの名前（APEX_APPLICATION_TEMP_FILES.name） | NOT NULL |

### 入力データソース

- APEX_APPLICATION_TEMP_FILES: アップロードされたJSONファイル

## 出力仕様

### 出力データ

本プロシージャは戻り値を持たない。

### 出力先

- QA_IMPORT_FILESテーブル: インポートファイル情報を保存
- QA_RULESテーブル: ルール定義をMERGE

## 処理フロー

### 処理シーケンス

```
1. ファイル情報の取得
   └─ APEX_APPLICATION_TEMP_FILESからblob_content、mime_type、filenameを取得
   └─ blob_contentをCLOBに変換

2. MIMEタイプの検証
   └─ MIMEタイプが'application/json'でない場合は例外を発生

3. インポートファイルテーブルへの保存
   └─ qa_export_import_rules_pkg.f_import_clob_to_qa_import_filesを呼び出し
   └─ qaif_idを取得

4. ルールテーブルへのインポート
   └─ qa_export_import_rules_pkg.p_import_clob_to_rules_tableを呼び出し
   └─ QA_RULESテーブルにMERGE
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[APEX_APPLICATION_TEMP_FILESからファイル取得]
    B --> C{MIMEタイプがapplication/json?}
    C -->|No| D[例外: 無効なMIMEタイプ]
    C -->|Yes| E[インポートファイルテーブルに保存]
    E --> F[ルールテーブルにMERGE]
    F --> G[終了]
    D --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | MIMEタイプ検証 | アップロードファイルのMIMEタイプはapplication/jsonでなければならない | 常に適用 |
| BR-27-02 | インポート履歴保存 | インポートしたJSONファイルはQA_IMPORT_FILESテーブルに保存される | 常に適用 |
| BR-27-03 | MERGEによるインポート | 既存ルール（同一client_name、rule_number）は更新、新規ルールは挿入 | 常に適用 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル取得 | APEX_APPLICATION_TEMP_FILES | SELECT | アップロードファイルを取得 |
| インポート履歴保存 | QA_IMPORT_FILES | INSERT | インポートファイル情報を保存 |
| ルールインポート | QA_RULES | MERGE | ルール定義を更新/挿入 |

### テーブル別操作詳細

#### APEX_APPLICATION_TEMP_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | blob_content | WHERE name = pi_file_name | CLOBに変換 |
| SELECT | mime_type | 同上 | application/jsonを期待 |
| SELECT | filename | 同上 | 元のファイル名 |

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qaif_filename | 元のファイル名 | - |
| INSERT | qaif_mimetype | application/json | - |
| INSERT | qaif_clob_data | JSON CLOBデータ | - |

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| MERGE | 全カラム | ON qaru_client_name AND qaru_rule_number | 既存は更新、新規は挿入 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | APPLICATION_ERROR | MIMEタイプがapplication/jsonでない場合 | 正しい形式のJSONファイルをアップロードしてください |
| - | OTHERS | その他のエラー発生時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

呼び出し元のトランザクション内で実行される。エラー発生時は呼び出し元でロールバックが必要。

## パフォーマンス要件

- JSONファイルのサイズに応じてI/O負荷が発生する可能性がある
- 大量のルール定義を含むJSONの場合、MERGEに時間がかかる可能性がある

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- JSONファイルの内容検証はMIMEタイプのみで行われるため、悪意のあるJSONがインポートされる可能性がある
- ルールSQLは動的に実行されるため、JSONに含まれるSQLに対する検証が必要

## 備考

- インポートされるJSONフォーマットはqa_export_import_rules_pkg.f_export_rules_table_to_clobで出力される形式に準拠
- 既存ルールの削除は行われず、更新のみ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

インポート対象のテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_import_files | DDL定義ファイル | QA_IMPORT_FILESテーブルの構造 |
| 1-2 | qa_rules | DDL定義ファイル | QA_RULESテーブルの構造 |

**読解のコツ**: インポート処理のターゲットとなるテーブルを理解することで、処理の流れが明確になる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_jsonプロシージャの仕様 |

**主要処理フロー**:
1. **29行目**: プロシージャのシグネチャ定義
2. **117-161行目**: プロシージャの実装

#### Step 3: インポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_import_clob_to_qa_import_files、p_import_clob_to_rules_tableの実装 |

**主要処理フロー**:
- **318-364行目**: f_import_clob_to_qa_import_filesがQA_IMPORT_FILESに挿入
- **367-463行目**: p_import_clob_to_rules_tableがJSON解析しQA_RULESにMERGE

### プログラム呼び出し階層図

```
APEXアプリケーション (Rule Files画面)
    │
    └─ qa_apex_app_pkg.p_upload_rules_json
           │
           ├─ SELECT FROM APEX_APPLICATION_TEMP_FILES
           │      └─ to_clob(blob_content)
           │
           ├─ MIMEタイプチェック (application/json)
           │
           ├─ qa_export_import_rules_pkg.f_import_clob_to_qa_import_files
           │      │
           │      └─ INSERT INTO QA_IMPORT_FILES
           │
           └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table
                  │
                  ├─ SELECT FROM QA_IMPORT_FILES
                  │
                  ├─ json_table (JSON解析)
                  │
                  └─ MERGE INTO QA_RULES
```

### データフロー図

```
[入力]                           [処理]                              [出力]

JSONファイル         ───▶ APEX_APPLICATION_TEMP_FILES ───▶ l_clob_content
(ユーザーアップロード)

l_clob_content       ───▶ MIMEタイプチェック ───▶ application/json確認
l_mime_type

l_clob_content       ───▶ f_import_clob_to_qa_import_files ───▶ QA_IMPORT_FILES
l_file_name                                                      └─ l_qaif_id

l_qaif_id            ───▶ p_import_clob_to_rules_table ───▶ QA_RULES (MERGE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_upload_rules_jsonを含むメインパッケージ |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | インポート処理の実装 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
