# 機能設計書 28-ルールJSONダウンロード

## 概要

本ドキュメントは、QUASTOシステムにおけるルールJSONダウンロード機能の設計を記述したものである。QA_RULESテーブルに定義されたルールをJSON形式でエクスポートし、ファイルとしてダウンロードする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOルール定義を外部に出力することで、ルール定義のバックアップ、他環境への移行、バージョン管理などのユースケースに対応する。開発環境で作成したルールを本番環境にデプロイする際の中間ファイルとして活用される。

**機能の利用シーン**：APEXアプリケーションの「Rule Files」画面で使用される。ユーザーはクライアント名を選択し、ダウンロードボタンをクリックすることでルール定義をJSON形式でダウンロードする。

**主要な処理内容**：
1. クライアント名を受け取る
2. qa_export_import_rules_pkg.f_export_rules_table_to_clobでルールをJSON CLOBに変換
3. クライアント名を統一フォーマットに変換（ファイル名用）
4. HTTPレスポンスヘッダーを設定
5. JSON CLOBをチャンク単位でHTTPレスポンスに出力
6. APEXエンジンを停止

**関連システム・外部連携**：HTP、OWA_UTILパッケージを使用してHTTPレスポンスを生成する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Rule Files | 主画面 | クライアント名を選択してルールをJSON形式でダウンロード |

## 機能種別

ファイルエクスポート / データ取得処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_client_name | VARCHAR2 | Yes | エクスポート対象のクライアント名 | NOT NULL |

### 入力データソース

- APEXアプリケーションからのユーザー選択
- QA_RULESテーブルのルール定義

## 出力仕様

### 出力データ

本プロシージャは戻り値を持たない。HTTPレスポンスとしてJSONファイルを出力する。

### 出力ファイル形式

- ファイル名: `export_rules_{client_name}_{timestamp}.json`
  - client_name: 統一フォーマットに変換（小文字）
  - timestamp: YYYYMMDDHH24MI形式
- MIMEタイプ: application/json
- エンコーディング: UTF-8

### 出力先

- HTTPレスポンス（ブラウザでダウンロード）

## 処理フロー

### 処理シーケンス

```
1. ルールのエクスポート
   └─ qa_export_import_rules_pkg.f_export_rules_table_to_clobを呼び出し
   └─ JSON CLOBを取得

2. ファイル名の生成
   └─ qa_utils_pkg.f_get_unified_stringでクライアント名を統一フォーマットに変換
   └─ タイムスタンプを付与してファイル名を生成

3. HTTPレスポンスヘッダーの設定
   └─ HTP.initでHTTP出力を初期化
   └─ OWA_UTIL.mime_headerでMIMEタイプを設定
   └─ Content-Length、Content-Type、Cache-Control、Content-Dispositionを設定
   └─ OWA_UTIL.http_header_closeでヘッダーをクローズ

4. レスポンスボディの出力
   └─ JSON CLOBをチャンク（3000バイト）単位でループ出力
   └─ HTP.prnで出力

5. APEXエンジンの停止
   └─ apex_application.stop_apex_engineを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ルールをJSON CLOBにエクスポート]
    B --> C[ファイル名を生成]
    C --> D[HTTPレスポンスヘッダー設定]
    D --> E[JSON CLOBをチャンク出力]
    E --> F{全データ出力完了?}
    F -->|No| E
    F -->|Yes| G[APEXエンジン停止]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | ファイル名規則 | ファイル名は「export_rules_{client_name}_{timestamp}.json」形式 | 常に適用 |
| BR-28-02 | チャンク出力 | JSON CLOBは3000バイト単位でチャンク出力される | 常に適用 |
| BR-28-03 | APEXエンジン停止 | ダウンロード完了後、APEXエンジンを停止して通常のページレンダリングを防止 | 常に適用 |

### 計算ロジック

- オフセット計算: `l_offset := l_offset + l_chunk` （l_chunk = 3000）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール取得 | QA_RULES | SELECT | 指定クライアントのルール定義を取得 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全ルール属性 | WHERE qaru_client_name = pi_client_name | f_export_rules_table_to_clob内で実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | apex_application.e_stop_apex_engine | 正常終了時 | 例外を捕捉して処理を終了（正常動作） |
| - | OTHERS | その他のエラー発生時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- 大量のルール定義がある場合、JSON生成に時間がかかる可能性がある
- チャンク出力により、メモリ効率的にHTTPレスポンスを生成

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- ルール定義にはSQLが含まれるため、エクスポートファイルの取り扱いに注意が必要

## 備考

- JSONフォーマットはqa_export_import_rules_pkg.f_export_rules_table_to_clobで定義された形式
- json_serializeでPRETTY形式に整形される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エクスポート対象のテーブル構造とJSONフォーマットを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules | DDL定義ファイル | QA_RULESテーブルの構造 |
| 1-2 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | JSONフォーマットの構造（f_export_rules_table_to_clob） |

**読解のコツ**: JSONフォーマットはネストされた構造（client_names > categories > rules）を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_download_rules_jsonプロシージャの仕様 |

**主要処理フロー**:
1. **35行目**: プロシージャのシグネチャ定義
2. **163-207行目**: プロシージャの実装

#### Step 3: エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_export_rules_table_to_clobの実装 |

**主要処理フロー**:
- **82-239行目**: f_export_rules_table_to_clobがQA_RULESからJSONを生成
- **171-195行目**: ルールループでJSONオブジェクトを構築
- **220-223行目**: json_serializeでPRETTY形式に整形

### プログラム呼び出し階層図

```
APEXアプリケーション (Rule Files画面)
    │
    └─ qa_apex_app_pkg.p_download_rules_json
           │
           ├─ qa_export_import_rules_pkg.f_export_rules_table_to_clob
           │      │
           │      ├─ SELECT FROM QA_RULES (client_name単位)
           │      │
           │      ├─ json_object_t / json_array_t (JSON構築)
           │      │
           │      └─ json_serialize (PRETTY形式)
           │
           ├─ qa_utils_pkg.f_get_unified_string (ファイル名用)
           │
           ├─ HTP.init / OWA_UTIL.mime_header (HTTPヘッダー)
           │
           ├─ LOOP: HTP.prn (チャンク出力)
           │
           └─ apex_application.stop_apex_engine
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_client_name       ───▶ f_export_rules_table_to_clob ───▶ l_clob_json
                           │
                           └─ QA_RULES → JSON変換

l_clob_json          ───▶ HTTPレスポンス生成 ───▶ JSONファイルダウンロード
pi_client_name             │
                           ├─ ファイル名生成
                           ├─ ヘッダー設定
                           └─ チャンク出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_download_rules_jsonを含むメインパッケージ |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | エクスポート処理の実装 |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | f_get_unified_string関数を提供 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
