# 機能設計書 29-テスト結果XMLアップロード

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果XMLアップロード機能の設計を記述したものである。APEXアプリケーションからXML形式のテスト結果ファイルをアップロードし、QA_TEST_RESULTSテーブルにインポートする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：他環境で実行されたutPLSQLテスト結果を現環境に取り込むことで、複数環境間でのテスト結果の共有・集約を可能にする。CI/CDパイプラインで生成されたテスト結果を手動でインポートする場合や、バックアップからのリストアなどのユースケースに対応する。

**機能の利用シーン**：APEXアプリケーションの「Test Result Files」画面で使用される。ユーザーはXML形式のテスト結果ファイルを選択し、アップロードボタンをクリックすることでインポートを実行する。

**主要な処理内容**：
1. ファイル名を受け取る
2. APEX_APPLICATION_TEMP_FILESからファイル内容（BLOB）をCLOBに変換して取得
3. MIMEタイプが「application/xml」であることを検証
4. qa_unit_tests_pkg.f_import_test_resultでQA_TEST_RESULTSテーブルに保存

**関連システム・外部連携**：APEXのファイルアップロード機能（APEX_APPLICATION_TEMP_FILES）を使用する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Test Result Files | 補助機能 | APEXアプリからXML形式のテスト結果をアップロード処理 |

## 機能種別

ファイルインポート / データ登録処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_file_name | VARCHAR2 | Yes | アップロードされたファイルの名前（APEX_APPLICATION_TEMP_FILES.name） | NOT NULL |

### 入力データソース

- APEX_APPLICATION_TEMP_FILES: アップロードされたXMLファイル

## 出力仕様

### 出力データ

本プロシージャは戻り値を持たない。

### 出力先

- QA_TEST_RESULTSテーブル: テスト結果XMLを保存

## 処理フロー

### 処理シーケンス

```
1. ファイル情報の取得
   └─ APEX_APPLICATION_TEMP_FILESからblob_content、mime_typeを取得
   └─ blob_contentをCLOBに変換

2. MIMEタイプの検証
   └─ MIMEタイプが'application/xml'でない場合は例外を発生

3. テスト結果のインポート
   └─ qa_unit_tests_pkg.f_import_test_resultを呼び出し
   └─ QA_TEST_RESULTSテーブルに挿入
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[APEX_APPLICATION_TEMP_FILESからファイル取得]
    B --> C{MIMEタイプがapplication/xml?}
    C -->|No| D[例外: 無効なMIMEタイプ]
    C -->|Yes| E[f_import_test_resultを呼び出し]
    E --> F[QA_TEST_RESULTSに保存]
    F --> G[終了]
    D --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | MIMEタイプ検証 | アップロードファイルのMIMEタイプはapplication/xmlでなければならない | 常に適用 |
| BR-29-02 | インポート説明 | qatr_description列には'Imported by User'が固定で設定される | 常に適用 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル取得 | APEX_APPLICATION_TEMP_FILES | SELECT | アップロードファイルを取得 |
| テスト結果保存 | QA_TEST_RESULTS | INSERT | テスト結果XMLを保存 |

### テーブル別操作詳細

#### APEX_APPLICATION_TEMP_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | blob_content | WHERE name = pi_file_name | CLOBに変換 |
| SELECT | mime_type | 同上 | application/xmlを期待 |

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qatr_xml_result | XML CLOBデータ | - |
| INSERT | qatr_description | 'Imported by User' | 固定値 |
| INSERT | qatr_added_on | sysdate（デフォルト） | - |
| INSERT | qatr_added_by | USER（デフォルト） | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | APPLICATION_ERROR | MIMEタイプがapplication/xmlでない場合 | 正しい形式のXMLファイルをアップロードしてください |
| - | OTHERS | その他のエラー発生時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

呼び出し元のトランザクション内で実行される。エラー発生時は呼び出し元でロールバックが必要。

## パフォーマンス要件

- XMLファイルのサイズに応じてI/O負荷が発生する可能性がある

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- XMLファイルの内容検証はMIMEタイプのみで行われるため、悪意のあるXMLがインポートされる可能性がある

## 備考

- インポートされるXMLはutPLSQLが生成するJUnit形式を想定
- XMLのパース・検証は本機能では行わない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

インポート対象のテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | QA_TEST_RESULTSテーブルの構造、特にqatr_xml_result列 |

**読解のコツ**: テーブル定義のコメントから各カラムの用途を理解できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_unit_test_xmlプロシージャの仕様 |

**主要処理フロー**:
1. **41行目**: プロシージャのシグネチャ定義
2. **209-246行目**: プロシージャの実装

#### Step 3: インポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_import_test_resultの実装 |

**主要処理フロー**:
- **1435-1458行目**: f_import_test_resultがQA_TEST_RESULTSに挿入

### プログラム呼び出し階層図

```
APEXアプリケーション (Test Result Files画面)
    │
    └─ qa_apex_app_pkg.p_upload_unit_test_xml
           │
           ├─ SELECT FROM APEX_APPLICATION_TEMP_FILES
           │      └─ to_clob(blob_content)
           │
           ├─ MIMEタイプチェック (application/xml)
           │
           └─ qa_unit_tests_pkg.f_import_test_result
                  │
                  └─ INSERT INTO QA_TEST_RESULTS
```

### データフロー図

```
[入力]                           [処理]                              [出力]

XMLファイル          ───▶ APEX_APPLICATION_TEMP_FILES ───▶ l_clob_content
(ユーザーアップロード)

l_clob_content       ───▶ MIMEタイプチェック ───▶ application/xml確認
l_mime_type

l_clob_content       ───▶ f_import_test_result ───▶ QA_TEST_RESULTS (INSERT)
                                                    └─ l_qatr_id
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_upload_unit_test_xmlを含むメインパッケージ |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_import_test_result関数を提供 |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果XMLを格納するテーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
