# 機能設計書 3-全ルール実行

## 概要

本ドキュメントは、QUASTOシステムにおける全ルール実行機能の設計仕様を記述する。

### 本機能の処理概要

全ルール実行機能は、指定したクライアント名に紐づくすべての有効なルールを順次実行し、品質基準に適合しないデータベースオブジェクトを一括で検出・返却する機能である。qa_api_pkg.tf_run_rules関数として実装されており、先行ルール依存関係を考慮した実行順序制御が特徴である。

**業務上の目的・背景**：プロジェクト全体の品質を包括的に検証するために、定義されたすべてのルールを一括で実行する必要がある。先行ルールの成功/失敗に基づいて後続ルールの実行可否を判断することで、依存関係のあるルール群を正しい順序で効率的に実行できる。定期的な品質チェックや、リリース前の最終確認に活用される。

**機能の利用シーン**：
- プロジェクト全体の品質チェックを一括で実行する場合
- スケジューラジョブによる定期的な品質監視
- リリース前の包括的な品質検証
- APEXリージョンプラグインでルール未選択時に全ルール実行

**主要な処理内容**：
1. 入力パラメータ（クライアント名、対象スキーマ）のバリデーション
2. 先行ルール依存関係のループ検出
3. クライアント名に紐づく全ルール番号を先行ルール順序で取得
4. 各ルールの先行ルール成功状態をチェック
5. 先行ルールがすべて成功している場合のみ後続ルールを実行
6. 各ルールの実行結果を集約して返却
7. 実行状態（成功/失敗）を追跡して後続ルールの実行可否を判断

**関連システム・外部連携**：APEXリージョンプラグインから呼び出され、utPLSQLユニットテストとも連携する。スケジューラジョブにより定期実行可能。

**権限による制御**：authid current_userにより実行ユーザーの権限でSQLが実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Region Plugin | 補助機能 | ルール未選択時に指定クライアントの全ルールを実行 |

## 機能種別

データ検索 / 品質検証 / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_client_name | VARCHAR2 | Yes | クライアント名 | NOT NULL、QA_RULESに存在すること |
| pi_target_scheme | VARCHAR2 | No | テスト対象スキーマ名 | デフォルト: USER |

### 入力データソース

- APIパラメータとして直接指定
- APEXリージョンプラグインからの呼び出し
- スケジューラジョブからの呼び出し
- utPLSQLテストからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_rules_t | コレクション | 全ルールの実行結果を結合したコレクション |

各要素（qa_rule_t）には以下が含まれる：
- qaru_id：ルールID
- scheme_name：検出オブジェクトのスキーマ
- object_name：検出オブジェクト名
- object_details：オブジェクト詳細
- qaru_error_message：エラーメッセージ

### 出力先

- 関数の戻り値としてqa_rules_t型を返却
- APEXリージョンプラグインに表示
- utPLSQLテスト結果として処理

## 処理フロー

### 処理シーケンス

```
1. パラメータバリデーション
   └─ クライアント名、対象スキーマのNULLチェック
2. ループ検出
   └─ f_check_for_loop関数で先行ルール依存関係の循環参照をチェック
3. 実行状態初期化
   └─ qa_running_rules_tにルール番号と先行ルールの組み合わせを格納
4. ルール番号一覧取得
   └─ tf_get_rule_numbers関数で先行ルール順序に従いルール番号を取得
5. ルールごとの実行ループ
   └─ 5.1 先行ルールの成功状態確認
       5.2 先行ルールがすべて成功なら実行
       5.3 tf_run_rule関数で個別ルール実行
       5.4 結果を集約（multiset union）
       5.5 実行状態を更新
6. 結果返却
   └─ 全ルールの検出オブジェクトを結合して返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|NG| C[例外発生 -20001]
    B -->|OK| D[ループ検出チェック]
    D -->|ループあり| E[NULL返却]
    D -->|OK| F[実行状態初期化]
    F --> G[ルール番号一覧取得]
    G --> H{次のルールあり?}
    H -->|No| I[結果返却]
    H -->|Yes| J{先行ルールすべて成功?}
    J -->|No| K[実行状態をNに更新]
    J -->|Yes| L[tf_run_rule実行]
    L --> M[結果を集約]
    M --> N{検出オブジェクトあり?}
    N -->|Yes| O[実行状態をNに更新]
    N -->|No| P[実行状態をYに更新]
    K --> H
    O --> H
    P --> H
    I --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須パラメータ | クライアント名、対象スキーマはすべて必須 | 関数呼び出し時 |
| BR-02 | ループ検出 | 先行ルール依存関係に循環参照があれば実行中止 | 全ルール実行開始時 |
| BR-03 | 先行ルール依存 | 先行ルールが失敗または未実行の場合、後続ルールは実行しない | 各ルール実行判断時 |
| BR-04 | 成功判定 | 検出オブジェクトが0件の場合に成功（Y）、1件以上で失敗（N） | ルール実行後 |
| BR-05 | アクティブルールのみ | qaru_is_active=1かつqaru_error_level<=4のルールのみ対象 | ルール番号取得時 |

### 計算ロジック

**実行可否判定ロジック**：
```
l_allowed_to_run = COUNT(先行ルールのうち、success_runがNULLまたはY以外のもの)
IF l_allowed_to_run = 0 THEN
    ルールを実行
ELSE
    実行をスキップ（success_run = 'N'）
END IF
```

**成功/失敗判定ロジック**：
```
l_success = CASE
    WHEN l_qa_rules.count = 0 THEN 'Y'
    ELSE 'N'
END
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 実行状態初期化 | QA_RULES | SELECT | ルール番号と先行ルールの組み合わせを取得 |
| ルール番号取得 | QA_RULES, qa_predecessor_order_v | SELECT | 先行ルール順序でルール番号を取得 |
| 個別ルール実行 | 各種テーブル | SELECT | tf_run_rule経由で動的SQL実行 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_rule_number, qaru_predecessor_ids, qaru_is_active | WHERE qaru_client_name = pi_qaru_client_name | 実行状態初期化 |

#### qa_predecessor_order_v

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_rule_number | JOIN with QA_RULES, ORDER BY step | ルール実行順序決定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | アプリケーションエラー | 必須パラメータがNULL | パラメータを正しく指定 |
| -1436 | ループ検出 | 先行ルール依存関係に循環参照 | ルール定義の依存関係を修正 |
| NO_DATA_FOUND | データなし | 指定クライアントにルールが存在しない | 正しいクライアント名を指定 |

### リトライ仕様

リトライは不要。エラー発生時はloggerにログを記録し、例外を再スローする。

## トランザクション仕様

- 参照のみの処理のためトランザクション管理は不要
- 個別ルール実行はtf_run_rule関数に委譲

## パフォーマンス要件

- 全ルール実行：ルール数と各SQLの複雑さに依存
- 目安：ルール数 * 数秒（大規模環境では数分）

## セキュリティ考慮事項

- authid current_userにより実行ユーザーの権限でのみオブジェクトにアクセス可能
- 個別ルール実行時にブラックリストスキーマチェックが行われる

## 備考

- 関数はqa_api_pkg.tf_run_rulesとして公開
- 先行ルール依存関係はqa_running_rules_t型でメモリ内追跡
- multiset unionでコレクションを結合

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、実行状態を追跡する型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_running_rule_t.sql | `src/plsql/typ/qa_running_rule_t.sql` | 実行中ルールの状態追跡用型（rule_number, predecessor, success_run, row_val） |
| 1-2 | qa_running_rules_t.sql | `src/plsql/typ/qa_running_rules_t.sql` | qa_running_rule_tのコレクション型 |
| 1-3 | qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | 検出結果のコレクション型 |

**読解のコツ**:
- qa_running_rule_tのsuccess_run属性は実行前NULL、成功後Y、失敗/未実行でN
- row_val属性は配列インデックスとして使用される

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | tf_run_rules関数の仕様と実装を確認 |

**主要処理フロー**:
1. **39-43行目**: tf_run_rules関数の仕様宣言（2つのパラメータ）
2. **154-275行目**: tf_run_rules関数の実装本体
3. **172-176行目**: パラメータのログ記録
4. **178-183行目**: 必須パラメータのNULLチェック
5. **186-191行目**: ループ検出チェック
6. **193-212行目**: 実行状態初期化（qa_running_rules_t構築）
7. **214行目**: tf_get_rule_numbers呼び出し
8. **216-260行目**: ルール実行ループ
9. **219-225行目**: 先行ルール成功状態のカウント
10. **228-258行目**: 実行可否判定と個別ルール実行

#### Step 3: 補助関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_check_for_loop, tf_get_rule_numbersの実装を確認 |

**主要処理フロー**:
- **493-531行目**: tf_get_rule_numbers - ルール番号一覧取得（qa_predecessor_order_vと結合）
- **899-960行目**: f_check_for_loop - ループ検出（ORA-1436例外をキャッチ）

#### Step 4: ビュー定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_predecessor_order_v.sql | `src/plsql/vw/qa_predecessor_order_v.sql` | 先行ルール順序を決定する階層クエリの構造 |

### プログラム呼び出し階層図

```
qa_api_pkg.tf_run_rules
    │
    ├─ qa_main_pkg.f_check_for_loop
    │      └─ 階層クエリ (CONNECT BY) でループ検出
    │
    ├─ SELECT FROM qa_rules (実行状態初期化)
    │      └─ qa_running_rules_t構築
    │
    ├─ qa_main_pkg.tf_get_rule_numbers
    │      └─ SELECT FROM qa_rules JOIN qa_predecessor_order_v
    │
    └─ ループ処理
           │
           ├─ SELECT FROM table(l_running_rules) (先行ルール状態確認)
           │
           ├─ qa_api_pkg.tf_run_rule (個別ルール実行)
           │      └─ (機能2参照)
           │
           └─ multiset union (結果集約)
```

### データフロー図

```
[入力]                     [処理]                              [出力]

pi_qaru_client_name ──▶ qa_api_pkg.tf_run_rules ──────────▶ qa_rules_t
pi_target_scheme           │                               (全検出オブジェクト)
                           │
                           ├─▶ ループ検出
                           │
                           ├─▶ 実行状態初期化 (qa_running_rules_t)
                           │
                           ├─▶ ルール番号取得 (qa_predecessor_order_v)
                           │
                           └─▶ ループ処理
                                    │
                                    ├─▶ 先行ルール状態確認
                                    │
                                    ├─▶ tf_run_rule (個別実行)
                                    │
                                    └─▶ 結果集約 (multiset union)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | PKG | 全ルール実行の公開API |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | ループ検出、ルール番号取得 |
| qa_running_rule_t.sql | `src/plsql/typ/qa_running_rule_t.sql` | TYPE | 実行中ルール状態型 |
| qa_running_rules_t.sql | `src/plsql/typ/qa_running_rules_t.sql` | TYPE | 実行中ルール状態コレクション型 |
| qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | TYPE | 検出結果コレクション型 |
| qa_predecessor_order_v.sql | `src/plsql/vw/qa_predecessor_order_v.sql` | VIEW | 先行ルール順序ビュー |
