# 機能設計書 30-テスト結果XMLダウンロード

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果XMLダウンロード機能の設計を記述したものである。QA_TEST_RESULTSテーブルに保存されているテスト結果をXML形式でダウンロードする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：実行されたutPLSQLテスト結果を外部に出力することで、テスト結果のバックアップ、他環境への移行、レポート生成ツールへの入力データとしての活用を可能にする。CI/CDパイプラインやテスト結果集約システムとの連携においても重要な役割を果たす。

**機能の利用シーン**：APEXアプリケーションの「Test Result Files」画面で使用される。ユーザーはテスト結果IDを指定し、ダウンロードボタンをクリックすることでテスト結果をXML形式でダウンロードする。

**主要な処理内容**：
1. テスト結果ID（qatr_id）を受け取る
2. qa_unit_tests_pkg.f_export_test_resultでXML CLOBを取得
3. QA_TEST_RESULTSからqatr_added_onを取得（ファイル名用）
4. HTTPレスポンスヘッダーを設定
5. XML CLOBをチャンク単位でHTTPレスポンスに出力
6. APEXエンジンを停止

**関連システム・外部連携**：HTP、OWA_UTILパッケージを使用してHTTPレスポンスを生成する。

**権限による制御**：本機能はDEFINER権限で実行されるため、パッケージ所有者の権限でデータベース操作が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Test Result Files | 補助機能 | APEXアプリからテスト結果をXML形式でダウンロード処理 |

## 機能種別

ファイルエクスポート / データ取得処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qatr_id | NUMBER | Yes | テスト結果ID | NOT NULL |

### 入力データソース

- APEXアプリケーションからの選択されたテスト結果ID
- QA_TEST_RESULTSテーブルのテスト結果XML

## 出力仕様

### 出力データ

本プロシージャは戻り値を持たない。HTTPレスポンスとしてXMLファイルを出力する。

### 出力ファイル形式

- ファイル名: `export_unit_test_results_{timestamp}.xml`
  - timestamp: qatr_added_onのYYYYMMDDHH24MI形式
- MIMEタイプ: application/xml
- エンコーディング: UTF-8

### 出力先

- HTTPレスポンス（ブラウザでダウンロード）

## 処理フロー

### 処理シーケンス

```
1. テスト結果XMLの取得
   └─ qa_unit_tests_pkg.f_export_test_resultを呼び出し
   └─ XML CLOBを取得

2. 追加日時の取得
   └─ QA_TEST_RESULTSからqatr_added_onを取得
   └─ ファイル名のタイムスタンプとして使用

3. HTTPレスポンスヘッダーの設定
   └─ HTP.initでHTTP出力を初期化
   └─ OWA_UTIL.mime_headerでMIMEタイプを設定
   └─ Content-Length、Content-Type、Cache-Control、Content-Dispositionを設定
   └─ OWA_UTIL.http_header_closeでヘッダーをクローズ

4. レスポンスボディの出力
   └─ XML CLOBをチャンク（3000バイト）単位でループ出力
   └─ HTP.prnで出力

5. APEXエンジンの停止
   └─ apex_application.stop_apex_engineを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[テスト結果XMLを取得]
    B --> C[追加日時を取得]
    C --> D[HTTPレスポンスヘッダー設定]
    D --> E[XML CLOBをチャンク出力]
    E --> F{全データ出力完了?}
    F -->|No| E
    F -->|Yes| G[APEXエンジン停止]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | ファイル名規則 | ファイル名は「export_unit_test_results_{timestamp}.xml」形式、タイムスタンプはqatr_added_onを使用 | 常に適用 |
| BR-30-02 | チャンク出力 | XML CLOBは3000バイト単位でチャンク出力される | 常に適用 |
| BR-30-03 | APEXエンジン停止 | ダウンロード完了後、APEXエンジンを停止して通常のページレンダリングを防止 | 常に適用 |

### 計算ロジック

- オフセット計算: `l_offset := l_offset + l_chunk` （l_chunk = 3000）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト結果XML取得 | QA_TEST_RESULTS | SELECT | 指定IDのXML CLOBを取得 |
| 追加日時取得 | QA_TEST_RESULTS | SELECT | 指定IDのqatr_added_onを取得 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qatr_xml_result | WHERE qatr_id = pi_qatr_id | f_export_test_result内で実行 |
| SELECT | qatr_added_on | WHERE qatr_id = pi_qatr_id | ファイル名用タイムスタンプ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | apex_application.e_stop_apex_engine | 正常終了時 | 例外を捕捉して処理を終了（正常動作） |
| - | OTHERS | その他のエラー発生時 | qa_logger_pkgでエラーログ記録後、例外を再スロー |

### リトライ仕様

リトライは行わない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- XMLファイルのサイズに応じてI/O負荷が発生する可能性がある
- チャンク出力により、メモリ効率的にHTTPレスポンスを生成

## セキュリティ考慮事項

- AUTHID DEFINERで実行されるため、パッケージ所有者の権限でデータベース操作が行われる
- テスト結果にはデータベース構造に関する情報が含まれる可能性があるため、エクスポートファイルの取り扱いに注意が必要

## 備考

- エクスポートされるXMLはutPLSQLが生成するJUnit形式
- ファイル名のタイムスタンプはテスト実行時の日時ではなく、QA_TEST_RESULTSに追加された日時

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エクスポート対象のテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | QA_TEST_RESULTSテーブルの構造、特にqatr_xml_result列とqatr_added_on列 |

**読解のコツ**: テーブル定義のコメントから各カラムの用途を理解できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_download_unit_test_xmlプロシージャの仕様 |

**主要処理フロー**:
1. **47行目**: プロシージャのシグネチャ定義
2. **248-295行目**: プロシージャの実装

#### Step 3: エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_export_test_resultの実装 |

**主要処理フロー**:
- **1460-1486行目**: f_export_test_resultがQA_TEST_RESULTSからXMLを取得

### プログラム呼び出し階層図

```
APEXアプリケーション (Test Result Files画面)
    │
    └─ qa_apex_app_pkg.p_download_unit_test_xml
           │
           ├─ qa_unit_tests_pkg.f_export_test_result
           │      │
           │      └─ SELECT FROM QA_TEST_RESULTS (qatr_xml_result)
           │
           ├─ SELECT FROM QA_TEST_RESULTS (qatr_added_on)
           │
           ├─ HTP.init / OWA_UTIL.mime_header (HTTPヘッダー)
           │
           ├─ LOOP: HTP.prn (チャンク出力)
           │
           └─ apex_application.stop_apex_engine
```

### データフロー図

```
[入力]                           [処理]                              [出力]

pi_qatr_id           ───▶ f_export_test_result ───▶ l_clob_xml
                           │
                           └─ QA_TEST_RESULTS → XML CLOB

pi_qatr_id           ───▶ SELECT qatr_added_on ───▶ l_added_on
                                                    (ファイル名用)

l_clob_xml           ───▶ HTTPレスポンス生成 ───▶ XMLファイルダウンロード
l_added_on                 │
                           ├─ ファイル名生成
                           ├─ ヘッダー設定
                           └─ チャンク出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | p_download_unit_test_xmlを含むメインパッケージ |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | f_export_test_result関数を提供 |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果XMLを格納するテーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録機能を提供 |
