# 機能設計書 31-ファセット検索コレクション生成

## 概要

本ドキュメントは、QUASTOにおけるAPEXダッシュボードのパフォーマンス向上を目的としたファセット検索用コレクション生成機能について記載する。

### 本機能の処理概要

**業務上の目的・背景**：APEXダッシュボードでは、テスト結果データをファセット検索（多面的な絞り込み検索）で表示する。大量のテスト結果データを毎回直接SQLで取得すると、パフォーマンスが著しく低下する。この機能は、検索データを事前にAPEXコレクションにキャッシュすることで、ダッシュボードの応答速度を大幅に改善する。

**機能の利用シーン**：ダッシュボードページの表示前処理として自動実行される。ページ読み込み時にコレクションを生成・更新することで、ファセット検索リージョンのデータ取得を高速化する。また、定期的なバッチ処理や手動のデータ更新後にも呼び出される可能性がある。

**主要な処理内容**：
1. 既存のコレクション（FACETED_SEARCH_DASHBOARD_DATA_P0001）が存在する場合は切り捨て（truncate）
2. get_faceted_search_dashboard_data関数を使用してテスト結果データを取得するSQLクエリを実行
3. 取得したデータをAPEXコレクションとして保存
4. エラー発生時はqa_logger_pkgを使用してログを記録し、例外を再スロー

**関連システム・外部連携**：Oracle APEXのapex_collection APIを使用してコレクションを管理する。また、get_faceted_search_dashboard_data関数を内部的に呼び出し、QA_TEST_RESULTS、QA_RULESテーブルのデータを取得する。

**権限による制御**：APEXセッションコンテキスト内でのみ実行可能。APEXアプリケーションにログインしたユーザーのセッション情報（APP_PAGE_ID等）が必要となる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 主画面 | ダッシュボードのファセット検索用コレクションを生成・更新 |

## 機能種別

データ連携 / キャッシュ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| （なし） | - | - | 本プロシージャはパラメータを受け取らない | - |

### 入力データソース

- APEXセッション変数（APP_PAGE_ID）を内部的に使用
- get_faceted_search_dashboard_data関数からの戻り値（qa_test_results_table_t型）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QATR_ID | NUMBER | テスト結果ID |
| QATR_DATE | DATE | テスト実行日時 |
| QATR_SCHEME_NAME | VARCHAR2(100) | スキーマ名 |
| QATR_CATEGORY | VARCHAR2(100) | ルールカテゴリ |
| QATR_RESULT | VARCHAR2(20) | テスト結果（SUCCESS/FAILURE/ERROR） |
| QARU_NAME | VARCHAR2(100) | ルール名 |
| QARU_LAYER | VARCHAR2(20) | レイヤー |
| QARU_ERROR_LEVEL | VARCHAR2(20) | エラーレベル |
| QARU_IS_ACTIVE | VARCHAR2(10) | アクティブフラグ |
| QARU_CLIENT_NAME | VARCHAR2(4000) | クライアント名 |
| QATR_PROGRAM_NAME | VARCHAR2(500) | プログラム名 |

### 出力先

APEXコレクション「FACETED_SEARCH_DASHBOARD_DATA_P0001」

## 処理フロー

### 処理シーケンス

```
1. プロシージャ呼び出し
   └─ p_fill_faceted_search_collectionが呼び出される
2. APEXコレクション生成
   └─ apex_collection.create_collection_from_queryを実行
      └─ 既存コレクションが存在する場合はp_truncate_if_exists => 'YES'で上書き
3. データ取得クエリ実行
   └─ get_faceted_search_dashboard_data関数を呼び出すSQLを実行
4. コレクションへのデータ格納
   └─ クエリ結果がAPEXコレクションに格納される
5. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[apex_collection.create_collection_from_query呼び出し]
    B --> C{既存コレクション存在?}
    C -->|Yes| D[既存コレクションをtruncate]
    C -->|No| E[新規コレクション作成]
    D --> F[get_faceted_search_dashboard_data実行]
    E --> F
    F --> G[クエリ結果をコレクションに格納]
    G --> H{エラー発生?}
    H -->|No| I[正常終了]
    H -->|Yes| J[qa_logger_pkg.p_qa_logでログ記録]
    J --> K[例外再スロー]
    K --> L[異常終了]
    I --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-01 | コレクション上書き | 既存のコレクションが存在する場合は、新しいデータで完全に置き換える | 常時 |
| BR-31-02 | APEXセッション依存 | APEXセッションコンテキスト内でのみ実行可能 | 常時 |
| BR-31-03 | コレクション名固定 | コレクション名は「FACETED_SEARCH_DASHBOARD_DATA_P0001」で固定 | 常時 |

### 計算ロジック

本機能に固有の計算ロジックはない。データはget_faceted_search_dashboard_data関数から取得したものをそのまま格納する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コレクション生成 | WWV_FLOW_COLLECTIONS（内部） | INSERT/DELETE | APEXコレクションへのデータ格納 |
| データ取得 | QA_TEST_RESULTS | SELECT | テスト結果の取得（間接） |
| データ取得 | QA_RULES | SELECT | ルール情報の取得（間接） |

### テーブル別操作詳細

#### APEXコレクション（FACETED_SEARCH_DASHBOARD_DATA_P0001）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | C001-C011 | テスト結果データの各カラム値 | 標準APEXコレクション形式 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APEXセッションエラー | APEXセッション外での実行 | APEXアプリケーション内から実行する |
| - | クエリ実行エラー | get_faceted_search_dashboard_data関数でエラー | ソースデータ（QA_TEST_RESULTS等）の整合性を確認 |
| - | 権限エラー | APEXコレクションへのアクセス権限不足 | APEXワークスペースの権限設定を確認 |

### リトライ仕様

本機能にリトライ仕様はない。エラー発生時は例外をログに記録した後、呼び出し元に例外を再スローする。

## トランザクション仕様

APEXコレクションの操作は自動コミットされる。ただし、DDLではなくセッション固有のメモリ領域への操作のため、明示的なCOMMIT/ROLLBACKは不要。

## パフォーマンス要件

- コレクション生成は数秒以内に完了すること
- 大量データ（数万件）の場合でも、ダッシュボード表示のボトルネックとならないこと
- p_truncate_if_exists => 'YES'により、既存データの削除と新規データの挿入を効率的に実行

## セキュリティ考慮事項

- APEXセッションコンテキスト内でのみ実行可能なため、認証済みユーザーのみがアクセス可能
- コレクションはセッション固有であり、他のユーザーのセッションからはアクセスできない
- 取得するデータはQUASTOのテスト結果であり、機密性の高いビジネスデータは含まない

## 備考

- コレクション名「FACETED_SEARCH_DASHBOARD_DATA_P0001」のP0001はページ番号を示唆している
- get_faceted_search_dashboard_data関数の詳細は機能No.26「ダッシュボードデータ取得」を参照

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コレクションに格納されるデータの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | コレクションに格納される1行分のデータ構造（11カラム）を確認 |
| 1-2 | qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | 行の集合を表すテーブル型の定義を確認 |

**読解のコツ**: PL/SQLのOBJECT型とTABLE OF型を理解していれば、パイプライン関数の戻り値構造を把握しやすい。

#### Step 2: エントリーポイントを理解する

処理の起点となるプロシージャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_fill_faceted_search_collectionプロシージャ（297-315行目） |

**主要処理フロー**:
1. **297-300行目**: プロシージャ定義とローカル変数宣言（c_unit, l_param_list）
2. **303-306行目**: apex_collection.create_collection_from_queryの呼び出し、コレクション名とSQLクエリの指定
3. **308-314行目**: 例外処理ブロック、エラー発生時のログ記録と例外再スロー

#### Step 3: 依存するデータ取得関数を理解する

コレクションに格納するデータを取得する関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | get_faceted_search_dashboard_data関数（59-115行目）のパイプライン関数実装 |

**主要処理フロー**:
- **80-85行目**: APEX_APPLICATION_PAGE_REGIONSからリージョンIDを取得
- **87-88行目**: apex_region.open_query_contextでクエリコンテキストを開く
- **90行目**: 取得対象カラムのインデックスを設定
- **92-105行目**: WHILEループでデータを1行ずつPIPE ROWで返却

#### Step 4: ロギング処理を理解する

エラー処理で使用されるロギング機能を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | p_qa_logプロシージャ（261-296行目）、tab_param型定義（18-25行目） |

### プログラム呼び出し階層図

```
p_fill_faceted_search_collection (qa_apex_app_pkg)
    │
    ├─ apex_collection.create_collection_from_query (APEX API)
    │      │
    │      └─ get_faceted_search_dashboard_data (qa_apex_app_pkg)
    │             │
    │             ├─ apex_region.open_query_context (APEX API)
    │             │
    │             └─ apex_exec.get_* (APEX API) - データ取得
    │
    └─ qa_logger_pkg.p_qa_log (エラー時のみ)
```

### データフロー図

```
[入力]                          [処理]                                [出力]

APEXセッション変数    ───▶ p_fill_faceted_search_collection ───▶ APEXコレクション
(APP_PAGE_ID)                      │                              (FACETED_SEARCH_DASHBOARD_DATA_P0001)
                                   ▼
                    apex_collection.create_collection_from_query
                                   │
                                   ▼
                    get_faceted_search_dashboard_data
                                   │
                                   ▼
                    QA_TEST_RESULTS + QA_RULES (間接参照)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | メイン処理パッケージ |
| qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | ソース | テスト結果行の型定義 |
| qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | ソース | テスト結果テーブルの型定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | ロギングパッケージ |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果テーブル定義 |
