# 機能設計書 32-パラメータログ

## 概要

本ドキュメントは、QUASTOにおけるプロシージャ/関数のパラメータをログに記録する機能について記載する。

### 本機能の処理概要

**業務上の目的・背景**：システム開発・運用において、障害発生時の原因特定やデバッグには、処理実行時のパラメータ値を確認することが不可欠である。本機能は、PL/SQLのプロシージャや関数の入力パラメータを標準化された形式でログパラメータリストに追加し、後続のログ出力処理で活用できるようにする。これにより、エラー発生時のコンテキスト情報を完全に保持し、トラブルシューティングの効率を向上させる。

**機能の利用シーン**：QUASTOの各パッケージ内のプロシージャ・関数の冒頭で、入力パラメータをログ用のパラメータリストに追加する際に使用される。特にエラー処理ブロック（EXCEPTION）で、qa_logger_pkg.p_qa_logを呼び出す前にパラメータ情報を設定するために利用される。

**主要な処理内容**：
1. 入力パラメータの名前と値のペアを受け取る
2. 各種データ型（VARCHAR2、NUMBER、DATE、TIMESTAMP、BOOLEAN等）に対応したオーバーロードプロシージャを提供
3. 非VARCHAR2型の値はtochar関数で文字列に変換
4. パラメータリスト（tab_param型）に名前・値ペアを追加
5. 最大14個のパラメータを一括で追加できるバルク追加版も提供

**関連システム・外部連携**：外部システムとの直接連携はないが、loggerフレームワーク（Oracle Logger）が有効な場合、最終的にそのフレームワークにパラメータが渡される。

**権限による制御**：本機能に特別な権限制御はない。パッケージを実行できるユーザーであれば使用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない内部処理機能 |

## 機能種別

ユーティリティ / ロギング支援

## 入力仕様

### 入力パラメータ

#### 単一パラメータ追加版

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_params | tab_param（IN OUT NOCOPY） | Yes | パラメータリスト | - |
| p_name | VARCHAR2 | Yes | パラメータ名 | 最大255文字 |
| p_val | VARCHAR2/NUMBER/DATE/TIMESTAMP/BOOLEAN | Yes | パラメータ値 | 最大4000文字（変換後） |

#### バルク追加版（最大14パラメータ）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_params | tab_param（IN OUT NOCOPY） | Yes | パラメータリスト | - |
| p_name_01 | VARCHAR2 | Yes | パラメータ1の名前 | 最大255文字 |
| p_val_01 | VARCHAR2 | Yes | パラメータ1の値 | 最大4000文字 |
| p_name_02〜p_name_14 | VARCHAR2 | No | パラメータ2〜14の名前 | 最大255文字 |
| p_val_02〜p_val_14 | VARCHAR2 | No | パラメータ2〜14の値 | 最大4000文字 |

### 入力データソース

呼び出し元プロシージャ/関数の引数として受け取った値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| p_params | tab_param | パラメータが追加されたリスト |

### 出力先

呼び出し元に返却（IN OUTパラメータ）

## 処理フロー

### 処理シーケンス（単一パラメータ追加版）

```
1. append_param呼び出し
   └─ p_params、p_name、p_valを受け取る
2. rec_param型ローカル変数を宣言
   └─ l_paramを初期化
3. パラメータ値の設定
   └─ l_param.name := p_name
   └─ l_param.val := p_val（または tochar(p_val)で変換）
4. リストへの追加
   └─ p_params(p_params.count + 1) := l_param
5. 処理完了
   └─ 呼び出し元にp_paramsを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{p_valの型は?}
    B -->|VARCHAR2| C[そのまま使用]
    B -->|NUMBER| D[tochar変換]
    B -->|DATE| E[tochar変換（gc_date_format）]
    B -->|TIMESTAMP| F[tochar変換（gc_timestamp_format）]
    B -->|BOOLEAN| G[tochar変換（TRUE/FALSE/null）]
    C --> H[rec_param構造体に設定]
    D --> H
    E --> H
    F --> H
    G --> H
    H --> I[p_paramsに追加]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | NOCOPY修飾子 | パラメータリストはNOCOPYで参照渡し、パフォーマンス最適化 | 常時 |
| BR-32-02 | インデックス付与 | 新規パラメータはcount+1の位置に追加 | 常時 |
| BR-32-03 | NULL許容 | p_valがNULLの場合もそのまま追加 | 常時 |
| BR-32-04 | 型変換フォーマット | DATE型はgc_date_format（DD-MON-YYYY HH24:MI:SS）で変換 | DATE型の場合 |

### 計算ロジック

なし（データ変換のみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本機能はデータベース操作を行わない |

### テーブル別操作詳細

本機能はメモリ上のPL/SQLコレクションを操作するのみで、データベーステーブルへの直接操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | - | 本機能内で明示的なエラー処理は行わない。呼び出し元で例外処理を行う |

### リトライ仕様

本機能にリトライ仕様はない。

## トランザクション仕様

本機能はトランザクションに影響を与えない（メモリ操作のみ）。

## パフォーマンス要件

- NOCOPYヒントにより、大きなコレクションでも参照渡しで高速に処理
- tochar関数は軽量な文字列変換のみを行う
- 1回の呼び出しあたり数マイクロ秒以内で完了すること

## セキュリティ考慮事項

- パラメータ値に機密情報（パスワード等）が含まれる可能性がある
- ログに機密情報を記録しないよう、呼び出し側で適切にマスキングすることを推奨
- パッケージはAUTHID DEFINERで実行されるため、パッケージ所有者の権限で動作

## 備考

- Oracle Loggerフレームワーク（gc_logger_flag = 1）が有効な場合、最終的にlogger.append_paramに渡される
- バルク追加版では、p_name_02以降がNULLでも内部でappend_paramが呼ばれるが、NULLのパラメータもリストに追加される点に注意

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パラメータを保持する型定義を理解することが最初の一歩。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | rec_param型（18-20行目）：name/valの2フィールド構造 |
| 1-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tab_param型（25行目）：rec_paramのINDEX BY BINARY_INTEGERテーブル |

**読解のコツ**: PL/SQLのレコード型とコレクション型（INDEX BY表）の基礎知識があると理解しやすい。

#### Step 2: 定数とデフォルト値を理解する

日時フォーマット等の定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | gc_empty_tab_param（27行目）：空のパラメータテーブル |
| 2-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | gc_date_format等（28-30行目）：日時変換フォーマット定数 |

#### Step 3: 単一パラメータ追加版を理解する

基本となる単一パラメータ追加プロシージャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（VARCHAR2版）仕様部（53-58行目） |
| 3-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（VARCHAR2版）本体（336-347行目） |

**主要処理フロー**:
- **342行目**: l_param.name := p_name でパラメータ名を設定
- **343行目**: l_param.val := p_val でパラメータ値を設定
- **346行目**: p_params(p_params.count + 1) := l_param でリストに追加

#### Step 4: オーバーロード版を理解する

各データ型に対応したオーバーロードプロシージャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（NUMBER版）本体（428-439行目） |
| 4-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（DATE版）本体（441-452行目） |
| 4-3 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（TIMESTAMP版）本体（454-465行目） |
| 4-4 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（BOOLEAN版）本体（493-504行目） |

**読解のコツ**: 各オーバーロード版は、tochar関数で文字列に変換してからVARCHAR2版を呼び出すパターン。

#### Step 5: バルク追加版を理解する

14パラメータ一括追加版を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（バルク版）仕様部（92-123行目） |
| 5-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（バルク版）本体（350-426行目） |

**主要処理フロー**:
- **384-425行目**: 各パラメータペアに対してappend_param（単一版）を呼び出し

### プログラム呼び出し階層図

```
append_param (バルク版: p_name_01〜p_name_14)
    │
    └─ append_param (単一VARCHAR2版) × 14回
           │
           └─ p_params(p_params.count + 1) := l_param

append_param (NUMBER/DATE/TIMESTAMP/BOOLEAN版)
    │
    ├─ tochar (型変換)
    │
    └─ append_param (単一VARCHAR2版)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

p_name (パラメータ名)  ───▶ append_param ───▶ p_params (更新済みリスト)
       +                        │
p_val (パラメータ値)            │
                                ▼
                    ┌─────────────────────┐
                    │ 1. rec_paramに設定   │
                    │ 2. リストに追加       │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | パラメータログ機能を含むロギングパッケージ |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_logger_flag定数の定義元 |
