# 機能設計書 33-エラーログ

## 概要

本ドキュメントは、QUASTOにおけるエラー情報をloggerフレームワークに記録する機能について記載する。

### 本機能の処理概要

**業務上の目的・背景**：システム運用において、エラー発生時の情報を確実に記録し、後から参照できることは非常に重要である。本機能は、QUASTOの全パッケージで発生するエラーや重要なイベントを、Oracle Loggerフレームワーク（またはDBMS_OUTPUT）に統一されたフォーマットで記録する。これにより、障害調査やシステム監視が容易になり、運用品質の向上に寄与する。

**機能の利用シーン**：QUASTOの各パッケージ内の例外処理ブロック（EXCEPTION）でエラーを記録する際に使用される。また、重要な処理の開始・終了時のトレースログとしても活用可能。エラー発生時のSQLERRM、実行中のプロシージャ/関数名（スコープ）、追加情報、パラメータリストを一元的に記録できる。

**主要な処理内容**：
1. エラーメッセージテキスト（p_text）、スコープ（p_scope）、追加情報（p_extra）、パラメータリスト（p_params）を受け取る
2. gc_logger_flag定数の値を確認し、Loggerフレームワークの有効/無効を判定
3. Loggerが有効（gc_logger_flag = 1）の場合、パラメータをLogger形式に変換
4. DBMS_OUTPUTでパラメータ情報を出力（デバッグ用）
5. logger.logプロシージャを呼び出してログを記録

**関連システム・外部連携**：Oracle Loggerフレームワーク（オープンソースのPL/SQLロギングライブラリ）と連携する。Loggerがインストールされていない環境では、条件付きコンパイルにより処理がスキップされる。

**権限による制御**：本機能に特別な権限制御はない。パッケージを実行できるユーザーであれば使用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない内部処理機能 |

## 機能種別

ユーティリティ / ロギング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_text | VARCHAR2 | Yes | ログメッセージテキスト | - |
| p_scope | VARCHAR2 | No | 実行中のプロシージャ/関数名（$$plsql_unit等） | デフォルトNULL |
| p_extra | CLOB | No | 追加情報（SQLERRM等） | デフォルトNULL |
| p_params | tab_param | No | パラメータリスト | デフォルトgc_empty_tab_param |

### 入力データソース

呼び出し元の例外処理ブロックで収集したエラー情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | - | 戻り値なし（プロシージャ） |

### 出力先

- Oracle Loggerフレームワーク（LOGGER_LOGSテーブル等）
- DBMS_OUTPUT（デバッグ用）

## 処理フロー

### 処理シーケンス

```
1. p_qa_log呼び出し
   └─ p_text、p_scope、p_extra、p_paramsを受け取る
2. Loggerフラグ確認
   └─ qa_constant_pkg.gc_logger_flag = 1 かを条件付きコンパイルで確認
3. パラメータ変換（Logger有効時）
   └─ qa_logger_pkg.tab_param → logger.tab_param に変換
4. パラメータ出力（デバッグ用）
   └─ 各パラメータをDBMS_OUTPUT.PUT_LINEで出力
5. Logger呼び出し
   └─ logger.logプロシージャを実行
6. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{gc_logger_flag = 1?}
    B -->|No| C[何もしない（null）]
    B -->|Yes| D[logger.tab_param変数を初期化]
    D --> E{p_params.count != null?}
    E -->|Yes| F[パラメータループ開始]
    E -->|No| G[logger.log呼び出し]
    F --> H[DBMS_OUTPUT.PUT_LINEでデバッグ出力]
    H --> I[logger.append_paramでパラメータ追加]
    I --> J{次のパラメータあり?}
    J -->|Yes| F
    J -->|No| G
    G --> K[終了]
    C --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | 条件付きコンパイル | gc_logger_flag = 1の場合のみLogger連携を実行 | 常時 |
| BR-33-02 | パラメータ変換 | qa_logger_pkg.tab_param形式をlogger.tab_param形式に変換 | Logger有効時 |
| BR-33-03 | NULLパラメータ処理 | p_params(i).valがNULLの場合は空文字に変換 | Logger有効時 |
| BR-33-04 | デフォルト値 | p_scope、p_extra、p_paramsはすべてオプション | 常時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ログ記録 | LOGGER_LOGS（Logger使用時） | INSERT | Loggerフレームワークによるログ挿入 |

### テーブル別操作詳細

#### LOGGER_LOGS（Oracle Loggerフレームワーク管理）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | TEXT | p_text | ログメッセージ |
| INSERT | SCOPE | p_scope | プロシージャ/関数名 |
| INSERT | EXTRA | p_extra | 追加情報（SQLERRM等） |

※ 実際のカラム構成はOracle Loggerのバージョンによる

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | - | 本機能内で明示的なエラー処理は行わない |

### リトライ仕様

本機能にリトライ仕様はない。ログ記録自体が失敗した場合は、呼び出し元の例外処理に委ねる。

## トランザクション仕様

Oracle Loggerは自律型トランザクション（PRAGMA AUTONOMOUS_TRANSACTION）を使用するため、呼び出し元のトランザクションに影響を与えない。ログは即座にコミットされる。

## パフォーマンス要件

- ログ記録は数ミリ秒以内に完了すること
- 大量のパラメータ（最大14個）でもパフォーマンスへの影響を最小限に抑える
- 条件付きコンパイルにより、Logger未使用時はオーバーヘッドなし

## セキュリティ考慮事項

- ログに機密情報（パスワード、個人情報等）が記録されないよう、呼び出し側で配慮が必要
- LOGGER_LOGSテーブルへのアクセス権限は適切に制限すること
- パッケージはAUTHID DEFINERで実行されるため、パッケージ所有者の権限で動作

## 備考

- Oracle Loggerは条件付きコンパイル（$IF ... $END）により、インストールされていない環境でもコンパイルエラーにならない
- gc_logger_flag = 0の場合、p_qa_logは何も実行しない（null文のみ）
- DBMS_OUTPUT.PUT_LINEによるデバッグ出力は、Logger有効時のみ実行される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数と型定義を理解する

ロギング機能の基盤となる定数と型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | gc_logger_flag定数の定義（46行目） |
| 1-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tab_param型、gc_empty_tab_param定数（18-27行目） |

**読解のコツ**: PL/SQLの条件付きコンパイル（$IF ... $END）を理解していると、Logger連携のON/OFF制御が分かりやすい。

#### Step 2: エントリーポイントを理解する

メインのログ記録プロシージャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | p_qa_log仕様部（39-45行目） |
| 2-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | p_qa_log本体（261-296行目） |

**主要処理フロー**:
- **268-271行目**: 条件付きコンパイル開始、Logger有効時のローカル変数宣言
- **275-276行目**: gc_logger_flag = 1 の条件付きコンパイルブロック開始
- **277-288行目**: パラメータループでlogger.append_paramを呼び出し
- **289-292行目**: logger.logプロシージャ呼び出し
- **293-295行目**: Logger無効時は null 文のみ

#### Step 3: 条件付きコンパイルの仕組みを理解する

PL/SQLの条件付きコンパイルがどのように機能するかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | $IF qa_constant_pkg.gc_logger_flag = 1 $THEN ... $ELSE ... $END構文（268-296行目） |

**読解のコツ**:
- `$IF` ～ `$END` はコンパイル時に評価される
- gc_logger_flag = 0 の場合、$IF ～ $ELSE 間のコードはコンパイルされない
- これにより、Oracle Loggerがインストールされていない環境でもコンパイルが通る

#### Step 4: 呼び出し元のパターンを理解する

実際の使用例を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_json内のp_qa_log呼び出し（156-159行目） |
| 4-2 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | f_get_table_as_string内のp_qa_log呼び出し（144-147行目） |

**典型的な使用パターン**:
```sql
exception
  when others then
    qa_logger_pkg.p_qa_log(p_text   => 'エラーメッセージ'
                          ,p_scope  => c_unit
                          ,p_extra  => sqlerrm
                          ,p_params => l_param_list);
    raise;
```

### プログラム呼び出し階層図

```
p_qa_log (qa_logger_pkg)
    │
    ├─ [gc_logger_flag = 1 の場合]
    │      │
    │      ├─ dbms_output.put_line (パラメータデバッグ出力)
    │      │
    │      ├─ logger.append_param (パラメータ追加) × n回
    │      │
    │      └─ logger.log (ログ記録)
    │             │
    │             └─ LOGGER_LOGSテーブルへINSERT
    │
    └─ [gc_logger_flag = 0 の場合]
           │
           └─ null (何もしない)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

p_text (メッセージ)    ───▶                              ───▶ LOGGER_LOGSテーブル
p_scope (スコープ)     ───▶    p_qa_log                  ───▶ DBMS_OUTPUT
p_extra (追加情報)     ───▶         │
p_params (パラメータ)  ───▶         ▼
                            ┌─────────────────────┐
                            │ 1. Logger有効判定    │
                            │ 2. パラメータ変換    │
                            │ 3. logger.log呼出   │
                            └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ機能を含むロギングパッケージ |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | gc_logger_flag定数の定義元 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | 使用例を含むパッケージ |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | 使用例を含むパッケージ |
