# 機能設計書 34-型変換

## 概要

本ドキュメントは、QUASTOにおける各種データ型をログ用VARCHAR2に変換するtochar関数群について記載する。

### 本機能の処理概要

**業務上の目的・背景**：ロギング処理において、パラメータ値を文字列として記録する必要がある。PL/SQLの様々なデータ型（NUMBER、DATE、TIMESTAMP、BOOLEAN等）を統一されたフォーマットでVARCHAR2に変換することで、ログの可読性と一貫性を確保する。標準のTO_CHAR関数は型ごとにフォーマットが異なるが、本機能は事前定義されたフォーマット定数を使用して統一的な変換を提供する。

**機能の利用シーン**：qa_logger_pkg.append_paramプロシージャの各オーバーロード版で、非VARCHAR2型のパラメータ値を文字列に変換する際に使用される。また、ログ出力以外の文脈でも、一貫したフォーマットでデータ型を文字列化したい場合に利用可能。

**主要な処理内容**：
1. NUMBER型：TO_CHAR(p_val)でデフォルト変換
2. DATE型：gc_date_format（DD-MON-YYYY HH24:MI:SS）でフォーマット
3. TIMESTAMP型：gc_timestamp_format（DD-MON-YYYY HH24:MI:SS:FF）でフォーマット
4. TIMESTAMP WITH TIME ZONE型：gc_timestamp_tz_format（DD-MON-YYYY HH24:MI:SS:FF TZR）でフォーマット
5. TIMESTAMP WITH LOCAL TIME ZONE型：gc_timestamp_tz_format（DD-MON-YYYY HH24:MI:SS:FF TZR）でフォーマット
6. BOOLEAN型：TRUE/FALSE/null（NULL値の場合）の文字列に変換

**関連システム・外部連携**：外部システムとの直接連携はない。PL/SQL標準のTO_CHAR関数を内部で使用する。

**権限による制御**：本機能に特別な権限制御はない。パッケージを実行できるユーザーであれば使用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない内部処理機能 |

## 機能種別

ユーティリティ / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_val | NUMBER | Yes | 数値型の入力値 | - |
| p_val | DATE | Yes | 日付型の入力値 | - |
| p_val | TIMESTAMP | Yes | タイムスタンプ型の入力値 | - |
| p_val | TIMESTAMP WITH TIME ZONE | Yes | タイムゾーン付きタイムスタンプ型 | - |
| p_val | TIMESTAMP WITH LOCAL TIME ZONE | Yes | ローカルタイムゾーン付きタイムスタンプ型 | - |
| p_val | BOOLEAN | Yes | ブール型の入力値 | - |

※ 各型に対応したオーバーロード関数が存在する

### 入力データソース

呼び出し元（主にappend_paramプロシージャ）からの引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | VARCHAR2 | 変換された文字列 |

### 出力先

呼び出し元に返却（関数の戻り値）

## 処理フロー

### 処理シーケンス

```
1. tochar関数呼び出し
   └─ p_valを受け取る（型に応じたオーバーロードが選択される）
2. 型判定（コンパイル時）
   └─ PL/SQLのオーバーロード解決により適切な関数が選択
3. 変換処理
   └─ TO_CHAR関数またはCASE式で文字列に変換
4. 戻り値返却
   └─ VARCHAR2型の結果を返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始: tochar呼び出し] --> B{入力型は?}
    B -->|NUMBER| C[TO_CHAR p_val]
    B -->|DATE| D[TO_CHAR p_val, gc_date_format]
    B -->|TIMESTAMP| E[TO_CHAR p_val, gc_timestamp_format]
    B -->|TIMESTAMP WITH TZ| F[TO_CHAR p_val, gc_timestamp_tz_format]
    B -->|TIMESTAMP WITH LOCAL TZ| G[TO_CHAR p_val, gc_timestamp_tz_format]
    B -->|BOOLEAN| H{p_valの値}
    H -->|TRUE| I[文字列 TRUE]
    H -->|FALSE| J[文字列 FALSE]
    H -->|NULL| K[NULL]
    C --> L[VARCHAR2を返却]
    D --> L
    E --> L
    F --> L
    G --> L
    I --> L
    J --> L
    K --> L
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | 日付フォーマット | gc_date_format = 'DD-MON-YYYY HH24:MI:SS' | DATE型 |
| BR-34-02 | タイムスタンプフォーマット | gc_timestamp_format = gc_date_format + ':FF'（ミリ秒含む） | TIMESTAMP型 |
| BR-34-03 | タイムゾーン付きフォーマット | gc_timestamp_tz_format = gc_timestamp_format + ' TZR'（タイムゾーン含む） | TIMESTAMP WITH (LOCAL) TIME ZONE型 |
| BR-34-04 | ブール変換 | TRUE→'TRUE'、FALSE→'FALSE'、NULL→NULL | BOOLEAN型 |
| BR-34-05 | NULL透過 | 入力がNULLの場合、出力もNULL | 全型 |

### 計算ロジック

フォーマット定数の構成：
- `gc_date_format = 'DD-MON-YYYY HH24:MI:SS'`
- `gc_timestamp_format = gc_date_format || ':FF'`（実質: 'DD-MON-YYYY HH24:MI:SS:FF'）
- `gc_timestamp_tz_format = gc_timestamp_format || ' TZR'`（実質: 'DD-MON-YYYY HH24:MI:SS:FF TZR'）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本機能はデータベース操作を行わない |

### テーブル別操作詳細

本機能はメモリ上の変換処理のみで、データベーステーブルへの直接操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | - | 本機能内で明示的なエラー処理は行わない |

### リトライ仕様

本機能にリトライ仕様はない。

## トランザクション仕様

本機能はトランザクションに影響を与えない（純粋な変換処理）。

## パフォーマンス要件

- 1回の変換処理は数マイクロ秒以内で完了すること
- TO_CHAR関数は軽量な組み込み関数であり、パフォーマンス上の懸念はない
- BOOLEAN型のCASE式も非常に高速

## セキュリティ考慮事項

- 入力値をそのまま文字列に変換するのみで、セキュリティ上の特別な考慮は不要
- パッケージはAUTHID DEFINERで実行されるため、パッケージ所有者の権限で動作

## 備考

- TIMESTAMP WITH LOCAL TIME ZONEとTIMESTAMP WITH TIME ZONEは同じフォーマット（gc_timestamp_tz_format）を使用
- BOOLEANのNULL値はNULLのまま返却される（空文字ではない）
- NUMBERのフォーマットはOracleのデフォルト変換に依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: フォーマット定数を理解する

変換に使用されるフォーマット定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | gc_date_format定数（28行目） |
| 1-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | gc_timestamp_format定数（29行目）：gc_date_format || ':FF' |
| 1-3 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | gc_timestamp_tz_format定数（30行目）：gc_timestamp_format || ' TZR' |

**読解のコツ**: 定数が連結（||）で構成されている点に注目。フォーマットの継承関係を理解する。

#### Step 2: 各オーバーロード関数の仕様を理解する

関数シグネチャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（NUMBER版）仕様部（208-210行目） |
| 2-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（DATE版）仕様部（217-219行目） |
| 2-3 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP版）仕様部（226-228行目） |
| 2-4 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP WITH TZ版）仕様部（235-237行目） |
| 2-5 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP WITH LOCAL TZ版）仕様部（244-246行目） |
| 2-6 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（BOOLEAN版）仕様部（253-255行目） |

#### Step 3: 各オーバーロード関数の実装を理解する

実装の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（NUMBER版）本体（299-302行目） |
| 3-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（DATE版）本体（304-308行目） |
| 3-3 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP版）本体（310-314行目） |
| 3-4 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP WITH TZ版）本体（316-320行目） |
| 3-5 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（TIMESTAMP WITH LOCAL TZ版）本体（322-326行目） |
| 3-6 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | tochar（BOOLEAN版）本体（329-332行目） |

**主要処理フロー**:
- **299-302行目**: NUMBER版 - `return to_char(p_val);`
- **304-308行目**: DATE版 - `return to_char(p_val, gc_date_format);`
- **310-314行目**: TIMESTAMP版 - `return to_char(p_val, gc_timestamp_format);`
- **316-320行目**: TIMESTAMP WITH TZ版 - `return to_char(p_val, gc_timestamp_tz_format);`
- **322-326行目**: TIMESTAMP WITH LOCAL TZ版 - `return to_char(p_val, gc_timestamp_tz_format);`
- **329-332行目**: BOOLEAN版 - CASE式で'TRUE'/'FALSE'/nullを返却

#### Step 4: 呼び出し元のパターンを理解する

append_paramからの呼び出しを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（NUMBER版）でのtochar呼び出し（438行目） |
| 4-2 | qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | append_param（DATE版）でのtochar呼び出し（451行目） |

### プログラム呼び出し階層図

```
append_param (NUMBER版)
    │
    └─ tochar (NUMBER版)
           │
           └─ TO_CHAR (Oracle組み込み関数)

append_param (DATE版)
    │
    └─ tochar (DATE版)
           │
           └─ TO_CHAR (Oracle組み込み関数, gc_date_format)

append_param (BOOLEAN版)
    │
    └─ tochar (BOOLEAN版)
           │
           └─ CASE式
```

### データフロー図

```
[入力]                      [処理]                           [出力]

p_val (NUMBER)         ───▶ tochar ───▶ TO_CHAR     ───▶ VARCHAR2
p_val (DATE)           ───▶ tochar ───▶ TO_CHAR     ───▶ VARCHAR2
p_val (TIMESTAMP)      ───▶ tochar ───▶ TO_CHAR     ───▶ VARCHAR2
p_val (TIMESTAMP+TZ)   ───▶ tochar ───▶ TO_CHAR     ───▶ VARCHAR2
p_val (BOOLEAN)        ───▶ tochar ───▶ CASE式      ───▶ VARCHAR2
                                   │
                                   ▼
                      フォーマット定数適用
                      (gc_date_format等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | tochar関数群を含むロギングパッケージ |
