# 機能設計書 4-ルール有効無効制御

## 概要

本ドキュメントは、QUASTOシステムにおけるルール有効/無効制御機能の設計仕様を記述する。

### 本機能の処理概要

ルール有効/無効制御機能は、QA_RULESテーブルのqaru_is_active列を使用してルールのアクティブ状態を制御し、ルール実行対象からの除外を可能にする機能である。qa_main_pkg.f_is_rule_active関数により有効性の確認ができ、APEX画面からはYes/Noの選択で簡単に切り替えられる。

**業務上の目的・背景**：品質ルールの中には一時的に無効化したいもの、特定の期間のみ有効にしたいものが存在する。また、新規ルール開発中にテスト段階では無効にしておき、完成後に有効化するといった運用も必要である。この機能により、ルール定義を削除することなく実行対象から除外/復帰させることができる。

**機能の利用シーン**：
- 新規ルール開発中にテストのために一時的に無効化する場合
- 特定の品質基準を一時的に緩和する必要がある場合
- 廃止予定のルールを段階的に無効化する場合
- 誤検知が多いルールを調査のために一時停止する場合

**主要な処理内容**：
1. qaru_is_active列の値（0=無効、1=有効）でルールの実行可否を制御
2. f_is_rule_active関数でルールの有効性をプログラムから確認
3. APEX Add/Edit Rule画面でYes/Noの選択により有効/無効を切り替え
4. ルール一覧画面でアクティブ状態を一覧表示
5. 全ルール実行時（tf_get_rule_numbers）にqaru_is_active=1のルールのみ取得

**関連システム・外部連携**：APEX画面のフォームコントロールと連携し、ラジオボタンまたはスイッチでの切り替えを提供。

**権限による制御**：ルールの有効/無効切り替えはAPEXの管理権限を持つユーザーのみ実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Rules | API連携 | ルールのアクティブ状態を表示 |
| 8 | Add/Edit Rule | 補助機能 | ルールのアクティブ状態をYes/Noで設定 |

## 機能種別

データ更新 / 状態制御

## 入力仕様

### 入力パラメータ

#### f_is_rule_active関数

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2 | Yes | ルール番号 | NOT NULL |
| pi_qaru_client_name | VARCHAR2 | Yes | クライアント名 | NOT NULL |

#### qaru_is_active列

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| qaru_is_active | NUMBER | Yes | 有効フラグ | 0=無効、1=有効（デフォルト1） |

### 入力データソース

- APEX Add/Edit Rule画面からのフォーム入力（Yes/No選択）
- JSONインポート時のis_activeフィールド
- 直接のDML操作

## 出力仕様

### 出力データ

#### f_is_rule_active関数

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | BOOLEAN | TRUE=有効、FALSE=無効 |

### 出力先

- 関数の戻り値（BOOLEAN）
- APEX画面での表示（Yes/No）

## 処理フロー

### 処理シーケンス

```
1. ルール有効性確認（f_is_rule_active）
   └─ QA_RULESテーブルからqaru_is_activeを取得
2. 有効性判定
   └─ qaru_is_active = 0 の場合FALSE、それ以外はTRUE
3. 結果返却
   └─ BOOLEAN値を返却

※ 有効/無効の切り替えはAPEXフォームからのUPDATE
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータログ記録]
    B --> C[QA_RULESからqaru_is_active取得]
    C --> D{qaru_is_active = 0?}
    D -->|Yes| E[FALSE返却]
    D -->|No| F[TRUE返却]
    E --> G[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルト有効 | 新規ルール作成時はデフォルトで有効（qaru_is_active=1） | ルール挿入時 |
| BR-02 | 無効ルール除外 | qaru_is_active=0のルールはtf_get_rule_numbersで取得されない | 全ルール実行時 |
| BR-03 | 単一ルール実行チェック | tf_run_rule実行時にf_is_rule_activeで有効性を確認 | 単一ルール実行時 |
| BR-04 | 無効ルール実行エラー | 無効なルールを直接実行しようとするとエラー | 単一ルール実行時 |

### 計算ロジック

**有効性判定ロジック**：
```sql
IF l_qaru_is_active = 0 THEN
    RETURN FALSE;
ELSE
    RETURN TRUE;
END IF;
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 有効性確認 | QA_RULES | SELECT | qaru_is_active値を取得 |
| 有効/無効切替 | QA_RULES | UPDATE | qaru_is_active値を更新 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_is_active | WHERE qaru_rule_number = pi_qaru_rule_number AND qaru_client_name = pi_qaru_client_name | f_is_rule_active |
| UPDATE | qaru_is_active | 0または1 | APEX画面から更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | アプリケーションエラー | 無効なルールを実行しようとした | ルールを有効化してから実行 |
| OTHERS | データベースエラー | SELECT時のエラー | ログに記録して再スロー |

### リトライ仕様

リトライは不要。

## トランザクション仕様

- 有効/無効切り替えは即時コミット（APEX標準動作）
- 参照のみの処理（f_is_rule_active）はトランザクション管理不要

## パフォーマンス要件

- 有効性確認（f_is_rule_active）：数ミリ秒以内

## セキュリティ考慮事項

- 有効/無効の切り替えはAPEX管理権限を持つユーザーのみ
- 監査目的でqaru_updated_on, qaru_updated_by列が自動更新される

## 備考

- qaru_is_activeのデフォルト値は1（有効）
- DDL定義: `qaru_is_active NUMBER default 1 not null`

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、qaru_is_active列の定義と意味を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | qaru_is_active列の定義（16行目）とコメント（51行目）を確認 |

**読解のコツ**:
- `qaru_is_active NUMBER default 1 not null` - デフォルト1（有効）、NOT NULL制約
- コメント: `is rule active=1 or inactive=0`

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_is_rule_active関数の仕様と実装を確認 |

**主要処理フロー**:
1. **46-50行目**: f_is_rule_active関数の仕様宣言
2. **290-326行目**: f_is_rule_active関数の実装本体
3. **301-305行目**: パラメータのログ記録
4. **307-311行目**: QA_RULESからqaru_is_active値を取得
5. **313-318行目**: 0ならFALSE、それ以外はTRUEを返却

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | tf_run_ruleでの有効性チェック呼び出しを確認 |
| 3-2 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | tf_get_rule_numbersでのqaru_is_active=1フィルタを確認 |

**主要処理フロー**:
- **qa_api_pkg.sql 85-91行目**: tf_run_rule内でf_is_rule_activeを呼び出し、FALSEなら例外発生
- **qa_main_pkg.sql 512行目**: tf_get_rule_numbersでqaru_is_active=1のルールのみ取得

### プログラム呼び出し階層図

```
APEX画面 (Add/Edit Rule)
    │
    └─ UPDATE qa_rules SET qaru_is_active = ...

qa_api_pkg.tf_run_rule
    │
    └─ qa_main_pkg.f_is_rule_active
           └─ SELECT qaru_is_active FROM qa_rules

qa_main_pkg.tf_get_rule_numbers
    │
    └─ SELECT ... WHERE qaru_is_active = 1
```

### データフロー図

```
[入力]                     [処理]                              [出力]

pi_qaru_rule_number ──▶ qa_main_pkg.f_is_rule_active ──────▶ BOOLEAN
pi_qaru_client_name        │                               (TRUE/FALSE)
                           │
                           └─▶ SELECT qaru_is_active FROM qa_rules
                                    │
                                    └─▶ 0: FALSE, 1: TRUE

APEX画面入力 ───────────▶ UPDATE qa_rules ──────────────────▶ qaru_is_active更新
(Yes/No選択)                SET qaru_is_active = 0/1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | qaru_is_active列の定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | f_is_rule_active関数、tf_get_rule_numbers関数 |
| qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | PKG | tf_run_ruleでの有効性チェック呼び出し |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | PKG | パラメータログ記録 |
