# 機能設計書 40-定数値取得

## 概要

本ドキュメントは、QUASTOにおけるqa_constant_pkgの定数値を動的に取得する機能について記載する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOでは、アプリケーション全体で使用される定数（バージョン番号、フラグ値、名前定数等）をqa_constant_pkgパッケージで一元管理している。しかし、PL/SQLのパッケージ定数は動的に参照できないため、定数名を文字列として指定して値を取得する機能が必要となる。本機能は、定数名を入力として受け取り、対応する定数値を返却するAPIを提供する。これにより、設定画面や管理機能から定数値を動的に参照可能になる。

**機能の利用シーン**：APEXアプリケーションから設定値を表示する場合や、外部システムとの連携でQUASTO設定を動的に取得する場合に使用される。また、デバッグ時に現在の設定値を確認する際にも活用可能。

**主要な処理内容**：
1. 定数名（文字列）を受け取る
2. CASE式で定数名をマッチング
3. 対応するqa_constant_pkgの定数値を返却
4. 定数名が存在しない場合はカスタム例外を発生

**関連システム・外部連携**：qa_constant_pkgパッケージで定義された定数を参照する。APEXアプリケーションや外部システムから呼び出される可能性がある。

**権限による制御**：本機能に特別な権限制御はない。パッケージを実行できるユーザーであれば使用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない内部処理機能 |

## 機能種別

ユーティリティ / 設定参照

## 入力仕様

### 入力パラメータ

#### VARCHAR2版（f_get_constant_string_value）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_constant_name | VARCHAR2 | Yes | 取得する定数の名前 | 存在しない定数名は例外 |

#### NUMBER版（f_get_constant_number_value）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_constant_name | VARCHAR2 | Yes | 取得する定数の名前 | 存在しない定数名は例外 |

### 入力データソース

呼び出し元からの引数（定数名を指定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値（VARCHAR2版） | VARCHAR2 | 文字列型の定数値 |
| 戻り値（NUMBER版） | NUMBER | 数値型の定数値 |

### 出力先

呼び出し元に返却（関数の戻り値）

## 処理フロー

### 処理シーケンス

```
1. f_get_constant_*_value呼び出し
   └─ pi_constant_nameを受け取る
2. パラメータログ記録
   └─ qa_logger_pkg.append_paramでパラメータを記録
3. CASE式で定数名マッチング
   └─ UPPER(pi_constant_name)で大文字に統一して比較
4. 定数値取得
   └─ マッチした場合：qa_constant_pkg.gc_*の値を取得
   └─ マッチしない場合：e_constant_not_found例外を発生
5. 結果返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータログ記録]
    B --> C{CASE UPPER pi_constant_name}
    C -->|gc_quasto_name| D[gc_quasto_nameの値を返却]
    C -->|gc_quasto_version| E[gc_quasto_versionの値を返却]
    C -->|gc_utplsql_flag| F[gc_utplsql_flagの値を返却]
    C -->|...その他| G[対応する定数値を返却]
    C -->|マッチなし| H[e_constant_not_found例外発生]
    D --> I[終了]
    E --> I
    F --> I
    G --> I
    H --> J[エラーログ記録]
    J --> K[raise_application_error -20001]
    K --> L[異常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | 大文字小文字非区別 | 定数名はUPPERで大文字に変換して比較 | 常時 |
| BR-40-02 | 型分離 | 文字列定数と数値定数は別関数で取得 | 常時 |
| BR-40-03 | 存在チェック | 存在しない定数名の場合は例外を発生 | 常時 |
| BR-40-04 | エラーコード | 存在しない定数の場合は-20001エラー | 常時 |

### 取得可能な定数一覧

#### VARCHAR2型（f_get_constant_string_value）

| 定数名 | 説明 |
|--------|------|
| gc_quasto_name | QUASTOのアプリケーション名 |
| gc_quasto_version | QUASTOのバージョン番号 |
| gc_black_list_exception_text | ブラックリスト例外メッセージ |
| gc_utplsql_ut_test_packages_prefix | utPLSQLテストパッケージのプレフィックス |
| gc_utplsql_scheduler_cronjob_name | スケジューラCronジョブ名 |
| gc_utplsql_custom_scheduler_job_name | カスタムスケジューラジョブ名 |

#### NUMBER型（f_get_constant_number_value）

| 定数名 | 説明 |
|--------|------|
| gc_utplsql_flag | utPLSQL機能有効フラグ |
| gc_apex_flag | APEX機能有効フラグ |
| gc_logger_flag | Logger機能有効フラグ |
| gc_utplsql_single_package | 単一パッケージモード |
| gc_utplsql_single_package_per_rule | ルールごと単一パッケージモード |
| gc_utplsql_scheme_result_failure | テスト結果：失敗 |
| gc_utplsql_scheme_result_success | テスト結果：成功 |
| gc_utplsql_scheme_result_error | テスト結果：エラー |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本機能はデータベース操作を行わない |

### テーブル別操作詳細

本機能はパッケージ定数の参照のみで、データベーステーブルへの直接操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | e_constant_not_found | 指定された定数名が存在しない | 有効な定数名を指定する |
| OTHERS | 例外 | その他のエラー | エラーログを確認 |

### リトライ仕様

本機能にリトライ仕様はない。エラー発生時は呼び出し元に例外を伝播する。

## トランザクション仕様

本機能はトランザクションに影響を与えない（パッケージ定数の参照のみ）。

## パフォーマンス要件

- CASE式による分岐処理のため、即座に完了
- パッケージ定数へのアクセスはメモリ上で完結

## セキュリティ考慮事項

- 定数値に機密情報が含まれないことを確認
- パッケージ定数はコンパイル時に確定するため、実行時の改ざんは不可能

## 備考

- 新しい定数をqa_constant_pkgに追加した場合、本関数にも対応するCASE分岐を追加する必要がある
- install_constant_package.sqlでqa_constant_pkgが動的に生成される
- 定数名の比較はUPPERで大文字に変換されるため、大文字小文字を区別しない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数パッケージの定義を理解する

取得対象となる定数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | qa_constant_pkgの動的生成スクリプト（25-61行目） |

**主要ポイント**:
- **42行目**: gc_quasto_name定数
- **43行目**: gc_quasto_version定数（動的バージョン）
- **44-46行目**: フラグ定数（utplsql_flag、apex_flag、logger_flag）
- **48-55行目**: utPLSQL関連定数
- **58-59行目**: 例外メッセージ定数

#### Step 2: 関数の仕様を理解する

2つの関数の仕様を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | f_get_constant_string_value仕様部（94-96行目） |
| 2-2 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | f_get_constant_number_value仕様部（104-106行目） |

#### Step 3: VARCHAR2版の実装を理解する

文字列定数取得の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | f_get_constant_string_value本体（367-410行目） |

**主要処理フロー**:
- **371-372行目**: ローカル変数宣言（c_unit、l_param_list）
- **373-374行目**: カスタム例外の定義（e_constant_not_found）
- **376行目**: 結果格納用変数l_constant_value宣言
- **378-380行目**: パラメータログ記録
- **382-394行目**: CASE式で定数名マッチングとVARCHAR2定数値の取得
- **396行目**: 結果返却
- **397-409行目**: 例外処理ブロック

#### Step 4: NUMBER版の実装を理解する

数値定数取得の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | f_get_constant_number_value本体（412-457行目） |

**主要処理フロー**:
- **416-417行目**: ローカル変数宣言（c_unit、l_param_list）
- **418-419行目**: カスタム例外の定義（e_constant_not_found）
- **421行目**: 結果格納用変数l_constant_value宣言（NUMBER型）
- **423-425行目**: パラメータログ記録
- **427-441行目**: CASE式で定数名マッチングとNUMBER定数値の取得
- **443行目**: 結果返却
- **444-456行目**: 例外処理ブロック

#### Step 5: 例外処理パターンを理解する

カスタム例外の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | e_constant_not_found例外処理（397-403行目、444-450行目） |

**例外処理パターン**:
```sql
WHEN e_constant_not_found THEN
  qa_logger_pkg.p_qa_log(...);
  raise_application_error(-20001, gc_invalid_constant_exception_text || ': ' || pi_constant_name);
```

### プログラム呼び出し階層図

```
f_get_constant_string_value (qa_utils_pkg)
    │
    ├─ qa_logger_pkg.append_param (パラメータログ記録)
    │
    ├─ CASE式 (定数名マッチング)
    │      │
    │      └─ qa_constant_pkg.gc_* (定数参照)
    │
    ├─ [存在しない定数] raise e_constant_not_found
    │      │
    │      ├─ qa_logger_pkg.p_qa_log (エラーログ記録)
    │      │
    │      └─ raise_application_error -20001
    │
    └─ [エラー時] qa_logger_pkg.p_qa_log (エラーログ記録)

f_get_constant_number_value (qa_utils_pkg)
    │
    └─ (同様の構造)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

pi_constant_name
'gc_quasto_version' ───▶ f_get_constant_string_value ───▶ '24.1'
                              │
                              ▼
                    ┌────────────────────────┐
                    │ 1. UPPER で大文字化    │
                    │ 2. CASE で分岐        │
                    │ 3. qa_constant_pkg参照 │
                    └────────────────────────┘

pi_constant_name
'gc_logger_flag'    ───▶ f_get_constant_number_value ───▶ 1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | 定数値取得機能を含むユーティリティパッケージ |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | qa_constant_pkgの動的生成スクリプト |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | エラーログ記録用パッケージ |
