# 機能設計書 41-ブラックリスト判定

## 概要

本ドキュメントは、QUASTOシステムにおけるブラックリスト判定機能の設計を記述する。ユーザー/スキーマがテスト対象から除外すべきブラックリストに登録されているかを判定する機能である。

### 本機能の処理概要

**業務上の目的・背景**：Oracleデータベースには、SYS、SYSTEM、APEX関連スキーマなど、品質チェックの対象とすべきでないシステムスキーマが存在する。これらのスキーマに対してQUASTOのルールを実行すると、不要なエラーが発生したり、システム領域への意図しないアクセスが発生する可能性がある。本機能は、そのようなシステムスキーマをブラックリストとして管理し、テスト対象から自動的に除外することで、ユーザーが意図した業務スキーマのみを品質チェックの対象とすることを目的とする。

**機能の利用シーン**：本機能は、ユニットテストパッケージの生成時、ルール実行時、スキーマ選択時など、スキーマ名を指定するあらゆる場面で利用される。特に、ユーザーが手動でスキーマ名を入力する際の入力検証として、また自動処理でスキーマ一覧を取得する際のフィルタリングとして使用される。

**主要な処理内容**：
1. 入力されたユーザー名をqa_scheme_names_for_testing_vビューと照合
2. ビューに存在しない場合はブラックリスト登録と判定
3. ブラックリスト登録の場合は例外（-20007）を発生させてエラーメッセージを返却
4. ブラックリスト未登録の場合はFALSEを返却して処理続行を許可

**関連システム・外部連携**：Oracleデータディクショナリ（ALL_USERS）を参照してスキーマ一覧を取得する。

**権限による制御**：特別な権限制御はなく、DEFINER権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Unit Test Generation | 参照画面 | スキーム選択時のバリデーション |
| 11 | Restart Unit Test | 参照画面 | スキーム指定時のバリデーション |

## 機能種別

バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_user_name | VARCHAR2 | No | 判定対象のユーザー名/スキーマ名 | NULLの場合はFALSEを返却 |

### 入力データソース

- 呼び出し元プログラムからのパラメータ入力
- qa_scheme_names_for_testing_vビュー（ALL_USERSデータディクショナリを参照）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | BOOLEAN | TRUE=ブラックリスト登録あり、FALSE=ブラックリスト登録なし |

### 出力先

- 呼び出し元プログラムへの戻り値として返却
- ブラックリスト登録時はエラーログ（loggerフレームワーク）に記録

## 処理フロー

### 処理シーケンス

```
1. パラメータログ記録
   └─ pi_user_nameをロギング
2. NULL判定
   └─ pi_user_nameがNULLの場合、FALSEを返却して終了
3. ビュー照合
   └─ qa_scheme_names_for_testing_vでユーザー名をカウント（大文字変換して比較）
4. ブラックリスト判定
   └─ カウント=0の場合、TRUE（ブラックリスト）
   └─ カウント>0の場合、FALSE（非ブラックリスト）
5. 例外発生（ブラックリスト時）
   └─ e_user_blacklisted例外を発生
   └─ raise_application_error(-20007)でエラーメッセージを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{pi_user_name IS NULL?}
    B -->|Yes| C[FALSE を返却]
    B -->|No| D[qa_scheme_names_for_testing_v でカウント]
    D --> E{カウント = 0?}
    E -->|Yes| F[l_result = TRUE]
    F --> G[e_user_blacklisted 例外発生]
    G --> H[raise_application_error -20007]
    H --> I[エラーログ記録]
    E -->|No| J[l_result = FALSE]
    J --> K[FALSE を返却]
    C --> L[終了]
    I --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-41-01 | システムスキーマ除外 | SYS、SYSTEM、APEX関連など70以上のOracleシステムスキーマをブラックリストとして除外 | 常時 |
| BR-41-02 | APEXオーナー除外 | APEX_nnnn00形式のスキーマ（APEXバージョン管理用）を除外 | 常時 |
| BR-41-03 | NULL入力許容 | ユーザー名がNULLの場合はFALSE（非ブラックリスト）として扱う | pi_user_name IS NULL |
| BR-41-04 | 大文字小文字無視 | スキーマ名の比較は大文字に統一して実行 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブラックリスト照合 | qa_scheme_names_for_testing_v | SELECT | ビューを通じてALL_USERSから非ブラックリストユーザーを取得 |

### テーブル別操作詳細

#### qa_scheme_names_for_testing_v（ビュー）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | username | upper(v.username) = upper(pi_user_name) | 大文字変換して比較 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20006 | ユーザー定義例外 | ブラックリスト登録ユーザーが検出された場合（内部例外） | -20007に変換して再スロー |
| -20007 | アプリケーションエラー | ブラックリスト登録ユーザーが検出された場合 | 呼び出し元で適切にハンドリング |
| OTHERS | その他例外 | 予期しないエラー発生時 | ログ記録後に再スロー |

### リトライ仕様

リトライ不要（同期処理）

## トランザクション仕様

読み取り専用のため、トランザクション管理不要

## パフォーマンス要件

- ビュー参照のみのため、即時応答（数ミリ秒以内）を想定

## セキュリティ考慮事項

- DEFINER権限で実行されるため、呼び出し元ユーザーの権限に関わらずALL_USERSへのアクセスが可能
- ブラックリスト判定結果はログに記録され、監査証跡として利用可能

## 備考

- ブラックリストは qa_scheme_names_for_testing_v ビュー内でハードコードされている
- 新たなシステムスキーマを除外する場合は、ビュー定義の修正が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ブラックリスト判定の基盤となるビュー定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | ブラックリストとして除外されるスキーマ一覧と除外条件を確認 |

**読解のコツ**:
- NOT IN句に列挙されているスキーマ名がブラックリスト対象
- 4-77行目にOracle、APEX、ORDS、Publicの各カテゴリの除外スキーマが定義されている
- 79行目の正規表現でAPEX_nnnn00形式のスキーマを動的に除外している

#### Step 2: エントリーポイントを理解する

判定処理の本体であるファンクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_is_owner_black_listed関数のスペックと実装を確認 |

**主要処理フロー**:
1. **195-200行目（スペック）**: 関数のインターフェース定義、@throwsでE_USER_BLACKLISTED例外を明示
2. **1006-1008行目（ボディ）**: 関数本体の開始、定数・変数宣言
3. **1013-1015行目**: e_user_blacklisted例外の定義（PRAGMA EXCEPTION_INIT -20006）
4. **1018-1020行目**: パラメータのログ記録
5. **1022-1027行目**: NULL判定とビュー照合のSELECT文
6. **1029-1035行目**: カウント結果による分岐処理
7. **1043-1046行目**: 例外ハンドラでraise_application_error(-20007)を発行

#### Step 3: 定数定義を理解する

エラーメッセージ等の定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql`（存在する場合） | gc_black_list_exception_textの定義を確認 |

**主要処理フロー**:
- エラーメッセージのテンプレート文字列が定義されている

### プログラム呼び出し階層図

```
qa_main_pkg.f_is_owner_black_listed(pi_user_name)
    │
    ├─ qa_logger_pkg.append_param() -- パラメータログ記録
    │
    ├─ SELECT COUNT(1) FROM qa_scheme_names_for_testing_v
    │      └─ ALL_USERS (データディクショナリ)
    │
    ├─ [ブラックリスト時] raise_application_error(-20007)
    │      └─ qa_constant_pkg.gc_black_list_exception_text
    │
    └─ qa_logger_pkg.p_qa_log() -- エラーログ記録
```

### データフロー図

```
[入力]                [処理]                              [出力]

pi_user_name ───▶ f_is_owner_black_listed() ───▶ BOOLEAN (TRUE/FALSE)
                        │                              │
                        ▼                              ▼
               qa_scheme_names_for_testing_v     [例外時] -20007エラー
                        │
                        ▼
                   ALL_USERS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | f_is_owner_black_listed関数を含むメインパッケージ |
| qa_scheme_names_for_testing_v.sql | `src/plsql/vw/qa_scheme_names_for_testing_v.sql` | ソース | 非ブラックリストスキーマを返すビュー定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | ソース | ログ記録用パッケージ |
| qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql` | ソース | 定数定義パッケージ |
