# 機能設計書 42-ルール格納

## 概要

本ドキュメントは、QUASTOシステムにおけるルール格納機能の設計を記述する。QA_RULESテーブルにルール定義を永続化し、品質チェックルールのマスタデータを管理するテーブル構造である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOは、Oracleデータベースのデータモデル、PL/SQLコード、APEXアプリケーションに対する品質チェックルールを一元管理するツールである。これらのルールを永続的に保存し、ルールの追加・変更・削除、バージョン管理、エクスポート/インポートを可能にするための中核となるデータストアとして本テーブルが機能する。各ルールはSQLクエリとして定義され、実行時に動的に評価される。

**機能の利用シーン**：本テーブルは、ルールの新規登録、既存ルールの編集、ルールの有効/無効切り替え、ルール一覧表示、ルール実行、JSONエクスポート/インポート、ユニットテストパッケージ生成など、QUASTOのほぼすべての機能から参照・更新される。

**主要な処理内容**：
1. ルール定義情報の永続化（INSERT）
2. ルール属性の更新（UPDATE）
3. ルール情報の取得（SELECT）- 単一ルール、複数ルール、属性別取得など
4. ルールの削除（DELETE）
5. ルールメタデータの管理（作成者、更新者、作成日時、更新日時）

**関連システム・外部連携**：
- APEXアプリケーション（ルール編集画面、ルール一覧画面）
- JSONエクスポート/インポート機能
- utPLSQLユニットテスト生成機能

**権限による制御**：テーブルへの直接アクセスはDEFINER権限のパッケージ経由で行われ、通常ユーザーは直接操作しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Rules | 主画面 | ルール一覧のInteractive Report表示 |
| 8 | Add/Edit Rule | 主画面 | ルールの新規作成・編集フォーム |
| 9 | Rule Files | 参照画面 | JSONエクスポート/インポート |
| 12 | Region Plugin | 参照画面 | ルール実行時の参照 |

## 機能種別

データ管理（テーブル定義）

## 入力仕様

### 入力パラメータ（テーブルカラム定義）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| QARU_ID | NUMBER | Yes | 主キー（自動採番） | NOT NULL, シーケンスによる自動生成 |
| QARU_RULE_NUMBER | VARCHAR2(20 CHAR) | Yes | ルール番号 | NOT NULL |
| QARU_CLIENT_NAME | VARCHAR2(100 CHAR) | Yes | クライアント/プロジェクト名 | NOT NULL |
| QARU_NAME | VARCHAR2(100 CHAR) | Yes | ルール名 | NOT NULL |
| QARU_CATEGORY | VARCHAR2(100 CHAR) | Yes | ルールカテゴリ | NOT NULL, CHECK ('APEX','DDL','DATA') |
| QARU_OBJECT_TYPES | VARCHAR2(4000 CHAR) | Yes | 対象オブジェクトタイプ（コロン区切り） | NOT NULL |
| QARU_ERROR_MESSAGE | VARCHAR2(4000 CHAR) | Yes | エラーメッセージ | NOT NULL |
| QARU_COMMENT | VARCHAR2(4000 CHAR) | No | コメント | - |
| QARU_EXCLUDE_OBJECTS | VARCHAR2(4000 CHAR) | No | 除外オブジェクト（コロン区切り） | - |
| QARU_ERROR_LEVEL | NUMBER | Yes | エラーレベル | NOT NULL, CHECK (1,2,4) |
| QARU_IS_ACTIVE | NUMBER | Yes | 有効フラグ | NOT NULL, DEFAULT 1, CHECK (0,1) |
| QARU_SQL | CLOB | Yes | ルールSQL（QUASTO形式） | NOT NULL, length <= 32767 |
| QARU_PREDECESSOR_IDS | VARCHAR2(4000 CHAR) | No | 先行ルールID（コロン区切り） | - |
| QARU_LAYER | VARCHAR2(100 CHAR) | Yes | レイヤー | NOT NULL, CHECK ('PAGE','APPLICATION','DATABASE') |
| QARU_CREATED_ON | DATE | Yes | 作成日時 | NOT NULL |
| QARU_CREATED_BY | VARCHAR2(255 CHAR) | Yes | 作成者 | NOT NULL |
| QARU_UPDATED_ON | DATE | Yes | 更新日時 | NOT NULL |
| QARU_UPDATED_BY | VARCHAR2(255 CHAR) | Yes | 更新者 | NOT NULL |
| QARU_FAILURE_RATE | NUMBER | No | 失敗率 | - |
| QARU_APP_ID | VARCHAR2(4000 CHAR) | No | 対象APEXアプリID（カンマ区切り） | NULL時は全アプリ対象 |
| QARU_PAGE_ID | VARCHAR2(4000 CHAR) | No | 対象APEXページID（カンマ区切り） | NULL時は全ページ対象 |

### 入力データソース

- APEXアプリケーションのルール編集画面
- JSONインポート機能
- qa_main_pkg.f_insert_rule関数

## 出力仕様

### 出力データ

テーブル構造自体が出力仕様を定義する。

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QARU_ID | NUMBER | 主キー |
| QARU_RULE_NUMBER | VARCHAR2 | ルール識別番号 |
| その他全21列 | 各種 | 上記入力パラメータ参照 |

### 出力先

- データベーステーブル（QA_RULES）

## 処理フロー

### 処理シーケンス（INSERT時）

```
1. シーケンスからQARU_IDを取得
   └─ トリガまたはシーケンス呼び出しによる自動採番
2. 制約チェック
   └─ NOT NULL制約、CHECK制約の検証
3. ユニークキー検証
   └─ RULE_NUMBER + CLIENT_NAMEの一意性確認
4. データ挿入
   └─ QA_RULESテーブルへのINSERT
5. 監査情報記録
   └─ CREATED_ON, CREATED_BY, UPDATED_ON, UPDATED_BYの設定
```

### フローチャート

```mermaid
flowchart TD
    A[INSERT開始] --> B[シーケンスからID取得]
    B --> C{制約チェック}
    C -->|OK| D{ユニークキーチェック}
    C -->|NG| E[制約違反エラー]
    D -->|OK| F[データ挿入]
    D -->|NG| G[重複エラー]
    F --> H[監査情報設定]
    H --> I[COMMIT]
    I --> J[終了]
    E --> K[エラー終了]
    G --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-42-01 | カテゴリ制約 | QARU_CATEGORYは'APEX','DDL','DATA'のいずれか | 常時 |
| BR-42-02 | エラーレベル制約 | QARU_ERROR_LEVELは1(Error),2(Warning),4(Info)のいずれか | 常時 |
| BR-42-03 | 有効フラグ制約 | QARU_IS_ACTIVEは0(無効)または1(有効) | 常時 |
| BR-42-04 | レイヤー制約 | QARU_LAYERは'PAGE','APPLICATION','DATABASE'のいずれか | 常時 |
| BR-42-05 | SQL長制約 | QARU_SQLは32767文字以下 | 常時 |
| BR-42-06 | ルール番号一意性 | 同一クライアント内でルール番号は一意 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール追加 | QA_RULES | INSERT | 新規ルールの登録 |
| ルール更新 | QA_RULES | UPDATE | 既存ルールの変更 |
| ルール削除 | QA_RULES | DELETE | ルールの削除（参照整合性に注意） |
| ルール参照 | QA_RULES | SELECT | 各種ルール情報の取得 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全21列 | パラメータ値 | QARU_IDはシーケンス |
| UPDATE | 任意列 | 新しい値、UPDATED_ON=SYSDATE, UPDATED_BY=USER | 監査列必須更新 |
| DELETE | - | WHERE QARU_ID = :id | 参照先テーブルに注意 |
| SELECT | 必要列 | WHERE条件による | インデックス利用推奨 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | RULE_NUMBER+CLIENT_NAMEの重複 | ルール番号の変更 |
| ORA-02290 | CHECK制約違反 | CATEGORY, ERROR_LEVEL, IS_ACTIVE, LAYERの不正値 | 許容値の確認 |
| ORA-01400 | NOT NULL制約違反 | 必須列のNULL挿入 | 必須値の設定 |
| ORA-02291 | 参照整合性違反 | 参照先の存在しないFK | FK参照先の確認 |

### リトライ仕様

トランザクション管理は呼び出し元に委譲

## トランザクション仕様

- 呼び出し元でCOMMIT/ROLLBACKを制御
- 単一テーブル操作のためデッドロックリスクは低い

## パフォーマンス要件

- ルール数は通常100〜1000件程度を想定
- QARU_CLIENT_NAME, QARU_RULE_NUMBERにインデックスを設定
- QARU_IS_ACTIVEによるフィルタリングが頻繁

## セキュリティ考慮事項

- QARU_SQLにはSQL文が格納されるため、SQLインジェクション対策が必要（動的実行時）
- テーブルへの直接アクセスは制限し、パッケージ経由でアクセス
- 監査列による変更履歴の追跡が可能

## 備考

- テーブルコメントおよび列コメントがDDLに定義されている
- シーケンスとトリガによる自動採番を想定（別途定義が必要）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、テーブル定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql (tab) | `src/ddl/tab/qa_rules.sql` | テーブルの21列の定義とコメントを確認 |
| 1-2 | qa_rules.sql (cons) | `src/ddl/cons/qa_rules.sql` | 主キー、ユニークキー、CHECK制約を確認 |
| 1-3 | qa_rules.sql (ind) | `src/ddl/ind/qa_rules.sql` | インデックス定義を確認 |

**読解のコツ**:
- DDLはdeclareブロック内で動的SQLとして実行される形式
- 4-27行目でCREATE TABLE文が定義されている
- 40-60行目で各列のコメントが設定されている

#### Step 2: 制約定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_rules.sql (cons) | `src/ddl/cons/qa_rules.sql` | 制約の一覧とCHECK条件を確認 |

**主要処理フロー**:
1. **10-24行目**: QARU_PK主キー制約の作成
2. **26-44行目**: QARU_CHK_CATEGORY CHECK制約（'APEX','DDL','DATA'）
3. **46-64行目**: QARU_CHK_ERROR_LEVEL CHECK制約（1,2,4）
4. **66-84行目**: QARU_CHK_IS_ACTIVE CHECK制約（0,1）
5. **86-104行目**: QARU_CHK_SQL CHECK制約（length <= 32767）
6. **106-124行目**: QARU_CHK_LAYER CHECK制約（'PAGE','APPLICATION','DATABASE'）

#### Step 3: 操作関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_insert_rule関数でのINSERT処理を確認 |
| 3-2 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_get_rule, f_get_rule_pk等の取得関数を確認 |

**主要処理フロー**:
- **151-166行目（スペック）**: f_insert_rule関数のインターフェース
- **749-838行目（ボディ）**: f_insert_rule関数の実装、INSERT文（800-828行目）
- **21-26行目（スペック）**: f_get_rule関数のインターフェース
- **213-256行目（ボディ）**: f_get_rule関数の実装、SELECTとqa_rule_tへの変換

### プログラム呼び出し階層図

```
[APEXアプリケーション]
    │
    ├─ qa_main_pkg.f_insert_rule()
    │      └─ INSERT INTO QA_RULES
    │
    ├─ qa_main_pkg.f_get_rule()
    │      └─ SELECT FROM QA_RULES
    │
    ├─ qa_export_import_rules_pkg.f_export_rules_table_to_clob()
    │      └─ SELECT FROM QA_RULES (JSON生成)
    │
    └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table()
           └─ INSERT INTO QA_RULES (JSONパース)
```

### データフロー図

```
[入力]                    [テーブル]              [出力]

APEXフォーム ─────┐
                  │
JSONインポート ──┼───▶ QA_RULES ───▶ ルール実行結果
                  │      (21列)        ビュー参照
f_insert_rule() ──┘                    JSONエクスポート
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | テーブル定義 |
| qa_rules.sql | `src/ddl/cons/qa_rules.sql` | DDL | 制約定義 |
| qa_rules.sql | `src/ddl/ind/qa_rules.sql` | DDL | インデックス定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | CRUD操作関数 |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | エクスポート/インポート処理 |
| qa_rules_p0007_v.sql | `src/plsql/vw/qa_rules_p0007_v.sql` | ソース | ルール一覧画面用ビュー |
