# 機能設計書 43-インポートファイル格納

## 概要

本ドキュメントは、QUASTOシステムにおけるインポートファイル格納機能の設計を記述する。QA_IMPORT_FILESテーブルにインポートしたJSONルールファイルを永続化し、インポート履歴とファイル内容を管理するテーブル構造である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOでは、ルール定義を他の環境間で共有するためにJSONエクスポート/インポート機能を提供している。インポートしたファイルの履歴管理、インポート処理のステータス追跡、エラー発生時の原因調査を可能にするため、インポートファイルの原本と処理結果を保存する必要がある。本テーブルはそのための永続化ストレージとして機能する。

**機能の利用シーン**：本テーブルは、APEXアプリケーションのRule Files画面からJSONファイルをアップロードする際に使用される。インポート処理の成功/失敗に関わらずファイル情報が記録され、後からインポート履歴を確認したり、エラー内容を調査したりする際に参照される。

**主要な処理内容**：
1. アップロードされたJSONファイルの格納（INSERT）
2. インポート処理ステータスの更新（UPDATE）- SUCCESS/ERRORなど
3. エラー発生時のエラーログ記録（UPDATE）
4. インポート履歴の取得（SELECT）
5. 監査情報の管理（作成者、更新者、作成日時、更新日時）

**関連システム・外部連携**：
- APEXアプリケーション（Rule Files画面でのファイルアップロード）
- qa_export_import_rules_pkg（JSONインポート処理）

**権限による制御**：テーブルへの直接アクセスはDEFINER権限のパッケージ経由で行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Rule Files | 主画面 | JSONファイルのアップロード・インポート |

## 機能種別

データ管理（テーブル定義）

## 入力仕様

### 入力パラメータ（テーブルカラム定義）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| QAIF_ID | NUMBER | Yes | 主キー（自動採番） | NOT NULL |
| QAIF_FILENAME | VARCHAR2(200 CHAR) | Yes | ファイル名 | NOT NULL |
| QAIF_MIMETYPE | VARCHAR2(200 CHAR) | Yes | MIMEタイプ | NOT NULL |
| QAIF_CLOB_DATA | CLOB | Yes | ファイル内容（JSON） | NOT NULL |
| QAIF_STATUS | VARCHAR2(50 CHAR) | No | アップロードステータス | - |
| QAIF_ERROR_LOG | VARCHAR2(4000 CHAR) | No | エラーログ | QAIF_STATUS='ERROR'時に設定 |
| QAIF_CREATED_ON | DATE | No | 作成日時 | DEFAULT SYSDATE |
| QAIF_CREATED_BY | VARCHAR2(255 CHAR) | No | 作成者 | DEFAULT USER |
| QAIF_UPDATED_ON | DATE | No | 更新日時 | DEFAULT SYSDATE |
| QAIF_UPDATED_BY | VARCHAR2(255) | No | 更新者 | DEFAULT USER |

### 入力データソース

- APEXファイルアップロードコンポーネント
- qa_apex_app_pkg.p_upload_rules_json

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QAIF_ID | NUMBER | 主キー |
| QAIF_FILENAME | VARCHAR2 | ファイル名 |
| QAIF_STATUS | VARCHAR2 | 処理ステータス（SUCCESS/ERROR等） |
| その他全10列 | 各種 | 上記入力パラメータ参照 |

### 出力先

- データベーステーブル（QA_IMPORT_FILES）

## 処理フロー

### 処理シーケンス（INSERT時）

```
1. ファイルアップロード受信
   └─ APEXアプリからファイルデータを受信
2. シーケンスからQAIF_IDを取得
   └─ 自動採番
3. ファイル情報の挿入
   └─ ファイル名、MIMEタイプ、CLOB内容を格納
4. デフォルト値設定
   └─ CREATED_ON=SYSDATE, CREATED_BY=USER
5. インポート処理実行
   └─ JSONパースとQA_RULESへの登録
6. ステータス更新
   └─ 成功時: QAIF_STATUS='SUCCESS'
   └─ 失敗時: QAIF_STATUS='ERROR', QAIF_ERROR_LOG=エラー内容
```

### フローチャート

```mermaid
flowchart TD
    A[ファイルアップロード] --> B[QAIF_IDを採番]
    B --> C[ファイル情報をINSERT]
    C --> D[JSONインポート処理]
    D --> E{処理結果}
    E -->|成功| F[QAIF_STATUS = 'SUCCESS']
    E -->|失敗| G[QAIF_STATUS = 'ERROR']
    G --> H[QAIF_ERROR_LOG = エラー内容]
    F --> I[COMMIT]
    H --> I
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | ステータス管理 | QAIF_STATUSはインポート処理の結果を反映 | インポート処理完了時 |
| BR-43-02 | エラーログ記録 | エラー発生時はQAIF_ERROR_LOGに原因を記録 | QAIF_STATUS='ERROR'時 |
| BR-43-03 | デフォルト監査値 | 作成日時/作成者は自動設定 | INSERT時 |
| BR-43-04 | ファイル原本保存 | インポートの成功/失敗に関わらずファイル内容を保存 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル登録 | QA_IMPORT_FILES | INSERT | アップロードファイルの登録 |
| ステータス更新 | QA_IMPORT_FILES | UPDATE | インポート結果の記録 |
| 履歴参照 | QA_IMPORT_FILES | SELECT | インポート履歴の取得 |

### テーブル別操作詳細

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全列 | アップロードファイル情報 | デフォルト値利用 |
| UPDATE | QAIF_STATUS, QAIF_ERROR_LOG | インポート結果 | 処理完了後 |
| SELECT | 必要列 | WHERE条件による | 履歴確認用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | QAIF_IDの重複 | シーケンス確認 |
| ORA-01400 | NOT NULL制約違反 | 必須列のNULL挿入 | 必須値の設定 |
| JSON_PARSE_ERROR | アプリケーションエラー | JSONパース失敗 | QAIF_ERROR_LOGに記録 |

### リトライ仕様

リトライ不要（インポート処理は再実行可能）

## トランザクション仕様

- ファイル登録とインポート処理は同一トランザクション
- エラー時はファイル登録のみCOMMIT、インポート処理はROLLBACK

## パフォーマンス要件

- CLOB格納のため、大容量ファイル対応
- インポートファイル数は通常少数（履歴管理用）

## セキュリティ考慮事項

- ファイル内容にはルール定義（SQLクエリ含む）が格納される
- アップロード者の監査証跡を保持

## 備考

- ステータス値は文字列で管理（制約なし）
- ファイル内容の削除は行わず、履歴として保持

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_import_files.sql (tab) | `src/ddl/tab/qa_import_files.sql` | テーブルの10列の定義とデフォルト値を確認 |
| 1-2 | qa_import_files.sql (cons) | `src/ddl/cons/qa_import_files.sql` | 主キー制約を確認 |

**読解のコツ**:
- 3-15行目でCREATE TABLE文が定義されている
- 11-12行目でデフォルト値（SYSDATE, USER）が設定されている
- 28-38行目で各列のコメントが設定されている

#### Step 2: 操作関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_import_clob_to_qa_import_files関数を確認 |
| 2-2 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_json手続きを確認 |

### プログラム呼び出し階層図

```
[APEXアプリケーション - Rule Files画面]
    │
    └─ qa_apex_app_pkg.p_upload_rules_json()
           │
           ├─ INSERT INTO QA_IMPORT_FILES
           │
           └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table()
                  │
                  └─ [成功/失敗] UPDATE QA_IMPORT_FILES (STATUS)
```

### データフロー図

```
[入力]                    [テーブル]              [出力]

JSONファイル ───▶ QA_IMPORT_FILES ───▶ インポート履歴
アップロード          (10列)            エラーログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | DDL | テーブル定義 |
| qa_import_files.sql | `src/ddl/cons/qa_import_files.sql` | DDL | 制約定義 |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | インポート処理 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEXアップロード処理 |
