# 機能設計書 44-テスト結果XML格納

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果XML格納機能の設計を記述する。QA_TEST_RESULTSテーブルにutPLSQLテスト実行結果をXML形式で永続化し、テスト結果の履歴管理とエクスポート/インポートを可能にするテーブル構造である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOはutPLSQLフレームワークと連携してユニットテストを実行する。テスト実行結果はJUnit形式のXMLとして生成され、CIツールとの連携やテスト結果の履歴管理に活用される。本テーブルは、これらのXML結果を永続的に保存し、後から参照・エクスポート・比較分析を可能にするためのストレージとして機能する。

**機能の利用シーン**：本テーブルは、スケジューラジョブによる定期テスト実行時、手動テスト実行時、テスト結果XMLのインポート/エクスポート時、ダッシュボードでの結果表示時に使用される。

**主要な処理内容**：
1. utPLSQLテスト結果XMLの格納（INSERT）
2. テスト結果の参照（SELECT）- ダッシュボード表示、詳細確認
3. テスト結果XMLのエクスポート（SELECT）
4. 外部XMLのインポート（INSERT）
5. テスト実行履歴の管理

**関連システム・外部連携**：
- utPLSQLフレームワーク（テスト実行とXML生成）
- APEXダッシュボード（テスト結果表示）
- CI/CDツール（XMLエクスポート連携）

**権限による制御**：テーブルへの直接アクセスはDEFINER権限のパッケージ経由で行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | API連携 | テスト結果の詳細情報をQA_TEST_RESULTSから取得 |
| 6 | Test Result Files | 主画面 | XMLファイルのアップロード・ダウンロード |

## 機能種別

データ管理（テーブル定義）

## 入力仕様

### 入力パラメータ（テーブルカラム定義）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| QATR_ID | NUMBER | Yes | 主キー（自動採番） | NOT NULL |
| QATR_XML_RESULT | CLOB | Yes | XML形式のテスト結果 | NOT NULL |
| QATR_ADDED_ON | DATE | Yes | 追加日時 | NOT NULL, UNIQUE |
| QATR_ADDED_BY | VARCHAR2(255 CHAR) | Yes | 追加者 | NOT NULL |
| QATR_DESCRIPTION | VARCHAR2(255 CHAR) | Yes | テスト結果の説明 | NOT NULL |

### 入力データソース

- qa_unit_tests_pkg.f_run_all_unit_tests
- qa_unit_tests_pkg.p_run_custom_unit_test
- qa_unit_tests_pkg.f_import_test_result
- APEXアプリケーション（XMLアップロード）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QATR_ID | NUMBER | 主キー |
| QATR_XML_RESULT | CLOB | JUnit形式XML |
| QATR_ADDED_ON | DATE | テスト実行日時 |
| QATR_ADDED_BY | VARCHAR2 | 実行者 |
| QATR_DESCRIPTION | VARCHAR2 | 実行方法の説明 |

### 出力先

- データベーステーブル（QA_TEST_RESULTS）
- XMLファイルエクスポート

## 処理フロー

### 処理シーケンス（テスト実行時）

```
1. ユニットテスト実行
   └─ utPLSQLフレームワークによるテスト実行
2. XML結果生成
   └─ ut_junit_reporter()によるJUnit形式XML生成
3. 結果格納
   └─ QA_TEST_RESULTSへのINSERT
4. 説明文設定
   └─ 実行方法（Suite Path/PL/SQL Call）を記録
```

### フローチャート

```mermaid
flowchart TD
    A[テスト実行開始] --> B[utPLSQL ut.run実行]
    B --> C[ut_junit_reporter でXML生成]
    C --> D[DBMS_XMLGEN.CONVERTで変換]
    D --> E[QA_TEST_RESULTSにINSERT]
    E --> F[QATR_DESCRIPTION設定]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | 追加日時一意性 | QATR_ADDED_ONは一意（同時刻の重複防止） | 常時 |
| BR-44-02 | 説明文記録 | 実行方法（Suite Path/PL/SQL Call）を説明に記録 | テスト実行時 |
| BR-44-03 | XML形式 | QATR_XML_RESULTはJUnit形式XMLを格納 | 常時 |
| BR-44-04 | インポート区別 | インポートされた結果は説明に'Imported by User'を記録 | インポート時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト結果保存 | QA_TEST_RESULTS | INSERT | 実行結果XMLの登録 |
| 結果参照 | QA_TEST_RESULTS | SELECT | ダッシュボード表示、詳細確認 |
| 結果エクスポート | QA_TEST_RESULTS | SELECT | XMLファイル出力 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全5列 | テスト結果情報 | 自動採番 |
| SELECT | QATR_XML_RESULT | WHERE QATR_ID = :id | エクスポート用 |
| SELECT | 全列 | ORDER BY QATR_ADDED_ON DESC | 履歴表示用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | QATR_ADDED_ONの重複 | 実行タイミング調整 |
| ORA-01400 | NOT NULL制約違反 | 必須列のNULL挿入 | 必須値の設定 |

### リトライ仕様

テスト再実行で対応可能

## トランザクション仕様

- テスト実行とは独立したトランザクションで結果を保存（AUTONOMOUS_TRANSACTION）

## パフォーマンス要件

- CLOBによる大容量XML対応
- 履歴参照時はインデックス（QATR_ADDED_ON）利用

## セキュリティ考慮事項

- テスト結果には対象スキーマ名やオブジェクト名が含まれる
- 追加者による監査証跡を保持

## 備考

- XML形式はJUnit互換（CI/CDツール連携可能）
- 削除機能は設計上想定されていない（履歴保持）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql (tab) | `src/ddl/tab/qa_test_results.sql` | テーブルの5列の定義を確認 |
| 1-2 | qa_test_results.sql (cons) | `src/ddl/cons/qa_test_results.sql` | 主キーとUNIQUE制約を確認 |

**読解のコツ**:
- 4-10行目でCREATE TABLE文が定義されている
- 5列のシンプルな構造
- QATR_ADDED_ONにUNIQUE制約があることに注意

#### Step 2: 操作関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_run_all_unit_tests関数（976-977行目）でのINSERT処理を確認 |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_import_test_result関数（1435-1458行目）でのインポート処理を確認 |
| 2-3 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_export_test_result関数（1460-1486行目）でのエクスポート処理を確認 |

**主要処理フロー**:
- **976-977行目**: INSERT INTO QA_TEST_RESULTS（通常実行時）
- **1025-1026行目**: INSERT INTO QA_TEST_RESULTS（カスタム実行時）
- **1446-1448行目**: INSERT INTO QA_TEST_RESULTS（インポート時）
- **1473-1476行目**: SELECT qatr_xml_result FROM QA_TEST_RESULTS（エクスポート時）

### プログラム呼び出し階層図

```
[スケジューラジョブ / APEXアプリ]
    │
    ├─ qa_unit_tests_pkg.f_run_all_unit_tests()
    │      ├─ ut.run() with ut_junit_reporter()
    │      └─ INSERT INTO QA_TEST_RESULTS
    │
    ├─ qa_unit_tests_pkg.p_run_custom_unit_test()
    │      ├─ ut.run() with ut_junit_reporter()
    │      └─ INSERT INTO QA_TEST_RESULTS
    │
    ├─ qa_unit_tests_pkg.f_import_test_result()
    │      └─ INSERT INTO QA_TEST_RESULTS
    │
    └─ qa_unit_tests_pkg.f_export_test_result()
           └─ SELECT FROM QA_TEST_RESULTS
```

### データフロー図

```
[入力]                    [テーブル]              [出力]

utPLSQL実行 ────┐
                │
XMLインポート ──┼───▶ QA_TEST_RESULTS ───▶ XMLエクスポート
                │         (5列)             ダッシュボード表示
XMLアップロード ┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テーブル定義 |
| qa_test_results.sql | `src/ddl/cons/qa_test_results.sql` | DDL | 制約定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | テスト実行とCRUD処理 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEXアップロード/ダウンロード処理 |
