# 機能設計書 45-テスト実行履歴格納

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト実行履歴格納機能の設計を記述する。QA_TEST_RUNSテーブルにユニットテスト実行の履歴を永続化し、ルール別・スキーマ別のテスト結果を管理するテーブル構造である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOはルール単位でユニットテストを実行し、各スキーマに対する品質チェック結果を記録する。ダッシュボードでのテスト結果可視化、テスト履歴の時系列分析、失敗ルールの特定と再実行管理を可能にするため、テスト実行ごとの結果を詳細に保存する必要がある。本テーブルはそのための中間履歴ストレージとして機能する。

**機能の利用シーン**：本テーブルは、ユニットテスト実行後の結果保存、ダッシュボードでの成功/失敗/エラー件数表示、タイムラインチャートでの履歴表示、失敗テストの再実行時の参照に使用される。

**主要な処理内容**：
1. テスト実行結果の格納（INSERT）- ルール×スキーマ単位
2. ランタイムエラー情報の記録（UPDATE）
3. テスト履歴の参照（SELECT）- ダッシュボード、詳細画面
4. 無効オブジェクトとの紐付け（外部キー参照元）
5. ルール参照（QA_RULESへの外部キー）

**関連システム・外部連携**：
- QA_RULES（親テーブル - ルール定義）
- QA_TEST_RUN_INVALID_OBJECTS（子テーブル - 無効オブジェクト詳細）
- APEXダッシュボード（テスト結果表示）

**権限による制御**：テーブルへの直接アクセスはDEFINER権限のパッケージ経由で行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 主機能 | QA_TEST_RUNSテーブルからテスト実行履歴データを表示 |
| 4 | Runtime Error | 主機能 | テスト実行時のランタイムエラーバックトレースを表示 |
| 11 | Restart Unit Test | 参照画面 | 失敗テストの再実行参照 |

## 機能種別

データ管理（テーブル定義）

## 入力仕様

### 入力パラメータ（テーブルカラム定義）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| QATR_ID | NUMBER | Yes | 主キー（自動採番） | NOT NULL |
| QATR_SCHEME_NAME | VARCHAR2(255 CHAR) | Yes | テスト対象スキーマ名 | NOT NULL |
| QATR_DATE | DATE | Yes | テスト実行日時 | NOT NULL |
| QATR_RESULT | NUMBER | Yes | テスト結果 | NOT NULL, CHECK (0,1,2) |
| QATR_QARU_ID | NUMBER | Yes | ルールID（外部キー） | NOT NULL, FK to QA_RULES |
| QATR_ADDED_BY | VARCHAR2(255 CHAR) | Yes | 実行者 | NOT NULL |
| QATR_RUNTIME_ERROR | VARCHAR2(4000 CHAR) | No | ランタイムエラーバックトレース | エラー発生時のみ |
| QATR_PROGRAM_NAME | VARCHAR2(4000 CHAR) | No | ユニットテストプロシージャ名 | package.procedure形式 |

### 入力データソース

- qa_unit_tests_pkg.p_handle_test_result
- qa_unit_tests_pkg.p_handle_test_exception

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QATR_ID | NUMBER | 主キー |
| QATR_SCHEME_NAME | VARCHAR2 | スキーマ名 |
| QATR_DATE | DATE | 実行日時 |
| QATR_RESULT | NUMBER | 0=失敗, 1=成功, 2=エラー |
| QATR_QARU_ID | NUMBER | 関連ルールID |
| QATR_ADDED_BY | VARCHAR2 | 実行者 |
| QATR_RUNTIME_ERROR | VARCHAR2 | エラー詳細 |
| QATR_PROGRAM_NAME | VARCHAR2 | 実行プロシージャ名 |

### 出力先

- データベーステーブル（QA_TEST_RUNS）

## 処理フロー

### 処理シーケンス（テスト結果保存時）

```
1. テスト実行完了
   └─ qa_main_pkg.p_test_ruleからの結果取得
2. 結果判定
   └─ 無効オブジェクト数=0→成功(1)、>0→失敗(0)
3. 履歴登録
   └─ QA_TEST_RUNSへのINSERT
4. 無効オブジェクト登録（失敗時）
   └─ QA_TEST_RUN_INVALID_OBJECTSへの登録
5. エラー発生時
   └─ QATR_RUNTIME_ERRORの更新
```

### フローチャート

```mermaid
flowchart TD
    A[テスト実行完了] --> B{例外発生?}
    B -->|No| C[p_handle_test_result呼び出し]
    B -->|Yes| D[p_handle_test_exception呼び出し]
    C --> E{無効オブジェクト=0?}
    E -->|Yes| F[QATR_RESULT=1 成功]
    E -->|No| G[QATR_RESULT=0 失敗]
    F --> H[QA_TEST_RUNSにINSERT]
    G --> H
    D --> I[QATR_RESULT=2 エラー]
    I --> J[QA_TEST_RUNSにINSERT]
    J --> K[QATR_RUNTIME_ERRORを更新]
    H --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 結果コード定義 | 0=失敗(Failure)、1=成功(Success)、2=エラー(Error) | 常時 |
| BR-45-02 | ルール参照整合性 | QATR_QARU_IDはQA_RULES.QARU_IDを参照 | 常時 |
| BR-45-03 | エラー記録 | 実行時例外発生時はQATR_RUNTIME_ERRORに詳細を記録 | エラー時 |
| BR-45-04 | プログラム名記録 | 実行したユニットテストプロシージャ名を記録 | 常時 |

### 計算ロジック

- 結果判定: 無効オブジェクト数 = 0 → 成功(1)、> 0 → 失敗(0)、例外 → エラー(2)

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 結果保存 | QA_TEST_RUNS | INSERT | テスト実行結果の登録 |
| エラー更新 | QA_TEST_RUNS | UPDATE | ランタイムエラー情報の追加 |
| 履歴参照 | QA_TEST_RUNS | SELECT | ダッシュボード、詳細表示 |

### テーブル別操作詳細

#### QA_TEST_RUNS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全8列 | テスト結果情報 | 自動採番 |
| UPDATE | QATR_RUNTIME_ERROR | エラーバックトレース | エラー時 |
| SELECT | 全列 | JOIN qa_rules | 詳細表示用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | QATR_IDの重複 | シーケンス確認 |
| ORA-02290 | CHECK制約違反 | QATR_RESULTが0,1,2以外 | 結果値確認 |
| ORA-02291 | 参照整合性違反 | 存在しないQARU_ID | ルール存在確認 |

### リトライ仕様

テスト再実行で対応可能

## トランザクション仕様

- AUTONOMOUS_TRANSACTIONで結果を保存（テスト失敗時もCOMMIT）

## パフォーマンス要件

- QATR_DATEによる時系列検索が頻繁
- QATR_QARU_IDによるルール別検索
- インデックス設計が重要

## セキュリティ考慮事項

- テスト結果にはスキーマ名やエラー詳細が含まれる
- 実行者による監査証跡を保持

## 備考

- QA_TEST_RUN_INVALID_OBJECTSとの親子関係に注意
- ルール削除時は参照整合性エラーが発生

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_runs.sql (tab) | `src/ddl/tab/qa_test_runs.sql` | テーブルの8列の定義を確認 |
| 1-2 | qa_test_runs.sql (cons) | `src/ddl/cons/qa_test_runs.sql` | 主キー、外部キー、CHECK制約を確認 |

**読解のコツ**:
- 4-13行目でCREATE TABLE文が定義されている
- QATR_RESULTは0,1,2のいずれか（CHECK制約）
- QATR_QARU_IDがQA_RULESへの外部キー

#### Step 2: 操作関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_save_scheme_result関数（1038-1060行目）でのINSERT処理を確認 |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_result手続き（1072-1141行目）でのルーティングを確認 |
| 2-3 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_exception手続き（1143-1168行目）でのエラー記録を確認 |

**主要処理フロー**:
- **1055-1057行目**: INSERT INTO QA_TEST_RUNS（結果保存）
- **1110-1113行目**: f_save_scheme_result呼び出し（成功時）
- **1116-1119行目**: f_save_scheme_result呼び出し（失敗時）
- **1160-1163行目**: f_save_scheme_result呼び出し（エラー時）
- **1164-1166行目**: UPDATE QA_TEST_RUNS SET qatr_runtime_error

### プログラム呼び出し階層図

```
[ユニットテストパッケージ]
    │
    ├─ p_handle_test_result() [通常終了時]
    │      │
    │      └─ f_save_scheme_result() [各スキーマ分]
    │             └─ INSERT INTO QA_TEST_RUNS
    │
    └─ p_handle_test_exception() [例外発生時]
           │
           ├─ f_save_scheme_result()
           │      └─ INSERT INTO QA_TEST_RUNS
           │
           └─ UPDATE QA_TEST_RUNS (QATR_RUNTIME_ERROR)
```

### データフロー図

```
[入力]                    [テーブル]                    [出力]

テスト実行結果 ───▶ QA_TEST_RUNS ───▶ ダッシュボード表示
                        │                  タイムライン
                        │
                        ├─ FK ─▶ QA_RULES
                        │
                        └─ PK ─▶ QA_TEST_RUN_INVALID_OBJECTS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | DDL | テーブル定義 |
| qa_test_runs.sql | `src/ddl/cons/qa_test_runs.sql` | DDL | 制約定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 結果保存処理 |
| qa_faceted_search_dashboard_data_p0001_v.sql | `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql` | ソース | ダッシュボード用ビュー |
