# 機能設計書 46-無効オブジェクト格納

## 概要

本ドキュメントは、QUASTOシステムにおける無効オブジェクト格納機能の設計を記述する。QA_TEST_RUN_INVALID_OBJECTSテーブルにテスト実行で検出された無効オブジェクト（品質基準違反オブジェクト）の詳細を永続化するテーブル構造である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOのユニットテスト実行により、ルールに違反するオブジェクト（無効オブジェクト）が検出される。これらの違反詳細をテスト実行履歴と紐付けて保存することで、どのオブジェクトがどのルールに違反しているかを追跡し、修正作業の優先順位付けや進捗管理を可能にする。本テーブルはテスト実行履歴（QA_TEST_RUNS）の子テーブルとして機能する。

**機能の利用シーン**：本テーブルは、テスト失敗時の無効オブジェクト詳細表示、違反オブジェクト一覧のレポート出力、違反傾向分析に使用される。

**主要な処理内容**：
1. 無効オブジェクト情報の格納（INSERT）- 各失敗テスト結果に対して
2. 無効オブジェクト詳細の参照（SELECT）- 詳細画面表示
3. テスト実行履歴との紐付け（外部キー参照）

**関連システム・外部連携**：
- QA_TEST_RUNS（親テーブル - テスト実行履歴）
- APEXダッシュボード（Invalid Objects画面）

**権限による制御**：テーブルへの直接アクセスはDEFINER権限のパッケージ経由で行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | Invalid Objects | 主機能 | QA_TEST_RUN_INVALID_OBJECTSテーブルから無効オブジェクト詳細を取得・表示 |

## 機能種別

データ管理（テーブル定義）

## 入力仕様

### 入力パラメータ（テーブルカラム定義）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| QATO_ID | NUMBER | Yes | 主キー（自動採番） | NOT NULL |
| QATO_OBJECT_NAME | VARCHAR2(4000 CHAR) | Yes | 無効オブジェクト名 | NOT NULL |
| QATO_OBJECT_DETAILS | VARCHAR2(4000 CHAR) | Yes | オブジェクト詳細 | NOT NULL |
| QATO_QATR_ID | NUMBER | Yes | テスト実行ID（外部キー） | NOT NULL, FK to QA_TEST_RUNS |

### 入力データソース

- qa_unit_tests_pkg.p_save_scheme_faulty_objects

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QATO_ID | NUMBER | 主キー |
| QATO_OBJECT_NAME | VARCHAR2 | 違反オブジェクト名 |
| QATO_OBJECT_DETAILS | VARCHAR2 | 違反詳細情報 |
| QATO_QATR_ID | NUMBER | 関連テスト実行ID |

### 出力先

- データベーステーブル（QA_TEST_RUN_INVALID_OBJECTS）

## 処理フロー

### 処理シーケンス（保存時）

```
1. テスト結果処理
   └─ p_handle_test_resultから呼び出し
2. 失敗スキーマごとにループ
   └─ 無効オブジェクト数 > 0の場合
3. 無効オブジェクトごとにループ
   └─ 各無効オブジェクトに対してINSERT
4. オブジェクト情報格納
   └─ QA_TEST_RUN_INVALID_OBJECTSへのINSERT
```

### フローチャート

```mermaid
flowchart TD
    A[テスト結果処理] --> B{失敗スキーマあり?}
    B -->|No| C[終了]
    B -->|Yes| D[スキーマループ]
    D --> E{無効オブジェクトあり?}
    E -->|No| F[次のスキーマ]
    E -->|Yes| G[オブジェクトループ]
    G --> H[p_save_scheme_faulty_objects呼び出し]
    H --> I[QA_TEST_RUN_INVALID_OBJECTSにINSERT]
    I --> J{次のオブジェクト?}
    J -->|Yes| G
    J -->|No| F
    F --> K{次のスキーマ?}
    K -->|Yes| D
    K -->|No| C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | テスト結果紐付け | QATO_QATR_IDでQA_TEST_RUNSと紐付け | 常時 |
| BR-46-02 | 失敗時のみ記録 | テスト失敗（QATR_RESULT=0）時のみレコード作成 | テスト失敗時 |
| BR-46-03 | 詳細情報記録 | オブジェクト名と詳細の両方を必須記録 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 無効オブジェクト保存 | QA_TEST_RUN_INVALID_OBJECTS | INSERT | 違反オブジェクト情報の登録 |
| 詳細参照 | QA_TEST_RUN_INVALID_OBJECTS | SELECT | Invalid Objects画面での表示 |

### テーブル別操作詳細

#### QA_TEST_RUN_INVALID_OBJECTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全4列 | 無効オブジェクト情報 | 自動採番 |
| SELECT | 全列 | WHERE QATO_QATR_ID = :qatr_id | 詳細表示用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | QATO_IDの重複 | シーケンス確認 |
| ORA-02291 | 参照整合性違反 | 存在しないQATR_ID | 親レコード確認 |
| ORA-01400 | NOT NULL制約違反 | 必須列のNULL挿入 | 必須値の設定 |

### リトライ仕様

テスト再実行で対応可能

## トランザクション仕様

- 親テーブル（QA_TEST_RUNS）と同一トランザクション内で処理
- AUTONOMOUS_TRANSACTIONで結果を保存

## パフォーマンス要件

- QATO_QATR_IDによる検索が頻繁
- テスト失敗時に大量レコード発生の可能性

## セキュリティ考慮事項

- 無効オブジェクト情報にはオブジェクト名と詳細が含まれる
- 機密性の高い情報は含まれない想定

## 備考

- 親テーブル（QA_TEST_RUNS）削除時はカスケード削除される可能性あり
- 詳細フィールドの内容はルール定義に依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_run_invalid_objects.sql (tab) | `src/ddl/tab/qa_test_run_invalid_objects.sql` | テーブルの4列の定義を確認 |
| 1-2 | qa_test_run_invalid_objects.sql (cons) | `src/ddl/cons/qa_test_run_invalid_objects.sql` | 主キーと外部キー制約を確認 |

**読解のコツ**:
- 4-9行目でCREATE TABLE文が定義されている
- 4列のシンプルな構造
- QATO_QATR_IDがQA_TEST_RUNSへの外部キー

#### Step 2: 操作関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_save_scheme_faulty_objects手続き（1062-1070行目）でのINSERT処理を確認 |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_result手続き（1122-1132行目）での呼び出し箇所を確認 |

**主要処理フロー**:
- **1068-1069行目**: INSERT INTO QA_TEST_RUN_INVALID_OBJECTS
- **1122-1134行目**: 失敗スキーマの無効オブジェクトループとp_save_scheme_faulty_objects呼び出し

### プログラム呼び出し階層図

```
[ユニットテストパッケージ]
    │
    └─ p_handle_test_result()
           │
           └─ [失敗スキーマ×無効オブジェクトごと]
                  │
                  └─ p_save_scheme_faulty_objects()
                         │
                         └─ INSERT INTO QA_TEST_RUN_INVALID_OBJECTS
```

### データフロー図

```
[入力]                              [テーブル]                    [出力]

無効オブジェクト情報 ───▶ QA_TEST_RUN_INVALID_OBJECTS ───▶ Invalid Objects画面
(qa_rules_t)                       │
                                   │
                                   └─ FK ─▶ QA_TEST_RUNS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_test_run_invalid_objects.sql | `src/ddl/tab/qa_test_run_invalid_objects.sql` | DDL | テーブル定義 |
| qa_test_run_invalid_objects.sql | `src/ddl/cons/qa_test_run_invalid_objects.sql` | DDL | 制約定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 保存処理 |
