# 機能設計書 47-ルール型定義

## 概要

本ドキュメントは、QUASTOシステムにおけるルール型定義機能の設計を記述する。qa_rule_tおよびqa_rules_t型はルール情報とテスト結果を格納するためのオブジェクト型定義であり、ルール実行結果の受け渡しやバルク処理に使用される。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOでは、ルール実行結果をプロシージャ間でやり取りする必要がある。単純なスカラー変数では複数のルール属性やオブジェクト情報を効率的に扱えないため、オブジェクト型を定義してカプセル化する。これにより、ルールのメタ情報（ID、カテゴリ、エラーレベル等）とチェック対象オブジェクトの情報（スキーマ名、オブジェクト名、詳細等）を一体化して管理できる。

**機能の利用シーン**：本型定義は、ルール取得（f_get_rule）、ルール挿入（f_insert_rule）、テスト実行（p_test_rule）、テスト結果処理（p_handle_test_result）など、ルール関連のほぼすべての機能で使用される。

**主要な処理内容**：
1. qa_rule_t型：単一ルール/オブジェクト情報を格納するオブジェクト型
2. qa_rules_t型：qa_rule_tの配列（テーブル型）

**関連システム・外部連携**：
- qa_main_pkg（ルール操作パッケージ）
- qa_unit_tests_pkg（ユニットテスト実行パッケージ）
- ユニットテスト生成パッケージ

**権限による制御**：CREATE TYPE権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | 内部処理 | 画面からは直接参照されない。パッケージ内部で使用 |

## 機能種別

オブジェクト型

## 入力仕様

### 入力パラメータ（qa_rule_t属性）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| qaru_id | NUMBER | No | ルールID | - |
| qaru_category | VARCHAR2(10) | No | ルールカテゴリ | - |
| qaru_error_level | NUMBER | No | エラーレベル | - |
| qaru_error_message | VARCHAR2(4000) | No | エラーメッセージ | - |
| qaru_object_types | VARCHAR2(4000) | No | 対象オブジェクトタイプ | - |
| qaru_sql | CLOB | No | ルールSQL | - |
| scheme_name | VARCHAR2(100) | No | スキーマ名 | - |
| object_id | NUMBER | No | オブジェクトID | - |
| object_name | VARCHAR2(1000) | No | オブジェクト名 | - |
| object_details | VARCHAR2(2000) | No | オブジェクト詳細 | - |
| object_type | VARCHAR2(100) | No | オブジェクトタイプ | - |
| object_value | VARCHAR2(4000) | No | オブジェクト値 | - |
| object_updated_user | VARCHAR2(50) | No | 最終更新ユーザー | - |
| object_updated_date | DATE | No | 最終更新日 | - |
| apex_app_id | NUMBER | No | APEXアプリID | - |
| apex_page_id | NUMBER | No | APEXページID | - |

### コンストラクタ

| コンストラクタ | 用途 | パラメータ |
|---------------|------|----------|
| qa_rule_t(...) | クエリ用最小属性 | pi_qaru_id, pi_qaru_category, pi_qaru_error_level, pi_qaru_error_message, pi_qaru_object_types, pi_qaru_sql |
| qa_rule_t(...) | データベースオブジェクト用 | 上記 + pi_scheme_name, pi_object_id, pi_object_name, pi_object_details, pi_object_type, pi_object_value, pi_object_updated_user, pi_object_updated_date |
| qa_rule_t(...) | ユニットテスト用 | pi_scheme_name, pi_object_name, pi_object_details, pi_error_message |
| qa_rule_t(...) | APEXルール用 | 全属性（APEX関連含む） |

### 入力データソース

- qa_main_pkg.f_get_rule
- qa_main_pkg.f_insert_rule
- ルールSQLの実行結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_rule_t | OBJECT | 単一ルール/オブジェクト情報 |
| qa_rules_t | TABLE OF qa_rule_t | ルール/オブジェクトのコレクション |

### 出力先

- 呼び出し元プログラムへの戻り値
- パイプライン関数からのテーブル出力

## 処理フロー

### 処理シーケンス（コンストラクタ呼び出し時）

```
1. コンストラクタ呼び出し
   └─ 適切なコンストラクタを選択
2. 属性初期化
   └─ selfへの値設定
3. オブジェクト返却
   └─ 初期化されたオブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[コンストラクタ呼び出し] --> B{どのコンストラクタ?}
    B -->|最小属性| C[ルールメタ情報のみ設定]
    B -->|DBオブジェクト| D[ルール+オブジェクト情報設定]
    B -->|ユニットテスト| E[テスト結果情報のみ設定]
    B -->|APEX| F[全属性設定]
    C --> G[self返却]
    D --> G
    E --> G
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | 用途別コンストラクタ | 4種類のコンストラクタを用途に応じて使い分け | 常時 |
| BR-47-02 | NULL許容 | すべての属性はNULL許容 | 常時 |
| BR-47-03 | 型安全性 | 型定義によりデータ構造を保証 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|----------------|---------|------|
| 型作成 | qa_rule_t | CREATE TYPE | オブジェクト型の作成 |
| 型作成 | qa_rules_t | CREATE TYPE | テーブル型の作成 |

### 依存関係

- qa_rules_tはqa_rule_tに依存
- qa_main_pkg、qa_unit_tests_pkgから参照

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-06531 | コレクションエラー | 未初期化コレクション参照 | new演算子で初期化 |
| ORA-06532 | 下付き添字超過 | 範囲外アクセス | 境界チェック |

### リトライ仕様

該当なし（型定義）

## トランザクション仕様

型定義はDDLのためトランザクション管理対象外

## パフォーマンス要件

- PL/SQL配列としての効率的なメモリ使用
- バルク処理による高速化

## セキュリティ考慮事項

- qaru_sqlにはSQL文が格納される可能性があり、動的実行時に注意
- ルール情報はCREATE TYPE権限を持つユーザーのみ定義変更可能

## 備考

- FORCE句により既存オブジェクトへの依存を無視して再作成可能
- to_stringメンバー関数は未実装（空文字列を返却）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | オブジェクト型の属性とコンストラクタを確認 |
| 1-2 | qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | テーブル型の定義を確認 |

**読解のコツ**:
- **1-13行目**: ヘッダコメント（バージョン履歴）
- **14-38行目**: 属性定義（16属性）
- **40-49行目**: 最小属性コンストラクタ
- **51-68行目**: DBオブジェクト用コンストラクタ
- **70-77行目**: ユニットテスト用コンストラクタ
- **79-99行目**: APEXルール用コンストラクタ
- **101行目**: to_stringメンバー関数宣言
- **105-226行目**: TYPEボディ（コンストラクタ実装）

#### Step 2: 使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_get_rule関数でのqa_rule_t使用を確認 |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_resultでのqa_rules_t使用を確認 |

**主要処理フロー**:
- qa_main_pkg.f_get_rule（213-256行目）: SELECT結果をqa_rule_tに変換
- qa_unit_tests_pkg.p_handle_test_result（1072-1141行目）: qa_rules_tからループ処理

### プログラム呼び出し階層図

```
[型定義]
    │
    ├─ qa_rule_t (OBJECT)
    │      │
    │      ├─ コンストラクタ1: クエリ用最小
    │      ├─ コンストラクタ2: DBオブジェクト用
    │      ├─ コンストラクタ3: ユニットテスト用
    │      └─ コンストラクタ4: APEX用
    │
    └─ qa_rules_t (TABLE OF qa_rule_t)

[使用箇所]
    │
    ├─ qa_main_pkg.f_get_rule() → qa_rule_t
    ├─ qa_main_pkg.f_insert_rule() ← qa_rule_t
    ├─ qa_main_pkg.p_test_rule() → qa_rules_t
    └─ qa_unit_tests_pkg.p_handle_test_result() ← qa_rules_t
```

### データフロー図

```
[入力]                    [型]                     [出力]

ルール属性値 ───▶ qa_rule_t コンストラクタ ───▶ qa_rule_tオブジェクト
                        │
                        ▼
               qa_rules_t (コレクション)
                        │
                        ▼
               TABLE関数 / ループ処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | DDL | オブジェクト型定義 |
| qa_rules_t.sql | `src/plsql/typ/qa_rules_t.sql` | DDL | テーブル型定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | 型を使用するパッケージ |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 型を使用するパッケージ |
