# 機能設計書 48-実行中ルール型定義

## 概要

本ドキュメントは、QUASTOシステムにおける実行中ルール型定義機能の設計を記述する。qa_running_rule_tおよびqa_running_rules_t型はルール実行順序の管理と先行ルールの成功状態を追跡するためのオブジェクト型定義である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOのルールには先行ルール（predecessor）の概念があり、あるルールは先行ルールが成功した場合にのみ実行される依存関係を持つことができる。この実行順序と先行ルールの成功/失敗状態を追跡するために、実行中のルール状態を管理する型が必要となる。本型は、ルール実行エンジンがルールの実行可否を判定する際に使用される。

**機能の利用シーン**：本型定義は、ルール実行時の依存関係チェック、実行順序の決定、先行ルールの結果に基づくスキップ判定に使用される。

**主要な処理内容**：
1. qa_running_rule_t型：単一ルールの実行状態を格納するオブジェクト型
2. qa_running_rules_t型：qa_running_rule_tの配列（テーブル型）

**関連システム・外部連携**：
- qa_main_pkg（ルール実行処理）
- ルール依存関係グラフ

**権限による制御**：CREATE TYPE権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | 内部処理 | 画面からは直接参照されない。ルール実行エンジン内部で使用 |

## 機能種別

オブジェクト型

## 入力仕様

### 入力パラメータ（qa_running_rule_t属性）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| rule_number | VARCHAR2(10) | No | ルール番号 | - |
| predecessor | VARCHAR2(100) | No | 先行ルール番号（コロン区切り） | - |
| success_run | VARCHAR2(1) | No | 成功実行フラグ（Y/N） | - |
| row_val | NUMBER | No | 行番号/ソート値 | - |

### 入力データソース

- qa_main_pkg.p_test_rule内部処理
- ルール実行順序決定ロジック

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_running_rule_t | OBJECT | 単一ルールの実行状態 |
| qa_running_rules_t | TABLE OF qa_running_rule_t | 実行中ルールのコレクション |

### 出力先

- ルール実行エンジン内部での状態管理
- 実行可否判定ロジック

## 処理フロー

### 処理シーケンス（実行順序決定時）

```
1. ルール一覧取得
   └─ 有効なルールをqa_running_rules_tに格納
2. 依存関係解析
   └─ predecessor属性で先行ルールを特定
3. 実行可否判定
   └─ 先行ルールのsuccess_run='Y'かチェック
4. ルール実行
   └─ 実行可能なルールから順次実行
5. 結果更新
   └─ success_runを更新
```

### フローチャート

```mermaid
flowchart TD
    A[ルール一覧取得] --> B[qa_running_rules_t生成]
    B --> C[ルールループ]
    C --> D{predecessorあり?}
    D -->|No| E[実行可能]
    D -->|Yes| F{先行ルールsuccess_run='Y'?}
    F -->|Yes| E
    F -->|No| G[スキップ]
    E --> H[ルール実行]
    H --> I[success_run更新]
    I --> J{次のルール?}
    G --> J
    J -->|Yes| C
    J -->|No| K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | 先行ルール依存 | predecessorが設定されている場合、先行ルール成功後のみ実行 | predecessor IS NOT NULL |
| BR-48-02 | 成功フラグ | success_runは'Y'（成功）または'N'/NULL（失敗/未実行） | ルール実行後 |
| BR-48-03 | 実行順序 | row_valで実行順序を管理 | ソート時 |

### 計算ロジック

- 先行ルール成功判定: predecessor内の全ルールがsuccess_run='Y'の場合に実行可能

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|----------------|---------|------|
| 型作成 | qa_running_rule_t | CREATE TYPE | オブジェクト型の作成 |
| 型作成 | qa_running_rules_t | CREATE TYPE | テーブル型の作成 |

### 依存関係

- qa_running_rules_tはqa_running_rule_tに依存
- qa_main_pkgから参照

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-06531 | コレクションエラー | 未初期化コレクション参照 | new演算子で初期化 |
| ORA-06532 | 下付き添字超過 | 範囲外アクセス | 境界チェック |

### リトライ仕様

該当なし（型定義）

## トランザクション仕様

型定義はDDLのためトランザクション管理対象外

## パフォーマンス要件

- ルール数に応じたメモリ使用
- 依存関係グラフのトポロジカルソート効率

## セキュリティ考慮事項

- ルール実行順序の操作による意図しないルールスキップに注意

## 備考

- シンプルな4属性構成
- コンストラクタは定義されていない（デフォルトコンストラクタ使用）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_running_rule_t.sql | `src/plsql/typ/qa_running_rule_t.sql` | オブジェクト型の4属性を確認 |
| 1-2 | qa_running_rules_t.sql | `src/plsql/typ/qa_running_rules_t.sql` | テーブル型の定義を確認 |

**読解のコツ**:
- **1-11行目**: ヘッダコメント（バージョン履歴）
- **13-19行目**: 属性定義（4属性）
- シンプルな構造でコンストラクタは未定義

#### Step 2: 使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ルール実行順序決定でのqa_running_rules_t使用を確認 |

### プログラム呼び出し階層図

```
[型定義]
    │
    ├─ qa_running_rule_t (OBJECT)
    │      │
    │      ├─ rule_number: ルール識別
    │      ├─ predecessor: 先行ルール
    │      ├─ success_run: 成功フラグ
    │      └─ row_val: ソート値
    │
    └─ qa_running_rules_t (TABLE OF qa_running_rule_t)

[使用箇所]
    │
    └─ qa_main_pkg.p_test_rule() → qa_running_rules_t
           └─ 依存関係解析 → 実行可否判定
```

### データフロー図

```
[入力]                        [型]                         [出力]

ルール定義 ───▶ qa_running_rule_t生成 ───▶ 実行順序リスト
(QA_RULES)            │
                      ▼
           qa_running_rules_t (コレクション)
                      │
                      ▼
           依存関係解析 → 実行/スキップ判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_running_rule_t.sql | `src/plsql/typ/qa_running_rule_t.sql` | DDL | オブジェクト型定義 |
| qa_running_rules_t.sql | `src/plsql/typ/qa_running_rules_t.sql` | DDL | テーブル型定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | 型を使用するパッケージ |
