# 機能設計書 49-スキーマオブジェクト量型定義

## 概要

本ドキュメントは、QUASTOシステムにおけるスキーマオブジェクト量型定義機能の設計を記述する。qa_scheme_object_amount_tおよびqa_scheme_object_amounts_t型はスキーマごとの無効オブジェクト数を集計して格納するためのオブジェクト型定義である。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOのルール実行では、複数のスキーマに対して一括でテストを行い、各スキーマごとに何件の違反オブジェクト（無効オブジェクト）が検出されたかを集計する必要がある。この集計結果をプロシージャ間で効率的に受け渡すために、スキーマ名と違反オブジェクト数のペアを格納するオブジェクト型を定義する。

**機能の利用シーン**：本型定義は、ルールテスト実行後の結果集計、テスト結果ハンドラへの結果引き渡し、ダッシュボードでのスキーマ別結果表示に使用される。

**主要な処理内容**：
1. qa_scheme_object_amount_t型：単一スキーマの無効オブジェクト数を格納するオブジェクト型
2. qa_scheme_object_amounts_t型：qa_scheme_object_amount_tの配列（テーブル型）

**関連システム・外部連携**：
- qa_main_pkg.p_test_rule（OUT parameter）
- qa_unit_tests_pkg.p_handle_test_result（IN parameter）

**権限による制御**：CREATE TYPE権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 間接参照 | スキーマ別結果集計の基盤データ |

## 機能種別

オブジェクト型

## 入力仕様

### 入力パラメータ（qa_scheme_object_amount_t属性）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| scheme_name | VARCHAR2(100) | No | スキーマ名 | - |
| object_amount | NUMBER | No | 無効オブジェクト数 | - |

### コンストラクタ

| コンストラクタ | 用途 | パラメータ |
|---------------|------|----------|
| qa_scheme_object_amount_t(pi_scheme_name, pi_object_amount) | 標準コンストラクタ | pi_scheme_name: VARCHAR2, pi_object_amount: NUMBER |

### 入力データソース

- qa_main_pkg.p_test_rule内部集計処理
- ルールSQL実行結果のCOUNT

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_scheme_object_amount_t | OBJECT | 単一スキーマの無効オブジェクト数 |
| qa_scheme_object_amounts_t | TABLE OF qa_scheme_object_amount_t | スキーマ別無効オブジェクト数のコレクション |

### 出力先

- qa_unit_tests_pkg.p_handle_test_result への引き渡し
- テスト結果の成功/失敗判定

## 処理フロー

### 処理シーケンス（集計時）

```
1. スキーマループ
   └─ 各テスト対象スキーマに対して
2. ルールSQL実行
   └─ 無効オブジェクト検出クエリを実行
3. 結果カウント
   └─ 検出された無効オブジェクト数をカウント
4. 型インスタンス生成
   └─ qa_scheme_object_amount_tコンストラクタ呼び出し
5. コレクション追加
   └─ qa_scheme_object_amounts_tに追加
```

### フローチャート

```mermaid
flowchart TD
    A[テスト実行開始] --> B[qa_scheme_object_amounts_t初期化]
    B --> C[スキーマループ]
    C --> D[ルールSQL実行]
    D --> E[無効オブジェクト数カウント]
    E --> F[qa_scheme_object_amount_tコンストラクタ]
    F --> G[コレクションに追加]
    G --> H{次のスキーマ?}
    H -->|Yes| C
    H -->|No| I[p_handle_test_resultに渡す]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | 成功判定 | object_amount=0の場合、そのスキーマは成功 | テスト結果判定時 |
| BR-49-02 | 失敗判定 | object_amount>0の場合、そのスキーマは失敗 | テスト結果判定時 |
| BR-49-03 | 全スキーマ集計 | テスト対象の全スキーマについて集計 | 常時 |

### 計算ロジック

- 成功/失敗判定: object_amount = 0 → 成功、object_amount > 0 → 失敗

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|----------------|---------|------|
| 型作成 | qa_scheme_object_amount_t | CREATE TYPE | オブジェクト型の作成 |
| 型作成 | qa_scheme_object_amounts_t | CREATE TYPE | テーブル型の作成 |

### 依存関係

- qa_scheme_object_amounts_tはqa_scheme_object_amount_tに依存
- qa_main_pkg、qa_unit_tests_pkgから参照

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-06531 | コレクションエラー | 未初期化コレクション参照 | new演算子で初期化 |
| ORA-06532 | 下付き添字超過 | 範囲外アクセス | 境界チェック |

### リトライ仕様

該当なし（型定義）

## トランザクション仕様

型定義はDDLのためトランザクション管理対象外

## パフォーマンス要件

- スキーマ数に応じたメモリ使用
- テーブル関数での効率的なアクセス

## セキュリティ考慮事項

- スキーマ名情報を含むが、機密性は低い

## 備考

- シンプルな2属性構成
- コンストラクタが1つ定義されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_scheme_object_amount_t.sql | `src/plsql/typ/qa_scheme_object_amount_t.sql` | オブジェクト型の2属性とコンストラクタを確認 |
| 1-2 | qa_scheme_object_amounts_t.sql | `src/plsql/typ/qa_scheme_object_amounts_t.sql` | テーブル型の定義を確認 |

**読解のコツ**:
- **1-11行目**: ヘッダコメント（バージョン履歴）
- **13-16行目**: 属性定義（2属性）
- **18-23行目**: コンストラクタ宣言
- **27-42行目**: TYPEボディ（コンストラクタ実装）

#### Step 2: 使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_resultでのqa_scheme_object_amounts_t使用を確認 |

**主要処理フロー**:
- **1072-1141行目**: p_handle_test_resultでpi_scheme_objectsからループ
- **1103-1137行目**: scheme_nameとobject_amountを使用した成功/失敗判定

### プログラム呼び出し階層図

```
[型定義]
    │
    ├─ qa_scheme_object_amount_t (OBJECT)
    │      │
    │      ├─ scheme_name: スキーマ名
    │      └─ object_amount: 無効オブジェクト数
    │
    └─ qa_scheme_object_amounts_t (TABLE OF qa_scheme_object_amount_t)

[使用箇所]
    │
    ├─ qa_main_pkg.p_test_rule()
    │      └─ OUT po_scheme_objects → qa_scheme_object_amounts_t
    │
    └─ qa_unit_tests_pkg.p_handle_test_result()
           └─ IN pi_scheme_objects ← qa_scheme_object_amounts_t
                  └─ ループ処理 → 成功/失敗判定
```

### データフロー図

```
[入力]                           [型]                           [出力]

ルール実行結果 ───▶ qa_scheme_object_amount_t生成 ───▶ 成功/失敗判定
(COUNT集計)              │
                         ▼
              qa_scheme_object_amounts_t (コレクション)
                         │
                         ▼
              p_handle_test_result → QA_TEST_RUNS保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_scheme_object_amount_t.sql | `src/plsql/typ/qa_scheme_object_amount_t.sql` | DDL | オブジェクト型定義 |
| qa_scheme_object_amounts_t.sql | `src/plsql/typ/qa_scheme_object_amounts_t.sql` | DDL | テーブル型定義 |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | 型を使用するパッケージ（OUT） |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 型を使用するパッケージ（IN） |
