# 機能設計書 50-テスト結果型定義

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果型定義機能の設計を記述する。qa_test_results_row_tおよびqa_test_results_table_t型はテスト結果の行データを格納するためのオブジェクト型定義であり、ダッシュボードやレポートでのテスト結果表示に使用される。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOのダッシュボードでは、テスト実行結果を一覧形式で表示する必要がある。QA_TEST_RUNSテーブルとQA_RULESテーブルを結合した結果を効率的に取得・処理するために、結合結果を格納するオブジェクト型を定義する。これにより、パイプライン関数からテーブルとして結果を返却し、SQLで直接問い合わせることが可能になる。

**機能の利用シーン**：本型定義は、ダッシュボードのテスト結果一覧表示、フィルタリング・検索機能、レポート出力に使用される。

**主要な処理内容**：
1. qa_test_results_row_t型：単一テスト結果行を格納するオブジェクト型
2. qa_test_results_table_t型：qa_test_results_row_tの配列（テーブル型）

**関連システム・外部連携**：
- APEXダッシュボード（テスト結果表示）
- ファセット検索機能
- Interactive Report

**権限による制御**：CREATE TYPE権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 主機能 | テスト結果一覧のデータソース |
| - | Reports | 参照画面 | レポート出力用データ |

## 機能種別

オブジェクト型

## 入力仕様

### 入力パラメータ（qa_test_results_row_t属性）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| qatr_id | NUMBER | No | テスト実行ID | - |
| qatr_date | DATE | No | テスト実行日時 | - |
| qatr_scheme_name | VARCHAR2(100) | No | スキーマ名 | - |
| qatr_category | VARCHAR2(100) | No | ルールカテゴリ | - |
| qatr_result | VARCHAR2(20) | No | テスト結果（文字列表現） | - |
| qaru_name | VARCHAR2(100) | No | ルール名 | - |
| qaru_layer | VARCHAR2(20) | No | ルールレイヤー | - |
| qaru_error_level | VARCHAR2(20) | No | エラーレベル（文字列表現） | - |
| qaru_is_active | VARCHAR2(10) | No | 有効フラグ（文字列表現） | - |
| qaru_client_name | VARCHAR2(4000) | No | クライアント名 | - |
| qatr_program_name | VARCHAR2(500) | No | テストプログラム名 | - |

### 入力データソース

- QA_TEST_RUNS テーブル
- QA_RULES テーブル
- 結合クエリの結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_test_results_row_t | OBJECT | 単一テスト結果行 |
| qa_test_results_table_t | TABLE OF qa_test_results_row_t | テスト結果行のコレクション |

### 出力先

- APEXダッシュボードのInteractive Report
- パイプライン関数からのテーブル出力

## 処理フロー

### 処理シーケンス（データ取得時）

```
1. 結合クエリ実行
   └─ QA_TEST_RUNS と QA_RULES を結合
2. 結果変換
   └─ 各行をqa_test_results_row_tに変換
3. コレクション構築
   └─ qa_test_results_table_tに追加
4. テーブル返却
   └─ パイプライン関数からTABLE()で返却
```

### フローチャート

```mermaid
flowchart TD
    A[クエリ実行] --> B[QA_TEST_RUNS × QA_RULES結合]
    B --> C[行ループ]
    C --> D[qa_test_results_row_t生成]
    D --> E[コレクションに追加]
    E --> F{次の行?}
    F -->|Yes| C
    F -->|No| G[TABLE関数で返却]
    G --> H[APEXダッシュボード表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | 結果文字列変換 | qatr_resultは数値から'Success'/'Failure'/'Error'に変換 | 表示時 |
| BR-50-02 | エラーレベル変換 | qaru_error_levelは数値から'Error'/'Warning'/'Info'に変換 | 表示時 |
| BR-50-03 | 有効フラグ変換 | qaru_is_activeは数値から'Yes'/'No'に変換 | 表示時 |
| BR-50-04 | 日時降順ソート | qatr_dateの降順でソート | デフォルト |

### 計算ロジック

- 結果変換: 0 → 'Failure', 1 → 'Success', 2 → 'Error'
- エラーレベル変換: 1 → 'Error', 2 → 'Warning', 4 → 'Info'

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|----------------|---------|------|
| 型作成 | qa_test_results_row_t | CREATE TYPE | オブジェクト型の作成 |
| 型作成 | qa_test_results_table_t | CREATE TYPE | テーブル型の作成 |

### 依存関係

- qa_test_results_table_tはqa_test_results_row_tに依存
- ビューやパイプライン関数から参照

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-06531 | コレクションエラー | 未初期化コレクション参照 | new演算子で初期化 |
| ORA-06532 | 下付き添字超過 | 範囲外アクセス | 境界チェック |

### リトライ仕様

該当なし（型定義）

## トランザクション仕様

型定義はDDLのためトランザクション管理対象外

## パフォーマンス要件

- テスト結果数に応じたメモリ使用
- ページネーション対応でのパフォーマンス最適化

## セキュリティ考慮事項

- テスト結果にはスキーマ名やルール名が含まれる
- 権限を持つユーザーのみがダッシュボードにアクセス可能

## 備考

- 11属性構成（表示用に最適化）
- コンストラクタは定義されていない（デフォルトコンストラクタ使用）
- すべての属性はVARCHAR2型（表示用に文字列変換済み）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | オブジェクト型の11属性を確認 |
| 1-2 | qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | テーブル型の定義を確認 |

**読解のコツ**:
- **1-11行目**: ヘッダコメント（バージョン履歴）
- **13-25行目**: 属性定義（11属性）
- すべてVARCHAR2型で表示用に最適化されている
- qatr_resultなどは数値ではなく文字列表現

#### Step 2: 使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_faceted_search_dashboard_data_p0001_v.sql | `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql` | ダッシュボード用ビューでの使用を確認 |

### プログラム呼び出し階層図

```
[型定義]
    │
    ├─ qa_test_results_row_t (OBJECT)
    │      │
    │      ├─ qatr_id: テスト実行ID
    │      ├─ qatr_date: 実行日時
    │      ├─ qatr_scheme_name: スキーマ名
    │      ├─ qatr_category: カテゴリ
    │      ├─ qatr_result: 結果（文字列）
    │      ├─ qaru_name: ルール名
    │      ├─ qaru_layer: レイヤー
    │      ├─ qaru_error_level: エラーレベル（文字列）
    │      ├─ qaru_is_active: 有効フラグ（文字列）
    │      ├─ qaru_client_name: クライアント名
    │      └─ qatr_program_name: プログラム名
    │
    └─ qa_test_results_table_t (TABLE OF qa_test_results_row_t)

[使用箇所]
    │
    ├─ ファセット検索ビュー → qa_test_results_table_t
    │
    └─ APEXダッシュボード → Interactive Report
```

### データフロー図

```
[入力]                              [型]                              [出力]

QA_TEST_RUNS ──┐
               ├──▶ qa_test_results_row_t生成 ──▶ APEXダッシュボード
QA_RULES ──────┘             │
     (結合)                  ▼
                    qa_test_results_table_t (コレクション)
                             │
                             ▼
                    TABLE関数 / ビュー参照
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | DDL | オブジェクト型定義 |
| qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | DDL | テーブル型定義 |
| qa_faceted_search_dashboard_data_p0001_v.sql | `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql` | ソース | ダッシュボード用ビュー |
