# 機能設計書 51-QUASTOインストール

## 概要

本ドキュメントは、QUASTOの全オブジェクトをOracleデータベースにインストールする機能について定義する。install.sql および install_quasto_objects.sql を使用し、QUASTOの基盤となるテーブル、シーケンス、型定義、ビュー、パッケージ、トリガーを作成する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOは、Oracle APEXアプリケーションおよびPL/SQLコードの品質管理を行うためのツールである。データベース内にQUASTOを利用するためには、まずルール定義を格納するテーブル、ルール実行のためのPL/SQLパッケージ、データ型定義などの基盤オブジェクトをインストールする必要がある。本機能は、QUASTOの初期セットアップとして必須となるインストール処理を提供する。

**機能の利用シーン**：新規のOracleデータベース環境にQUASTOを導入する際、または既存環境をアップグレードする際に使用される。DBA（データベース管理者）や開発者が SQL*Plus または SQLcl からスクリプトを実行することで、必要なオブジェクトが一括でインストールされる。

**主要な処理内容**：
1. 前提条件チェック（必要な権限の確認）
2. 定数パッケージ（qa_constant_pkg）の動的生成
3. QA_RULESテーブル、QA_IMPORT_FILESテーブルの作成
4. インデックス、制約の作成
5. シーケンス（QARU_SEQ、QAIF_SEQ）の作成
6. 型定義（varchar2_tab_t、qa_rule_t、qa_rules_t 等）の作成
7. ビュー（qa_predecessor_order_v、qa_scheme_names_for_testing_v）の作成
8. PL/SQLパッケージ（qa_logger_pkg、qa_utils_pkg、qa_main_pkg、qa_api_pkg、qa_export_import_rules_pkg）の作成
9. トリガー（qaru_iu_trg、qaif_i_trg）の作成
10. オブジェクトの再コンパイル
11. インストール結果の検証

**関連システム・外部連携**：オプションとしてutPLSQL（ユニットテストフレームワーク）およびOracle APEX（APEXアプリケーション）との連携オブジェクトをインストールできる。これらはインストール時の引数で制御される。

**権限による制御**：インストールを実行するユーザーには、CREATE SESSION, CREATE TABLE, CREATE VIEW, CREATE SEQUENCE, CREATE PROCEDURE, CREATE TRIGGER, CREATE TYPE, CREATE JOB, CREATE PUBLIC SYNONYM の権限が必要である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | Login Page | 遷移先機能 | ログイン成功後にQUASTOダッシュボードへ遷移 |

## 機能種別

データ連携（DDLスクリプト実行）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 引数1（utPLSQL） | NUMBER | Yes | utPLSQL連携オブジェクトをインストールするか（1=Yes, 0=No） | 0または1 |
| 引数2（APEX） | NUMBER | Yes | APEX連携オブジェクトをインストールするか（1=Yes, 0=No） | 0または1 |
| 引数3（Jenkins） | NUMBER | Yes | Jenkins連携オブジェクトをインストールするか（1=Yes, 0=No） | 0または1 |
| 引数4（Logger） | NUMBER | Yes | Logger機能をインストールするか（1=Yes, 0=No） | 0または1 |

### 入力データソース

- SQL*Plus / SQLcl からのコマンドライン実行
- 引数は `@install 1 1 0 1` の形式で指定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| install.log | ファイル | インストール処理のログ出力 |
| QA_RULES | テーブル | ルール定義格納テーブル |
| QA_IMPORT_FILES | テーブル | インポートファイル格納テーブル |
| qa_constant_pkg | パッケージ | 設定定数パッケージ |
| qa_logger_pkg | パッケージ | ロギングパッケージ |
| qa_utils_pkg | パッケージ | ユーティリティパッケージ |
| qa_main_pkg | パッケージ | メイン処理パッケージ |
| qa_api_pkg | パッケージ | API公開パッケージ |
| qa_export_import_rules_pkg | パッケージ | エクスポート/インポートパッケージ |

### 出力先

- Oracleデータベース（スキーマオブジェクト）
- ファイルシステム（install.log）

## 処理フロー

### 処理シーケンス

```
1. install.sql 実行開始
   └─ src/install_objects.sql を呼び出し

2. 引数解析
   └─ 4つの引数（utPLSQL, APEX, Jenkins, Logger）を解析し、実行スクリプトを決定

3. 前提条件チェック（install_prereqs.sql）
   └─ 必要な権限（CREATE TABLE, CREATE PROCEDURE等）が付与されているか確認
   └─ 権限不足の場合はエラー終了

4. 定数パッケージ生成（install_constant_package.sql）
   └─ qa_constant_pkg を動的に生成（バージョン、フラグを埋め込み）

5. QUASTOオブジェクトインストール（install_quasto_objects.sql）
   └─ テーブル作成（QA_RULES, QA_IMPORT_FILES）
   └─ インデックス作成
   └─ 制約作成
   └─ シーケンス作成
   └─ 型定義作成
   └─ ビュー作成
   └─ パッケージ作成
   └─ トリガー作成
   └─ 権限付与

6. オブジェクト再コンパイル（recompile_quasto_objects.sql）
   └─ 依存関係を考慮してオブジェクトを再コンパイル

7. インストール検証
   └─ user_errors を確認し、エラーがないか検証
   └─ 結果をログ出力
```

### フローチャート

```mermaid
flowchart TD
    A[install.sql 実行開始] --> B[引数解析]
    B --> C{引数は有効?}
    C -->|No| D[エラーメッセージ表示]
    C -->|Yes| E[前提条件チェック]
    E --> F{権限OK?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[定数パッケージ生成]
    H --> I[QUASTOオブジェクトインストール]
    I --> J[テーブル作成]
    J --> K[インデックス・制約作成]
    K --> L[シーケンス作成]
    L --> M[型定義作成]
    M --> N[ビュー作成]
    N --> O[パッケージ作成]
    O --> P[トリガー作成]
    P --> Q[権限付与]
    Q --> R[オブジェクト再コンパイル]
    R --> S[インストール検証]
    S --> T{エラーあり?}
    T -->|Yes| U[エラーメッセージ表示]
    T -->|No| V[成功メッセージ表示]
    U --> W[終了]
    V --> W
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-1 | 権限事前チェック | インストール前に必要な権限が付与されているか確認する | インストール開始時 |
| BR-51-2 | 既存オブジェクト確認 | テーブル等が既に存在する場合は作成をスキップしWARNINGを出力 | オブジェクト作成時 |
| BR-51-3 | バージョン埋め込み | qa_constant_pkg にバージョン情報を埋め込む | 定数パッケージ生成時 |
| BR-51-4 | 公開権限付与 | qa_api_pkg と qa_rule_t に対して public への execute 権限を付与 | インストール完了時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テーブル作成 | QA_RULES | DDL (CREATE TABLE) | ルール定義格納テーブルを作成 |
| テーブル作成 | QA_IMPORT_FILES | DDL (CREATE TABLE) | インポートファイル格納テーブルを作成 |
| インデックス作成 | QA_RULES | DDL (CREATE INDEX) | 検索高速化用インデックス作成 |
| シーケンス作成 | QARU_SEQ | DDL (CREATE SEQUENCE) | QA_RULES用ID採番シーケンス |
| シーケンス作成 | QAIF_SEQ | DDL (CREATE SEQUENCE) | QA_IMPORT_FILES用ID採番シーケンス |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | qaru_id | NUMBER NOT NULL | 主キー |
| CREATE TABLE | qaru_rule_number | VARCHAR2(20 CHAR) NOT NULL | ルール番号 |
| CREATE TABLE | qaru_client_name | VARCHAR2(100 CHAR) NOT NULL | クライアント名 |
| CREATE TABLE | qaru_name | VARCHAR2(100 CHAR) NOT NULL | ルール名 |
| CREATE TABLE | qaru_category | VARCHAR2(100 CHAR) NOT NULL | カテゴリ（APEX/DDL/DATA） |
| CREATE TABLE | qaru_sql | CLOB NOT NULL | ルールSQL |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-20000 | カスタムエラー | 必要な権限が不足している | DBAに権限付与を依頼 |
| ORA-00955 | 既存オブジェクト | 同名のテーブル/オブジェクトが既に存在 | WARNING表示（スキップ） |
| ORA-04031 | メモリ不足 | 共有プールが不足 | 共有プールサイズを拡張 |

### リトライ仕様

リトライは不要。エラー発生時は原因を解消した後に再実行。

## トランザクション仕様

DDL操作のため、各DDL文の実行後に暗黙的コミットが発生する。ロールバックは不可。

## パフォーマンス要件

インストール処理は初期セットアップ時のみ実行されるため、特にパフォーマンス要件はない。通常、数分以内に完了する。

## セキュリティ考慮事項

- インストールを実行するユーザーには高い権限が必要なため、DBA権限を持つユーザーまたは専用のインストールユーザーで実行することを推奨
- qa_api_pkg に public execute 権限が付与されるため、必要に応じてアクセス制御を検討
- インストールログ（install.log）には機密情報が含まれる可能性があるため、適切に管理

## 備考

- utPLSQL連携およびAPEX連携は別途 install_utplsql_objects.sql、install_apex_objects.sql で実行される
- バージョン情報は qa_constant_pkg.gc_quasto_version で参照可能
- アンインストールは uninstall.sql で実行可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install.sql | `install.sql` | インストールの起点。install_objects.sqlを呼び出すのみ |
| 1-2 | install_objects.sql | `src/install_objects.sql` | メインのインストールスクリプト。引数解析と各スクリプトの呼び出し順序を理解 |

**主要処理フロー**:
1. **27-48行目**: 引数の説明（PROMPT文）
2. **59-89行目**: 引数解析PL/SQLブロック。引数値に応じて実行するスクリプト名を決定
3. **116-128行目**: 各インストールスクリプトの呼び出し順序

**読解のコツ**: SQL*Plusの`@@`は相対パス、`@`は現在ディレクトリからのパスでスクリプトを実行する。`~1`、`~2`などはSQL*Plusの置換変数（引数）を表す。

#### Step 2: 前提条件チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | install_prereqs.sql | `src/scripts/install_prereqs.sql` | 必要な権限チェックロジック |

**主要処理フロー**:
- **6-9行目**: 必要な権限リスト（CREATE SESSION, CREATE TABLE等）を連想配列に格納
- **25-41行目**: session_privsビューから現在のユーザー権限を取得し、必要な権限と比較
- **47-49行目**: 権限不足の場合はraise_application_errorでエラー終了

#### Step 3: 定数パッケージ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | install_constant_package.sql | `src/scripts/install_constant_package.sql` | 動的パッケージ生成 |

**主要処理フロー**:
- **10-14行目**: 引数（utPLSQL, APEX, Jenkins, Logger フラグ）の取得
- **25-61行目**: CREATE OR REPLACE PACKAGE文を文字列として構築
- **63行目**: EXECUTE IMMEDIATEで動的にパッケージを作成

#### Step 4: QUASTOオブジェクトインストールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | install_quasto_objects.sql | `src/install_quasto_objects.sql` | メインインストール処理 |

**主要処理フロー**:
- **14-19行目**: テーブル作成スクリプトの呼び出し
- **40-61行目**: 型定義（qa_rule_t等）の作成
- **72-84行目**: PL/SQLパッケージの作成
- **88-91行目**: トリガーの作成
- **96-97行目**: PUBLIC権限の付与

#### Step 5: 個別DDLスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | QA_RULESテーブル定義 |

**主要処理フロー**:
- **30-34行目**: user_tablesをチェックして既存テーブルの有無を確認
- **36-38行目**: 存在しない場合のみCREATE TABLE実行
- **40-60行目**: 各カラムへのコメント追加

### プログラム呼び出し階層図

```
install.sql
    │
    └─ src/install_objects.sql
           │
           ├─ src/scripts/install_prereqs.sql（前提条件チェック）
           │
           ├─ src/scripts/install_constant_package.sql（定数パッケージ生成）
           │
           ├─ src/install_quasto_objects.sql（QUASTOオブジェクト）
           │      ├─ src/ddl/tab/qa_rules.sql
           │      ├─ src/ddl/tab/qa_import_files.sql
           │      ├─ src/ddl/ind/*.sql
           │      ├─ src/ddl/cons/*.sql
           │      ├─ src/ddl/seq/*.sql
           │      ├─ src/plsql/typ/*.sql
           │      ├─ src/plsql/vw/*.sql
           │      ├─ src/plsql/pkg/*.sql
           │      └─ src/plsql/trg/*.sql
           │
           └─ src/scripts/recompile_quasto_objects.sql（再コンパイル）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数 ───▶ install_objects.sql ───▶ Oracleデータベース
  (1 1 0 1)                    │                     ├─ QA_RULES
                               │                     ├─ QA_IMPORT_FILES
                               ▼                     ├─ qa_constant_pkg
                        引数解析・権限チェック        ├─ qa_api_pkg
                               │                     └─ その他オブジェクト
                               ▼
                        DDLスクリプト実行 ────────▶ install.log
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install.sql | `install.sql` | スクリプト | インストールエントリーポイント |
| install_objects.sql | `src/install_objects.sql` | スクリプト | メインインストール処理 |
| install_prereqs.sql | `src/scripts/install_prereqs.sql` | スクリプト | 前提条件チェック |
| install_constant_package.sql | `src/scripts/install_constant_package.sql` | スクリプト | 定数パッケージ動的生成 |
| install_quasto_objects.sql | `src/install_quasto_objects.sql` | スクリプト | QUASTOオブジェクトインストール |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | QA_RULESテーブル定義 |
| qa_import_files.sql | `src/ddl/tab/qa_import_files.sql` | DDL | QA_IMPORT_FILESテーブル定義 |
| recompile_quasto_objects.sql | `src/scripts/recompile_quasto_objects.sql` | スクリプト | オブジェクト再コンパイル |
| qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | PL/SQL | API公開パッケージ |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PL/SQL | メイン処理パッケージ |
