# 機能設計書 52-utPLSQLオブジェクトインストール

## 概要

本ドキュメントは、utPLSQL連携用オブジェクトをOracleデータベースにインストールする機能について定義する。install_utplsql_objects.sql を使用し、ユニットテスト結果を管理するためのテーブル、シーケンス、トリガー、パッケージ、およびスケジューラジョブを作成する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOはutPLSQL（Oracle Database用のユニットテストフレームワーク）と連携して、定義されたルールに基づくユニットテストを自動実行する機能を提供する。この連携を実現するためには、テスト結果の格納テーブル、テスト実行履歴の管理テーブル、無効オブジェクトの記録テーブル、およびテスト実行を制御するパッケージ・スケジューラジョブをインストールする必要がある。本機能は、utPLSQL連携に必要なすべてのオブジェクトを一括でインストールする。

**機能の利用シーン**：QUASTOの基本インストール時に引数でutPLSQL連携を有効（1）にした場合、または個別にutPLSQL連携オブジェクトを追加インストールする場合に使用される。ルールベースの品質チェックをutPLSQLのユニットテストとして自動実行したい環境で必要となる。

**主要な処理内容**：
1. QA_TEST_RESULTSテーブルの作成（XMLテスト結果格納用）
2. QA_TEST_RUNSテーブルの作成（テスト実行履歴格納用）
3. QA_TEST_RUN_INVALID_OBJECTSテーブルの作成（無効オブジェクト格納用）
4. 各テーブルのインデックス作成
5. 各テーブルの制約作成
6. シーケンス（QATR_SEQ、QATO_SEQ、QATRU_SEQ）の作成
7. トリガー（qatr_i_trg、qato_i_trg、qatru_i_trg）の作成
8. qa_unit_tests_pkg パッケージの作成
9. CRONJOB_RUN_UNIT_TESTS スケジューラジョブの作成

**関連システム・外部連携**：utPLSQL フレームワークとの連携。utPLSQL がインストールされている環境で、QUASTO が生成するユニットテストパッケージを実行し、結果をXML形式で取得・保存する。

**権限による制御**：CREATE JOB 権限が必要。スケジューラジョブの有効化・実行には適切なジョブ管理権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 結果表示画面 | QA_TEST_RUNSテーブルからテスト実行履歴データを表示 |
| 3 | Unit Test Generation | 主画面 | ユニットテストパッケージの生成・削除 |
| 6 | Test Result Files | 結果表示画面 | QA_TEST_RESULTSからテスト結果XMLを取得・表示 |
| 10 | Config Scheduler Job | 設定画面 | スケジューラジョブの有効/無効設定 |

## 機能種別

データ連携（DDLスクリプト実行）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | install_objects.sql から呼び出される場合は引数不要 | - |

### 入力データソース

- SQL*Plus / SQLcl からのスクリプト実行
- install_objects.sql からの自動呼び出し（引数1=1の場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QA_TEST_RESULTS | テーブル | utPLSQLテスト結果XMLを格納 |
| QA_TEST_RUNS | テーブル | テスト実行履歴を格納 |
| QA_TEST_RUN_INVALID_OBJECTS | テーブル | 検出された無効オブジェクトを格納 |
| QATR_SEQ | シーケンス | QA_TEST_RESULTS用ID採番 |
| QATO_SEQ | シーケンス | QA_TEST_RUN_INVALID_OBJECTS用ID採番 |
| QATRU_SEQ | シーケンス | QA_TEST_RUNS用ID採番 |
| qa_unit_tests_pkg | パッケージ | ユニットテスト実行・管理パッケージ |
| CRONJOB_RUN_UNIT_TESTS | スケジューラジョブ | 定期実行用ジョブ |

### 出力先

- Oracleデータベース（スキーマオブジェクト）

## 処理フロー

### 処理シーケンス

```
1. install_utplsql_objects.sql 実行開始
   └─ PROMPTでインストール開始メッセージ出力

2. テーブル作成
   ├─ QA_TEST_RESULTS テーブル作成
   ├─ QA_TEST_RUNS テーブル作成
   └─ QA_TEST_RUN_INVALID_OBJECTS テーブル作成

3. インデックス作成
   ├─ QA_TEST_RESULTS用インデックス
   ├─ QA_TEST_RUNS用インデックス
   └─ QA_TEST_RUN_INVALID_OBJECTS用インデックス

4. 制約作成
   ├─ QA_TEST_RESULTS用制約
   ├─ QA_TEST_RUNS用制約
   └─ QA_TEST_RUN_INVALID_OBJECTS用制約

5. シーケンス作成
   ├─ QATR_SEQ
   ├─ QATO_SEQ
   └─ QATRU_SEQ

6. トリガー作成
   ├─ qatr_i_trg（QA_TEST_RESULTS用INSERTトリガー）
   ├─ qato_i_trg（QA_TEST_RUN_INVALID_OBJECTS用INSERTトリガー）
   └─ qatru_i_trg（QA_TEST_RUNS用INSERTトリガー）

7. パッケージ作成
   └─ qa_unit_tests_pkg

8. スケジューラジョブ作成
   └─ CRONJOB_RUN_UNIT_TESTS（日次実行、初期状態は無効）

9. インストール完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[install_utplsql_objects.sql 開始] --> B[テーブル作成]
    B --> C[QA_TEST_RESULTS 作成]
    C --> D[QA_TEST_RUNS 作成]
    D --> E[QA_TEST_RUN_INVALID_OBJECTS 作成]
    E --> F[インデックス作成]
    F --> G[制約作成]
    G --> H[シーケンス作成]
    H --> I[QATR_SEQ]
    I --> J[QATO_SEQ]
    J --> K[QATRU_SEQ]
    K --> L[トリガー作成]
    L --> M[パッケージ作成]
    M --> N[qa_unit_tests_pkg]
    N --> O[スケジューラジョブ作成]
    O --> P{ジョブ既存?}
    P -->|Yes| Q[WARNING表示]
    P -->|No| R[CRONJOB_RUN_UNIT_TESTS 作成]
    Q --> S[完了]
    R --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-1 | ジョブ初期状態 | スケジューラジョブは初期状態で無効（enabled=false） | ジョブ作成時 |
| BR-52-2 | 日次実行 | スケジューラジョブはデフォルトで日次実行（FREQ=DAILY） | ジョブ作成時 |
| BR-52-3 | 既存ジョブ確認 | ジョブが既に存在する場合は作成をスキップ | ジョブ作成時 |
| BR-52-4 | テスト結果保持 | テスト結果XMLはCLOB型で永続保存 | テスト実行時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テーブル作成 | QA_TEST_RESULTS | DDL (CREATE TABLE) | テスト結果XML格納 |
| テーブル作成 | QA_TEST_RUNS | DDL (CREATE TABLE) | テスト実行履歴格納 |
| テーブル作成 | QA_TEST_RUN_INVALID_OBJECTS | DDL (CREATE TABLE) | 無効オブジェクト格納 |
| シーケンス作成 | QATR_SEQ | DDL (CREATE SEQUENCE) | QA_TEST_RESULTS用ID |
| シーケンス作成 | QATO_SEQ | DDL (CREATE SEQUENCE) | QA_TEST_RUN_INVALID_OBJECTS用ID |
| シーケンス作成 | QATRU_SEQ | DDL (CREATE SEQUENCE) | QA_TEST_RUNS用ID |
| ジョブ作成 | CRONJOB_RUN_UNIT_TESTS | DBMS_SCHEDULER | 定期実行ジョブ |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | qatr_id | NUMBER NOT NULL | 主キー（QATR_SEQから採番） |
| CREATE TABLE | qatr_xml_result | CLOB NOT NULL | utPLSQLテスト結果XML |
| CREATE TABLE | qatr_added_on | DATE NOT NULL | 追加日時 |
| CREATE TABLE | qatr_added_by | VARCHAR2(255 CHAR) NOT NULL | 追加者 |
| CREATE TABLE | qatr_description | VARCHAR2(255 CHAR) NOT NULL | 説明 |

#### QA_TEST_RUNS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | qatru_id | NUMBER NOT NULL | 主キー（QATRU_SEQから採番） |
| CREATE TABLE | qatru_scheme_name | VARCHAR2(128 CHAR) NOT NULL | テスト対象スキーマ名 |
| CREATE TABLE | qatru_result | NUMBER NOT NULL | テスト結果（0:失敗, 1:成功, 2:エラー） |
| CREATE TABLE | qatru_executed_on | DATE NOT NULL | 実行日時 |

#### QA_TEST_RUN_INVALID_OBJECTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | qato_id | NUMBER NOT NULL | 主キー（QATO_SEQから採番） |
| CREATE TABLE | qato_object_name | VARCHAR2(128 CHAR) NOT NULL | 無効オブジェクト名 |
| CREATE TABLE | qato_object_type | VARCHAR2(128 CHAR) NOT NULL | オブジェクト種別 |
| CREATE TABLE | qato_test_run_id | NUMBER NOT NULL | テスト実行ID（外部キー） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00955 | 既存オブジェクト | テーブル/シーケンスが既に存在 | WARNING表示（スキップ） |
| ORA-27476 | ジョブエラー | スケジューラジョブ作成失敗 | エラーメッセージを出力し継続 |
| ORA-27477 | ジョブ重複 | 同名のジョブが既に存在 | WARNING表示（スキップ） |

### リトライ仕様

リトライは不要。エラー発生時は原因を解消した後に再実行。

## トランザクション仕様

DDL操作のため、各DDL文の実行後に暗黙的コミットが発生する。

## パフォーマンス要件

インストール処理は初期セットアップ時のみ実行されるため、特にパフォーマンス要件はない。

## セキュリティ考慮事項

- スケジューラジョブ CRONJOB_RUN_UNIT_TESTS は全ユニットテストを実行するため、実行権限の管理に注意
- QA_TEST_RESULTS に格納されるXMLにはテスト対象オブジェクトの情報が含まれる

## 備考

- スケジューラジョブは初期状態で無効。Config Scheduler Job 画面から有効化する
- utPLSQL フレームワークが別途インストールされている必要がある
- APEX連携オブジェクト（機能No.53）と組み合わせて使用することを推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインインストールスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_utplsql_objects.sql | `src/install_utplsql_objects.sql` | インストール処理の全体構造 |

**主要処理フロー**:
1. **1-3行目**: インストール開始メッセージ
2. **8-13行目**: テーブル作成スクリプト呼び出し（QA_TEST_RESULTS, QA_TEST_RUNS, QA_TEST_RUN_INVALID_OBJECTS）
3. **17-23行目**: インデックス作成
4. **28-33行目**: 制約作成
5. **38-43行目**: シーケンス作成（QATR_SEQ, QATO_SEQ, QATRU_SEQ）
6. **48-53行目**: トリガー作成
7. **58行目**: qa_unit_tests_pkg パッケージ作成
8. **63-64行目**: スケジューラジョブ作成スクリプト呼び出し

**読解のコツ**: 各DDLスクリプトは独立しているため、個別に確認可能。スクリプトはPROMPTで実行内容を表示してから@で呼び出す構造。

#### Step 2: テーブル定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | テスト結果XML格納テーブル |

**主要処理フロー**:
- **4-11行目**: CREATE TABLE文の定義（qatr_id, qatr_xml_result等）
- **15-18行目**: user_tablesから既存テーブルチェック
- **24-29行目**: テーブルコメント追加

#### Step 3: スケジューラジョブ作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_scheduler_job_for_unit_tests.sql | `src/scripts/create_scheduler_job_for_unit_tests.sql` | ジョブ作成ロジック |

**主要処理フロー**:
- **6-9行目**: 既存ジョブの確認（user_scheduler_jobs）
- **13-24行目**: DBMS_SCHEDULER.CREATE_JOBによるジョブ作成
  - job_action: `qa_unit_tests_pkg.p_run_all_unit_tests` を呼び出し
  - repeat_interval: `FREQ=DAILY`（日次実行）
  - enabled: `false`（初期状態は無効）
- **37-38行目**: 既存ジョブがある場合のWARNING表示

### プログラム呼び出し階層図

```
src/install_utplsql_objects.sql
    │
    ├─ src/ddl/tab/qa_test_results.sql
    ├─ src/ddl/tab/qa_test_runs.sql
    ├─ src/ddl/tab/qa_test_run_invalid_objects.sql
    │
    ├─ src/ddl/ind/qa_test_results.sql
    ├─ src/ddl/ind/qa_test_runs.sql
    ├─ src/ddl/ind/qa_test_run_invalid_objects.sql
    │
    ├─ src/ddl/cons/qa_test_results.sql
    ├─ src/ddl/cons/qa_test_runs.sql
    ├─ src/ddl/cons/qa_test_run_invalid_objects.sql
    │
    ├─ src/ddl/seq/qatr_seq.sql
    ├─ src/ddl/seq/qato_seq.sql
    ├─ src/ddl/seq/qatru_seq.sql
    │
    ├─ src/plsql/trg/qatr_i_trg.sql
    ├─ src/plsql/trg/qato_i_trg.sql
    ├─ src/plsql/trg/qatru_i_trg.sql
    │
    ├─ src/plsql/pkg/qa_unit_tests_pkg.sql
    │
    └─ src/scripts/create_scheduler_job_for_unit_tests.sql
           └─ DBMS_SCHEDULER.CREATE_JOB
```

### データフロー図

```
[入力]                    [処理]                               [出力]

install_objects.sql ───▶ install_utplsql_objects.sql ───▶ Oracleデータベース
  (引数1=1)                     │                           ├─ QA_TEST_RESULTS
                                ▼                           ├─ QA_TEST_RUNS
                          DDLスクリプト実行                   ├─ QA_TEST_RUN_INVALID_OBJECTS
                                │                           ├─ qa_unit_tests_pkg
                                ▼                           └─ CRONJOB_RUN_UNIT_TESTS
                          DBMS_SCHEDULER.CREATE_JOB
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install_utplsql_objects.sql | `src/install_utplsql_objects.sql` | スクリプト | utPLSQLオブジェクトインストールメイン |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果XML格納テーブル |
| qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | DDL | テスト実行履歴テーブル |
| qa_test_run_invalid_objects.sql | `src/ddl/tab/qa_test_run_invalid_objects.sql` | DDL | 無効オブジェクト格納テーブル |
| qatr_seq.sql | `src/ddl/seq/qatr_seq.sql` | DDL | QA_TEST_RESULTS用シーケンス |
| qato_seq.sql | `src/ddl/seq/qato_seq.sql` | DDL | QA_TEST_RUN_INVALID_OBJECTS用シーケンス |
| qatru_seq.sql | `src/ddl/seq/qatru_seq.sql` | DDL | QA_TEST_RUNS用シーケンス |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | PL/SQL | ユニットテスト実行パッケージ |
| create_scheduler_job_for_unit_tests.sql | `src/scripts/create_scheduler_job_for_unit_tests.sql` | スクリプト | スケジューラジョブ作成 |
