# 機能設計書 53-APEXオブジェクトインストール

## 概要

本ドキュメントは、Oracle APEX連携用オブジェクトをOracleデータベースにインストールする機能について定義する。install_apex_objects.sql を使用し、APEXアプリケーションと連携するための型定義、ビュー、パッケージを作成する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOはOracle APEXアプリケーションのフロントエンドと連携して、ルール管理やテスト結果の表示を行う。APEX連携を実現するためには、ダッシュボード表示用ビュー、ルール一覧表示用ビュー、LOV（List of Values）用ビュー、およびAPEXアプリケーションからの呼び出しを受け付けるパッケージをインストールする必要がある。本機能は、APEX連携に必要なすべてのオブジェクトを一括でインストールする。

**機能の利用シーン**：QUASTOの基本インストール時に引数でAPEX連携を有効（1）にした場合、または個別にAPEX連携オブジェクトを追加インストールする場合に使用される。APEXベースのGUIでQUASTOを操作したい環境で必要となる。

**主要な処理内容**：
1. テスト結果型定義（qa_test_results_row_t、qa_test_results_table_t）の作成
2. APEXブラックリストアプリビュー（qa_apex_blacklisted_apps_v）の作成
3. アプリケーションオーナービュー（qa_application_owner_v）の作成
4. ダッシュボード関連ビュー群（qa_overview_*_v）の作成
5. ページ別表示用ビュー群（qa_*_p00xx_v）の作成
6. LOV用ビュー群（qa_*_lov）の作成
7. qa_apex_app_pkg パッケージの作成
8. qa_apex_api_pkg パッケージの作成

**関連システム・外部連携**：Oracle APEX フレームワークとの連携。APEXアプリケーションからの呼び出しを受け付け、データ取得・更新処理を提供する。

**権限による制御**：APEX_xxxxxx ビュー（APEXメタデータビュー）へのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Dashboard | 主画面 | qa_faceted_search_dashboard_data_p0001_v等のビューからデータ取得 |
| 3 | Unit Test Generation | 参照画面 | qa_unit_test_packages_p0002_v からパッケージ情報取得 |
| 4 | Runtime Error | 参照画面 | qa_test_runtime_error_p0003_v からエラー情報取得 |
| 5 | Invalid Objects | 参照画面 | qa_test_run_details_p0004_v から無効オブジェクト取得 |
| 6 | Test Result Files | 参照画面 | qa_test_result_files_p0005_v からファイル情報取得 |
| 7 | Rules | 主画面 | qa_rules_p0006_v からルール一覧取得 |
| 8 | Add/Edit Rule | 参照画面 | qa_rules_p0007_v からルール詳細取得 |
| 9 | Rule Files | 参照画面 | qa_client_names_p0008_v からクライアント名取得 |
| 10 | Config Scheduler Job | 参照画面 | qa_job_details_p0009_v からジョブ情報取得 |
| 11 | Restart Unit Test | 参照画面 | qa_job_run_details_p0011_v から実行詳細取得 |

## 機能種別

データ連携（DDLスクリプト実行）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | install_objects.sql から呼び出される場合は引数不要 | - |

### 入力データソース

- SQL*Plus / SQLcl からのスクリプト実行
- install_objects.sql からの自動呼び出し（引数2=1の場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_test_results_row_t | 型定義 | テスト結果行の構造体 |
| qa_test_results_table_t | 型定義 | テスト結果テーブル型 |
| qa_apex_blacklisted_apps_v | ビュー | ブラックリスト登録APEXアプリ |
| qa_application_owner_v | ビュー | APEXアプリケーションオーナー |
| qa_overview_tests_p0001_v | ビュー | ダッシュボードテスト結果表示用 |
| qa_overview_quota_p0001_v | ビュー | ダッシュボードQuota表示用 |
| qa_faceted_search_dashboard_data_p0001_v | ビュー | ダッシュボードファセット検索用 |
| qa_unit_test_packages_p0002_v | ビュー | ユニットテストパッケージ一覧 |
| qa_apex_app_pkg | パッケージ | APEXアプリ連携パッケージ |
| qa_apex_api_pkg | パッケージ | APEX API連携パッケージ |

### 出力先

- Oracleデータベース（スキーマオブジェクト）

## 処理フロー

### 処理シーケンス

```
1. install_apex_objects.sql 実行開始
   └─ PROMPTでインストール開始メッセージ出力

2. 型定義作成
   ├─ qa_test_results_row_t（テスト結果行型）
   └─ qa_test_results_table_t（テスト結果テーブル型）

3. 基盤ビュー作成
   ├─ qa_apex_blacklisted_apps_v（ブラックリストアプリ）
   └─ qa_application_owner_v（アプリオーナー）

4. ダッシュボード用ビュー作成（ページ0001用）
   ├─ qa_overview_tests_p0001_v
   ├─ qa_overview_quota_p0001_v
   ├─ qa_overview_timeline_error_p0001_v
   ├─ qa_overview_timeline_failure_p0001_v
   ├─ qa_overview_timeline_success_p0001_v
   └─ qa_faceted_search_dashboard_data_p0001_v

5. ページ別表示用ビュー作成
   ├─ qa_unit_test_packages_p0002_v（ページ2）
   ├─ qa_test_runtime_error_p0003_v（ページ3）
   ├─ qa_test_run_details_p0004_v（ページ4）
   ├─ qa_test_result_files_p0005_v（ページ5）
   ├─ qa_rules_p0006_v（ページ6）
   ├─ qa_rules_p0007_v（ページ7）
   ├─ qa_client_names_p0008_v（ページ8）
   ├─ qa_job_details_p0009_v（ページ9）
   ├─ qa_job_run_details_p0009_v（ページ9）
   └─ qa_job_run_details_p0011_v（ページ11）

6. LOV用ビュー作成
   ├─ qa_rule_categories_lov
   ├─ qa_rule_error_levels_lov
   ├─ qa_rule_layers_lov
   ├─ qa_test_execution_dates_lov
   └─ qa_test_scheme_names_lov

7. パッケージ作成
   ├─ qa_apex_app_pkg（APEXアプリ連携）
   └─ qa_apex_api_pkg（APEX API）

8. インストール完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[install_apex_objects.sql 開始] --> B[型定義作成]
    B --> C[qa_test_results_row_t]
    C --> D[qa_test_results_table_t]
    D --> E[基盤ビュー作成]
    E --> F[ダッシュボード用ビュー作成]
    F --> G[qa_overview_tests_p0001_v]
    G --> H[qa_overview_quota_p0001_v]
    H --> I[その他ダッシュボードビュー]
    I --> J[ページ別ビュー作成]
    J --> K[P0002〜P0011用ビュー]
    K --> L[LOV用ビュー作成]
    L --> M[qa_rule_categories_lov 等]
    M --> N[パッケージ作成]
    N --> O[qa_apex_app_pkg]
    O --> P[qa_apex_api_pkg]
    P --> Q[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-1 | ページ番号命名規則 | ビュー名にAPEXページ番号（p00xx）を含める | ページ別ビュー作成時 |
| BR-53-2 | ブラックリスト除外 | qa_apex_blacklisted_apps_v でブラックリスト登録されたアプリを除外 | APEX連携処理時 |
| BR-53-3 | LOV標準形式 | LOVビューは display_value, return_value の形式で提供 | LOVビュー使用時 |
| BR-53-4 | APEXメタデータ参照 | APEXアプリ情報はapex_applicationsビュー等から取得 | アプリ情報取得時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 型作成 | qa_test_results_row_t | DDL (CREATE TYPE) | テスト結果行型 |
| 型作成 | qa_test_results_table_t | DDL (CREATE TYPE) | テスト結果テーブル型 |
| ビュー作成 | qa_apex_blacklisted_apps_v | DDL (CREATE VIEW) | ブラックリストアプリ |
| ビュー作成 | qa_overview_*_v | DDL (CREATE VIEW) | ダッシュボード表示用 |
| ビュー作成 | qa_*_p00xx_v | DDL (CREATE VIEW) | ページ別表示用 |
| ビュー作成 | qa_*_lov | DDL (CREATE VIEW) | LOV用 |
| パッケージ作成 | qa_apex_app_pkg | DDL (CREATE PACKAGE) | APEXアプリ連携 |
| パッケージ作成 | qa_apex_api_pkg | DDL (CREATE PACKAGE) | APEX API |

### テーブル別操作詳細

本機能ではテーブルの作成は行わない。ビューおよびパッケージの作成のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00955 | 既存オブジェクト | ビュー/パッケージが既に存在 | CREATE OR REPLACE で上書き |
| ORA-00942 | テーブル未存在 | ビュー作成時に参照テーブルが存在しない | 先にutPLSQLオブジェクトをインストール |
| ORA-04031 | メモリ不足 | 共有プールが不足 | 共有プールサイズを拡張 |

### リトライ仕様

リトライは不要。エラー発生時は原因を解消した後に再実行。

## トランザクション仕様

DDL操作のため、各DDL文の実行後に暗黙的コミットが発生する。

## パフォーマンス要件

インストール処理は初期セットアップ時のみ実行されるため、特にパフォーマンス要件はない。

## セキュリティ考慮事項

- ビューを通じてAPEXメタデータにアクセスするため、適切な権限管理が必要
- qa_apex_blacklisted_apps_v でセキュリティ上除外すべきアプリを管理可能
- qa_apex_api_pkg はAPEXアプリケーションからのみ呼び出されることを想定

## 備考

- utPLSQLオブジェクト（機能No.52）がインストールされていることが前提
- APEXアプリケーション本体は別途 src/apex/f141/install.sql でインストール
- ビュー名の p00xx はAPEXページ番号に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインインストールスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_apex_objects.sql | `src/install_apex_objects.sql` | インストール処理の全体構造 |

**主要処理フロー**:
1. **1-3行目**: インストール開始メッセージ
2. **8-11行目**: 型定義作成（qa_test_results_row_t, qa_test_results_table_t）
3. **16-19行目**: 基盤ビュー作成（qa_apex_blacklisted_apps_v, qa_application_owner_v）
4. **21-32行目**: ダッシュボード用ビュー作成（p0001系）
5. **33-52行目**: ページ別表示用ビュー作成（p0002〜p0011）
6. **54-63行目**: LOV用ビュー作成
7. **68-71行目**: パッケージ作成

**読解のコツ**: ビュー名の末尾 `_p00xx_v` はAPEXのページ番号を示す。例：`qa_overview_tests_p0001_v` はページ1（Dashboard）用。

#### Step 2: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | テスト結果行の構造 |
| 2-2 | qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | テスト結果テーブル型 |

**読解のコツ**: qa_test_results_table_t は qa_test_results_row_t のネストテーブル型。APEXのレポート表示用にパイプライン関数から返却される。

#### Step 3: ダッシュボード用ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_faceted_search_dashboard_data_p0001_v.sql | `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql` | ファセット検索用データ |
| 3-2 | qa_overview_quota_p0001_v.sql | `src/plsql/vw/qa_overview_quota_p0001_v.sql` | Quota円グラフ用データ |

**読解のコツ**: これらのビューはAPEXダッシュボードページのレポートリージョンで直接参照される。QA_TEST_RUNS, QA_TEST_RUN_INVALID_OBJECTS 等を結合してダッシュボード表示用データを生成。

#### Step 4: APEXアプリ連携パッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | APEXアプリからの呼び出し |
| 4-2 | qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | APEX向けAPI |

**読解のコツ**: qa_apex_app_pkg はAPEXアプリケーションプロセスから呼び出される手続き群。qa_apex_api_pkg はAPEX専用のルール実行API。

### プログラム呼び出し階層図

```
src/install_apex_objects.sql
    │
    ├─ src/plsql/typ/qa_test_results_row_t.sql
    ├─ src/plsql/typ/qa_test_results_table_t.sql
    │
    ├─ src/plsql/vw/qa_apex_blacklisted_apps_v.sql
    ├─ src/plsql/vw/qa_application_owner_v.sql
    │
    ├─ src/plsql/vw/qa_overview_tests_p0001_v.sql
    ├─ src/plsql/vw/qa_overview_quota_p0001_v.sql
    ├─ src/plsql/vw/qa_overview_timeline_*_p0001_v.sql
    ├─ src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql
    │
    ├─ src/plsql/vw/qa_unit_test_packages_p0002_v.sql
    ├─ src/plsql/vw/qa_test_runtime_error_p0003_v.sql
    ├─ src/plsql/vw/qa_test_run_details_p0004_v.sql
    ├─ src/plsql/vw/qa_test_result_files_p0005_v.sql
    ├─ src/plsql/vw/qa_rules_p0006_v.sql
    ├─ src/plsql/vw/qa_rules_p0007_v.sql
    ├─ src/plsql/vw/qa_client_names_p0008_v.sql
    ├─ src/plsql/vw/qa_job_details_p0009_v.sql
    ├─ src/plsql/vw/qa_job_run_details_p0009_v.sql
    ├─ src/plsql/vw/qa_job_run_details_p0011_v.sql
    │
    ├─ src/plsql/vw/qa_rule_categories_lov.sql
    ├─ src/plsql/vw/qa_rule_error_levels_lov.sql
    ├─ src/plsql/vw/qa_rule_layers_lov.sql
    ├─ src/plsql/vw/qa_test_execution_dates_lov.sql
    ├─ src/plsql/vw/qa_test_scheme_names_lov.sql
    │
    ├─ src/plsql/pkg/qa_apex_app_pkg.sql
    └─ src/plsql/pkg/qa_apex_api_pkg.sql
```

### データフロー図

```
[入力]                    [処理]                           [出力]

install_objects.sql ───▶ install_apex_objects.sql ───▶ Oracleデータベース
  (引数2=1)                     │                       ├─ qa_test_results_row_t
                                ▼                       ├─ qa_test_results_table_t
                          DDLスクリプト実行              ├─ qa_*_p00xx_v (ビュー群)
                                                        ├─ qa_*_lov (LOVビュー群)
                                                        ├─ qa_apex_app_pkg
                                                        └─ qa_apex_api_pkg

[APEXアプリ連携]

APEXアプリケーション ───▶ qa_apex_app_pkg ───▶ qa_*_p00xx_v ───▶ QA_* テーブル群
                               │
                               └──▶ qa_apex_api_pkg ───▶ qa_api_pkg
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install_apex_objects.sql | `src/install_apex_objects.sql` | スクリプト | APEXオブジェクトインストールメイン |
| qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | 型定義 | テスト結果行型 |
| qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | 型定義 | テスト結果テーブル型 |
| qa_apex_blacklisted_apps_v.sql | `src/plsql/vw/qa_apex_blacklisted_apps_v.sql` | ビュー | ブラックリストアプリ |
| qa_faceted_search_dashboard_data_p0001_v.sql | `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql` | ビュー | ダッシュボードデータ |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | PL/SQL | APEXアプリ連携パッケージ |
| qa_apex_api_pkg.sql | `src/plsql/pkg/qa_apex_api_pkg.sql` | PL/SQL | APEX APIパッケージ |
