# 機能設計書 54-アンインストール

## 概要

本ドキュメントは、QUASTOの全オブジェクトをOracleデータベースから削除する機能について定義する。uninstall.sql および uninstall_all_objects.sql を使用し、QUASTOによって作成されたテーブル、シーケンス、型定義、ビュー、パッケージ、トリガー、スケジューラジョブを一括で削除する。

### 本機能の処理概要

**業務上の目的・背景**：QUASTOが不要になった場合、または環境の再構築が必要な場合に、QUASTOの全オブジェクトをクリーンに削除する必要がある。本機能は、依存関係を考慮した正しい順序でオブジェクトを削除し、データベースをQUASTOインストール前の状態に戻す。

**機能の利用シーン**：QUASTOの完全アンインストール時、または別バージョンへのクリーンインストール前の環境クリーンアップ時に使用される。DBAまたは開発者がSQL*Plus / SQLcl からスクリプトを実行することで、すべてのQUASTOオブジェクトが削除される。

**主要な処理内容**：
1. テーブルの外部キー制約を先に削除
2. テーブルの削除（QA_TEST_RUN_INVALID_OBJECTS、QA_TEST_RUNS、QA_TEST_RESULTS、QA_RULES、QA_IMPORT_FILES）
3. パッケージの削除（qa_export_import_rules_pkg、qa_main_pkg、qa_api_pkg 等）
4. 型定義の削除（varchar2_tab_t、qa_rule_t、qa_rules_t 等）
5. シーケンスの削除（QARU_SEQ、QAIF_SEQ、QATR_SEQ、QATO_SEQ、QATRU_SEQ）
6. ビューの削除（全ビュー）
7. スケジューラジョブ CRONJOB_RUN_UNIT_TESTS の削除
8. 生成されたutPLSQLユニットテストパッケージ（QA_UT_*）の削除
9. リサイクルビンのパージ
10. アンインストール結果の検証

**関連システム・外部連携**：QUASTOが作成した全オブジェクトが削除対象。utPLSQL連携オブジェクト、APEX連携オブジェクトも含む。

**権限による制御**：DROP TABLE、DROP PACKAGE、DROP TYPE、DROP VIEW、DROP SEQUENCE の権限、およびDBMS_SCHEDULERの管理権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| なし | - | - | アンインストールは画面から実行されない |

## 機能種別

データ連携（DDLスクリプト実行）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | 引数なしで実行 | - |

### 入力データソース

- SQL*Plus / SQLcl からのコマンドライン実行（@uninstall.sql）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| uninstall.log | ファイル | アンインストール処理のログ出力 |
| 削除結果メッセージ | DBMS_OUTPUT | 各オブジェクトの削除成功/失敗メッセージ |

### 出力先

- ファイルシステム（uninstall.log）
- DBMS_OUTPUT

## 処理フロー

### 処理シーケンス

```
1. uninstall.sql 実行開始
   └─ src/uninstall_all_objects.sql を呼び出し

2. オブジェクト削除リストの構築
   └─ PL/SQL連想配列にオブジェクト名と種別を登録

3. テーブル削除（依存関係順）
   ├─ 外部キー制約の削除
   ├─ QA_TEST_RUN_INVALID_OBJECTS 削除
   ├─ QA_TEST_RUNS 削除
   ├─ QA_TEST_RESULTS 削除
   ├─ QA_RULES 削除
   └─ QA_IMPORT_FILES 削除

4. パッケージ削除
   ├─ QA_EXPORT_IMPORT_RULES_PKG
   ├─ QA_MAIN_PKG
   ├─ QA_API_PKG
   ├─ QA_LOGGER_PKG
   ├─ QA_CONSTANT_PKG
   ├─ QA_UNIT_TESTS_PKG
   ├─ QA_UTILS_PKG
   ├─ QA_APEX_APP_PKG
   ├─ QA_APEX_API_PKG
   └─ QA_APEX_PLUGIN_PKG

5. 型定義削除（FORCE使用）
   ├─ VARCHAR2_TAB_T
   ├─ QA_RULES_T
   ├─ QA_RULE_T
   ├─ QA_RUNNING_RULE_T
   ├─ QA_RUNNING_RULES_T
   ├─ QA_SCHEME_OBJECT_AMOUNTS_T
   ├─ QA_SCHEME_OBJECT_AMOUNT_T
   ├─ QA_TEST_RESULTS_TABLE_T
   └─ QA_TEST_RESULTS_ROW_T

6. シーケンス削除
   ├─ QARU_SEQ
   ├─ QAIF_SEQ
   ├─ QATR_SEQ
   ├─ QATO_SEQ
   └─ QATRU_SEQ

7. ビュー削除（全20ビュー以上）

8. スケジューラジョブ削除
   └─ CRONJOB_RUN_UNIT_TESTS（DBMS_SCHEDULER.DROP_JOB）

9. 生成ユニットテストパッケージ削除
   └─ QA_UT_* パターンに一致するパッケージを動的削除

10. リサイクルビンパージ
    └─ PURGE RECYCLEBIN

11. アンインストール検証
    └─ user_objects からQA_*、VARCHAR2_TAB_T オブジェクトが残っていないか確認
```

### フローチャート

```mermaid
flowchart TD
    A[uninstall.sql 実行開始] --> B[オブジェクトリスト構築]
    B --> C[テーブル削除開始]
    C --> D{外部キー制約あり?}
    D -->|Yes| E[制約削除]
    D -->|No| F[テーブル削除]
    E --> F
    F --> G[パッケージ削除]
    G --> H[型定義削除 FORCE]
    H --> I[シーケンス削除]
    I --> J[ビュー削除]
    J --> K[スケジューラジョブ削除]
    K --> L{ジョブ存在?}
    L -->|Yes| M[DBMS_SCHEDULER.DROP_JOB]
    L -->|No| N[スキップ]
    M --> O[QA_UT_* パッケージ削除]
    N --> O
    O --> P[PURGE RECYCLEBIN]
    P --> Q[アンインストール検証]
    Q --> R{残存オブジェクトあり?}
    R -->|Yes| S[エラーメッセージ表示]
    R -->|No| T[成功メッセージ表示]
    S --> U[終了]
    T --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-1 | 依存関係順削除 | 外部キー制約を持つテーブルは制約を先に削除 | テーブル削除時 |
| BR-54-2 | 型強制削除 | 型定義は FORCE オプションで削除（依存関係エラー回避） | 型削除時 |
| BR-54-3 | ジョブ強制削除 | スケジューラジョブは force => true で削除 | ジョブ削除時 |
| BR-54-4 | 動的パッケージ削除 | QA_UT_* パターンで生成されたパッケージを動的に検索・削除 | ユニットテストパッケージ削除時 |
| BR-54-5 | 検証必須 | 削除完了後にuser_objectsを確認し残存オブジェクトを報告 | 処理完了後 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象オブジェクト | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 制約削除 | 各テーブルの外部キー | DDL (ALTER TABLE DROP CONSTRAINT) | 依存関係解除 |
| テーブル削除 | QA_* テーブル5個 | DDL (DROP TABLE) | テーブルとデータ削除 |
| パッケージ削除 | QA_* パッケージ11個 | DDL (DROP PACKAGE) | パッケージ削除 |
| 型削除 | QA_* 型9個 | DDL (DROP TYPE FORCE) | 型定義削除 |
| シーケンス削除 | QA* シーケンス5個 | DDL (DROP SEQUENCE) | シーケンス削除 |
| ビュー削除 | QA_* ビュー24個 | DDL (DROP VIEW) | ビュー削除 |
| ジョブ削除 | CRONJOB_RUN_UNIT_TESTS | DBMS_SCHEDULER.DROP_JOB | ジョブ削除 |

### テーブル別操作詳細

#### 削除対象テーブル

| テーブル名 | 削除順序 | 備考 |
|-----------|---------|------|
| QA_TEST_RUN_INVALID_OBJECTS | 1 | QA_TEST_RUNSへの外部キーあり |
| QA_TEST_RUNS | 2 | 外部キー制約解除後に削除 |
| QA_TEST_RESULTS | 3 | - |
| QA_RULES | 4 | - |
| QA_IMPORT_FILES | 5 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00942 | オブジェクト未存在 | 削除対象オブジェクトが存在しない | WARNING表示（スキップ） |
| ORA-02449 | 依存関係エラー | 外部キー制約が残っている | 制約を先に削除 |
| ORA-04063 | パッケージ依存エラー | 他オブジェクトがパッケージに依存 | FORCE オプション使用 |
| ORA-27475 | ジョブ未存在 | スケジューラジョブが存在しない | スキップ |

### リトライ仕様

リトライは不要。エラー発生時は原因を解消した後に再実行。

## トランザクション仕様

DDL操作のため、各DDL文の実行後に暗黙的コミットが発生する。ロールバックは不可。

## パフォーマンス要件

アンインストール処理は環境クリーンアップ時のみ実行されるため、特にパフォーマンス要件はない。

## セキュリティ考慮事項

- アンインストールを実行するユーザーにはDROP権限が必要
- アンインストールにより全データが削除されるため、必要に応じて事前にバックアップを取得
- uninstall.log にはオブジェクト名が記録される

## 備考

- アンインストール後、QUASTOを再度使用する場合は install.sql を実行
- APEXアプリケーション（f141）は本スクリプトでは削除されない。APEXビルダーから別途削除が必要
- リサイクルビンをパージするため、削除されたオブジェクトの復元は不可

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | uninstall.sql | `uninstall.sql` | アンインストールの起点。uninstall_all_objects.sqlを呼び出すのみ |
| 1-2 | uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | メインのアンインストール処理 |

**主要処理フロー**:
1. **1-8行目**: 環境設定（serveroutput on, spool等）
2. **13-18行目**: オブジェクト格納用のレコード型とテーブル型の定義
3. **31-204行目**: 削除対象オブジェクトのリスト構築
4. **207-278行目**: オブジェクト削除のメインループ

**読解のコツ**: 削除対象オブジェクトは `l_object` 連想配列に格納される。object_name と object_type のペアで管理。

#### Step 2: テーブル削除ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | 外部キー制約削除ロジック |

**主要処理フロー**:
- **209-243行目**: テーブル削除時の外部キー制約処理
  - **211-214行目**: user_constraintsから外部キー制約を検索（constraint_type = 'R'）
  - **216行目**: ALTER TABLE ... DROP CONSTRAINT で制約削除
  - **226-227行目**: EXECUTE IMMEDIATEで動的SQL実行

**読解のコツ**: テーブル削除前に外部キー制約（constraint_type = 'R' はREFERENCES制約）を削除することで、依存関係エラーを回避。

#### Step 3: 型削除ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | 型のFORCE削除 |

**主要処理フロー**:
- **247-251行目**: 型削除時のFORCEオプション付与
  - **247行目**: object_type が 'TYPE' かどうかチェック
  - **250行目**: DROP TYPE ... FORCE でネストテーブル型も強制削除

**読解のコツ**: 型定義は他の型から参照されている場合があるため、FORCE オプションを使用して依存関係を無視して削除。

#### Step 4: スケジューラジョブ削除を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | ジョブ削除 |

**主要処理フロー**:
- **289-306行目**: CRONJOB_RUN_UNIT_TESTSジョブ削除
  - **294-297行目**: user_scheduler_jobsからジョブ存在確認
  - **301行目**: DBMS_SCHEDULER.DROP_JOB（force => true）

**読解のコツ**: force => true を指定することで、実行中のジョブも強制停止・削除。

#### Step 5: 動的パッケージ削除を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | QA_UT_*パッケージ削除 |

**主要処理フロー**:
- **311-322行目**: 動的生成されたutPLSQLパッケージの削除
  - **312-315行目**: user_objectsから `QA_UT_%` パターンに一致するパッケージを検索
  - **317行目**: EXECUTE IMMEDIATE 'DROP PACKAGE ' でパッケージ削除

**読解のコツ**: QUASTOはルールごとにutPLSQLテストパッケージを動的生成するため、固定リストではなくパターンマッチで削除対象を特定。

### プログラム呼び出し階層図

```
uninstall.sql
    │
    └─ src/uninstall_all_objects.sql
           │
           ├─ [メインループ] オブジェクト削除
           │      ├─ テーブル: ALTER TABLE DROP CONSTRAINT
           │      │           DROP TABLE
           │      ├─ パッケージ: DROP PACKAGE
           │      ├─ 型: DROP TYPE FORCE
           │      ├─ シーケンス: DROP SEQUENCE
           │      └─ ビュー: DROP VIEW
           │
           ├─ DBMS_SCHEDULER.DROP_JOB (CRONJOB_RUN_UNIT_TESTS)
           │
           ├─ [動的ループ] DROP PACKAGE QA_UT_*
           │
           └─ PURGE RECYCLEBIN
```

### データフロー図

```
[入力]                    [処理]                           [出力]

@uninstall.sql ───▶ uninstall_all_objects.sql ───▶ Oracleデータベース
                           │                         （オブジェクト削除）
                           ▼
                    オブジェクトリスト構築
                           │
                           ▼
                    DROP TABLE/PACKAGE/TYPE/
                    SEQUENCE/VIEW 実行 ──────────▶ uninstall.log
                           │
                           ▼
                    DBMS_SCHEDULER.DROP_JOB
                           │
                           ▼
                    DROP PACKAGE QA_UT_*
                           │
                           ▼
                    PURGE RECYCLEBIN
                           │
                           ▼
                    アンインストール検証 ─────────▶ 結果メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| uninstall.sql | `uninstall.sql` | スクリプト | アンインストールエントリーポイント |
| uninstall_all_objects.sql | `src/uninstall_all_objects.sql` | スクリプト | メインアンインストール処理 |
