# 機能設計書 7-ルール属性取得

## 概要

本ドキュメントは、QUASTOシステムにおけるルール属性取得機能の設計仕様を記述する。

### 本機能の処理概要

ルール属性取得機能は、ルール番号とクライアント名からルールの各種属性を取得する一連の関数群を提供する機能である。qa_main_pkgパッケージにf_get_rule、f_get_rule_pk、f_get_rule_category、f_get_rule_name、f_get_rule_layer、f_get_rule_error_level等の関数として実装されている。

**業務上の目的・背景**：ルール実行や管理処理において、ルールの詳細情報を取得する必要がある。個別の属性を必要に応じて取得できる関数群を提供することで、呼び出し側のコードを簡潔に保ちながら、必要な情報のみを効率的に取得できる。

**機能の利用シーン**：
- ルール実行前にルール定義情報を取得する場合
- ルールのカテゴリに応じた分岐処理を行う場合
- ルール名を表示する場合
- エラーレベルに応じたフィルタリングを行う場合

**主要な処理内容**：
1. f_get_rule：ルールの主要属性をqa_rule_t型で取得
2. f_get_rule_pk：ルールの主キー（qaru_id）を取得
3. f_get_rule_category：ルールカテゴリ（DDL/DML/APEX）を取得
4. f_get_rule_name：ルール名を取得
5. f_get_rule_layer：ルールレイヤー（PAGE/APPLICATION/DATABASE）を取得
6. f_get_rule_error_level：エラーレベル（1/2/4）を取得

**関連システム・外部連携**：qa_api_pkg.tf_run_rule内で使用され、ルール実行前の定義取得に利用される。

**権限による制御**：authid definerでパッケージ所有者権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面から直接呼び出されることはなく、APIとして使用 |

## 機能種別

データ取得 / API提供

## 入力仕様

### 入力パラメータ

#### 共通パラメータ（すべての関数）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2 | Yes | ルール番号 | NOT NULL |
| pi_qaru_client_name | VARCHAR2 | Yes | クライアント名 | NOT NULL |

### 入力データソース

- 他のPL/SQLプログラムからの関数呼び出し

## 出力仕様

### 出力データ

#### f_get_rule

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qa_rule_t | オブジェクト型 | qaru_id, qaru_category, qaru_error_level, qaru_error_message, qaru_object_types, qaru_sqlを含む |

#### f_get_rule_pk

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | NUMBER | ルールの主キー（qaru_id） |

#### f_get_rule_category

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | VARCHAR2 | ルールカテゴリ（DDL/DML/APEX） |

#### f_get_rule_name

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | VARCHAR2 | ルール名 |

#### f_get_rule_layer

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | VARCHAR2 | ルールレイヤー（PAGE/APPLICATION/DATABASE） |

#### f_get_rule_error_level

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | VARCHAR2 | エラーレベル |

### 出力先

- 関数の戻り値

## 処理フロー

### 処理シーケンス

```
1. パラメータログ記録
   └─ qa_logger_pkg.append_paramでパラメータを記録
2. QA_RULESテーブルからSELECT
   └─ ルール番号とクライアント名で検索
3. 結果返却
   └─ 取得した値を返却

※ APEXカテゴリ除外チェック
   └─ gc_apex_flagが0の場合、APEXカテゴリのルールは除外
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータログ記録]
    B --> C[QA_RULESからSELECT]
    C --> D{データあり?}
    D -->|Yes| E[結果返却]
    D -->|No| F[NO_DATA_FOUND]
    E --> G[終了]
    F --> H[ログ記録して例外再スロー]
    H --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | APEX除外条件 | gc_apex_flag=0の場合、APEXカテゴリのルールは取得対象外 | f_get_rule, f_get_rule_category等 |
| BR-02 | 存在チェック | 指定されたルール番号とクライアント名の組み合わせが存在しない場合はNO_DATA_FOUND | 全関数 |

### 計算ロジック

**APEX除外条件**：
```sql
WHERE q.qaru_rule_number = pi_qaru_rule_number
  AND q.qaru_client_name = pi_qaru_client_name
  AND (q.qaru_category != gc_apex_flag OR gc_apex_flag IS NULL)
```

gc_apex_flag変数の値：
```sql
gc_apex_flag VARCHAR2(10 CHAR) := CASE
    WHEN qa_constant_pkg.gc_apex_flag = 0 THEN 'APEX'
    ELSE NULL
END;
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール属性取得 | QA_RULES | SELECT | 各種属性を取得 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_id, qaru_category, qaru_error_level, qaru_error_message, qaru_object_types, qaru_sql | WHERE qaru_rule_number = pi_qaru_rule_number AND qaru_client_name = pi_qaru_client_name | f_get_rule |
| SELECT | qaru_id | 同上 | f_get_rule_pk |
| SELECT | qaru_category | 同上 | f_get_rule_category |
| SELECT | qaru_name | 同上 | f_get_rule_name |
| SELECT | qaru_layer | 同上 | f_get_rule_layer |
| SELECT | qaru_error_level | 同上 | f_get_rule_error_level |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_DATA_FOUND | データなし | 指定ルールが存在しない | 正しいルール番号/クライアント名を指定 |
| OTHERS | データベースエラー | SELECT時のエラー | ログに記録して再スロー |

### リトライ仕様

リトライは不要。

## トランザクション仕様

- 参照のみの処理のためトランザクション管理は不要

## パフォーマンス要件

- 各関数の実行：数ミリ秒以内

## セキュリティ考慮事項

- authid definerでパッケージ所有者権限で実行

## 備考

- qa_main_pkgはauthid definer（定義者権限）で定義されている
- gc_apex_flag変数でAPEXカテゴリの除外を制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、戻り値として使用されるqa_rule_t型を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | qa_rule_tの属性とコンストラクタを確認 |

**読解のコツ**:
- 41-49行目のコンストラクタがf_get_ruleで使用される
- 6つのパラメータ：qaru_id, qaru_category, qaru_error_level, qaru_error_message, qaru_object_types, qaru_sql

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | 各関数の仕様と実装を確認 |

**主要処理フロー**:

**f_get_rule**:
1. **21-25行目**: 仕様宣言
2. **213-256行目**: 実装本体
3. **230-235行目**: qa_rule_tコンストラクタを使用してSELECT INTO

**f_get_rule_pk**:
1. **27-38行目**: 仕様宣言
2. **258-288行目**: 実装本体

**f_get_rule_category**:
1. **52-62行目**: 仕様宣言
2. **328-359行目**: 実装本体

**f_get_rule_name**:
1. **64-74行目**: 仕様宣言
2. **361-392行目**: 実装本体

**f_get_rule_layer**:
1. **76-86行目**: 仕様宣言
2. **394-425行目**: 実装本体

**f_get_rule_error_level**:
1. **88-98行目**: 仕様宣言
2. **427-458行目**: 実装本体

#### Step 3: APEX除外ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | gc_apex_flag変数の定義を確認 |

**主要処理フロー**:
- **206-211行目**: gc_apex_flag変数の定義
- **240行目**: SELECT文でのAPEX除外条件

### プログラム呼び出し階層図

```
qa_api_pkg.tf_run_rule
    │
    ├─ qa_main_pkg.f_get_rule
    │      └─ SELECT ... INTO qa_rule_t FROM qa_rules
    │
    └─ qa_main_pkg.f_is_rule_active
           └─ SELECT qaru_is_active FROM qa_rules

その他の呼び出し元:
- qa_unit_tests_pkg（ユニットテスト関連）
- APEX画面（ルール情報表示）
```

### データフロー図

```
[入力]                     [処理]                              [出力]

pi_qaru_rule_number ──▶ qa_main_pkg.f_get_rule ──────────▶ qa_rule_t
pi_qaru_client_name        │
                           │
                           └─▶ SELECT FROM qa_rules
                                    │
                                    └─▶ qa_rule_tコンストラクタ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | ルール属性取得関数群 |
| qa_rule_t.sql | `src/plsql/typ/qa_rule_t.sql` | TYPE | ルール属性オブジェクト型 |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | QA_RULESテーブル定義 |
| qa_api_pkg.sql | `src/plsql/pkg/qa_api_pkg.sql` | PKG | f_get_ruleの主な呼び出し元 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | PKG | パラメータログ記録 |
