# 機能設計書 9-ルール挿入

## 概要

本ドキュメントは、QUASTOシステムにおけるルール挿入機能の設計仕様を記述する。

### 本機能の処理概要

ルール挿入機能は、新規ルールをQA_RULESテーブルに挿入する機能である。qa_main_pkg.f_insert_rule関数として実装されており、ルール定義の各属性を引数として受け取り、INSERT文を実行後に採番されたqaru_idを返却する。

**業務上の目的・背景**：QUASTOシステムで新しい品質ルールを定義するために、ルール情報をデータベースに登録する必要がある。この機能により、プログラムからルールを一括登録したり、JSONインポート処理の内部でルールを挿入したりすることができる。

**機能の利用シーン**：
- APEX Add/Edit Rule画面からの新規ルール作成
- JSONインポート処理での新規ルール登録
- プログラムによる一括ルール登録
- テストデータ作成

**主要な処理内容**：
1. 13個のパラメータを受け取る（ルール番号、クライアント名、名前、カテゴリ等）
2. パラメータをログに記録
3. QA_RULESテーブルにINSERT文を実行
4. RETURNING句で採番されたqaru_idを取得
5. qaru_idを戻り値として返却

**関連システム・外部連携**：APEX Add/Edit Rule画面と連携し、フォーム入力値をもとにルールを登録する。JSONインポート機能（qa_export_import_rules_pkg）からも使用される。

**権限による制御**：authid definerでパッケージ所有者権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | Add/Edit Rule | 主機能 | Createボタン押下で新規ルールをQA_RULESテーブルに挿入 |

## 機能種別

データ登録 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pi_qaru_rule_number | VARCHAR2 | Yes | ルール番号 | NOT NULL |
| pi_qaru_client_name | VARCHAR2 | Yes | クライアント名 | NOT NULL |
| pi_qaru_name | VARCHAR2 | Yes | ルール名 | NOT NULL |
| pi_qaru_category | VARCHAR2 | Yes | カテゴリ | NOT NULL (DDL/DML/APEX) |
| pi_qaru_object_types | VARCHAR2 | Yes | 対象オブジェクトタイプ | NOT NULL |
| pi_qaru_error_message | VARCHAR2 | Yes | エラーメッセージ | NOT NULL |
| pi_qaru_comment | VARCHAR2 | No | コメント | デフォルト: NULL |
| pi_qaru_exclude_objects | VARCHAR2 | No | 除外オブジェクト | デフォルト: NULL |
| pi_qaru_error_level | NUMBER | Yes | エラーレベル | NOT NULL (1/2/4) |
| pi_qaru_is_active | NUMBER | No | 有効フラグ | デフォルト: 1 |
| pi_qaru_sql | CLOB | Yes | 品質チェックSQL | NOT NULL |
| pi_qaru_predecessor_ids | VARCHAR2 | No | 先行ルールID | デフォルト: NULL |
| pi_qaru_layer | VARCHAR2 | Yes | レイヤー | NOT NULL (PAGE/APPLICATION/DATABASE) |

### 入力データソース

- APEX Add/Edit Rule画面からのフォーム入力
- JSONインポート処理からの呼び出し
- 他のPL/SQLプログラムからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | NUMBER | 採番されたqaru_id（主キー） |

### 出力先

- 関数の戻り値（NUMBER）
- QA_RULESテーブル（INSERT）

## 処理フロー

### 処理シーケンス

```
1. パラメータログ記録
   └─ qa_logger_pkg.append_paramで14個のパラメータを記録
2. INSERT文実行
   └─ 13カラムに値を挿入
3. qaru_id取得
   └─ RETURNING句で採番されたIDを取得
4. 結果返却
   └─ qaru_idを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータログ記録]
    B --> C[INSERT INTO qa_rules]
    C --> D[RETURNING qaru_id INTO l_qaru_id]
    D --> E[l_qaru_id返却]
    E --> F[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 一意制約 | ルール番号とクライアント名の組み合わせは一意 | INSERT時 |
| BR-02 | デフォルト有効 | pi_qaru_is_activeのデフォルト値は1（有効） | INSERT時 |
| BR-03 | 監査列自動設定 | qaru_created_on/by, qaru_updated_on/byは自動設定 | INSERT時（トリガー/デフォルト値） |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール挿入 | QA_RULES | INSERT | 新規ルールを挿入 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | qaru_rule_number | pi_qaru_rule_number | - |
| INSERT | qaru_client_name | pi_qaru_client_name | - |
| INSERT | qaru_name | pi_qaru_name | - |
| INSERT | qaru_category | pi_qaru_category | - |
| INSERT | qaru_object_types | pi_qaru_object_types | - |
| INSERT | qaru_error_message | pi_qaru_error_message | - |
| INSERT | qaru_comment | pi_qaru_comment | - |
| INSERT | qaru_exclude_objects | pi_qaru_exclude_objects | - |
| INSERT | qaru_error_level | pi_qaru_error_level | - |
| INSERT | qaru_is_active | pi_qaru_is_active | デフォルト1 |
| INSERT | qaru_sql | pi_qaru_sql | - |
| INSERT | qaru_predecessor_ids | pi_qaru_predecessor_ids | - |
| INSERT | qaru_layer | pi_qaru_layer | - |
| RETURNING | qaru_id | 自動採番 | 戻り値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ORA-00001 | 一意制約違反 | 同一ルール番号+クライアント名が存在 | 別のルール番号を使用 |
| ORA-01400 | NOT NULL違反 | 必須項目がNULL | 必須項目を入力 |
| OTHERS | データベースエラー | INSERT時のエラー | ログに記録して再スロー |

### リトライ仕様

リトライは不要。エラー発生時はログに記録して再スロー。

## トランザクション仕様

- INSERT文のコミットは呼び出し元に委譲
- APEX画面からの呼び出し時は自動コミット

## パフォーマンス要件

- 実行時間：数ミリ秒以内

## セキュリティ考慮事項

- authid definerでパッケージ所有者権限で実行
- pi_qaru_sqlには任意のSQLが格納されるため、呼び出し元でのバリデーションが重要

## 備考

- qaru_idはシーケンスまたはトリガーで自動採番される
- RETURNING句でINSERT直後にIDを取得

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テーブル構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | 挿入先テーブルの構造を確認 |

**読解のコツ**:
- 21列中13列がINSERT対象（qaru_id, 監査列は自動設定）

#### Step 2: 関数仕様を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | f_insert_rule関数の仕様と実装を確認 |

**主要処理フロー**:
1. **134-166行目**: f_insert_rule関数の仕様宣言（13パラメータ）
2. **749-838行目**: f_insert_rule関数の実装本体
3. **770-797行目**: 14個のパラメータのログ記録（append_param）
4. **800-828行目**: INSERT文の実行
5. **828行目**: RETURNING qaru_id INTO l_qaru_id

**読解のコツ**:
- デフォルト値のあるパラメータ：pi_qaru_comment, pi_qaru_exclude_objects, pi_qaru_is_active, pi_qaru_predecessor_ids

### プログラム呼び出し階層図

```
APEX Add/Edit Rule画面
    │
    └─ qa_main_pkg.f_insert_rule
           │
           ├─ qa_logger_pkg.append_param (パラメータログ)
           │
           └─ INSERT INTO qa_rules ... RETURNING qaru_id

qa_export_import_rules_pkg.p_import_clob_to_rules_table
    │
    └─ MERGE INTO qa_rules (INSERT時にf_insert_ruleと同等の処理)
```

### データフロー図

```
[入力]                     [処理]                              [出力]

13個のパラメータ ───────▶ qa_main_pkg.f_insert_rule ─────────▶ qaru_id (NUMBER)
                               │
                               │
                               └─▶ INSERT INTO qa_rules
                                        │
                                        └─▶ RETURNING qaru_id
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | PKG | f_insert_rule関数 |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | QA_RULESテーブル定義 |
| qa_logger_pkg.sql | `src/plsql/pkg/qa_logger_pkg.sql` | PKG | パラメータログ記録 |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | PKG | JSONインポート（MERGE文使用） |
