---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-ルール定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **APEX管理権限の制御**：認可設定の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-03: `src/plsql/typ/qa_rule_t.sql` - ルール型定義
- E-04: `src/plsql/typ/qa_rules_t.sql` - ルールコレクション型定義
- E-05: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - エクスポート/インポートパッケージ
- E-06: `src/plsql/vw/qa_predecessor_order_v.sql` - 先行ルール順序ビュー
- E-07: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - テスト対象スキーマビュー
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QA_RULESテーブルは21列で構成される | E-01 (6-26行目) | ○ |
| C-02 | DDL、DML、APEXの3カテゴリをサポート | E-01 (45行目コメント), E-09 | ○ |
| C-03 | エラーレベルは1=Error, 2=Warning, 4=Info | E-01 (50行目コメント) | ○ |
| C-04 | qaru_is_activeでルールの有効/無効を制御 | E-01 (51行目コメント) | ○ |
| C-05 | qaru_exclude_objectsでオブジェクト除外を指定 | E-01 (49行目コメント) | ○ |
| C-06 | qaru_predecessor_idsで先行ルールを指定 | E-01 (53行目コメント) | ○ |
| C-07 | f_insert_rule関数でルールを挿入 | E-02 (151-166行目, 749-838行目) | ○ |
| C-08 | f_get_rule関数でルール属性を取得 | E-02 (21-25行目, 213-256行目) | ○ |
| C-09 | qa_rule_tには4つのコンストラクタがある | E-03 (41-99行目) | ○ |
| C-10 | qa_rules_tはqa_rule_tのテーブル型 | E-04 (13行目) | ○ |
| C-11 | authid current_userで実行ユーザー権限でSQL実行 | E-02 (1行目: authid definer) | ○ |
| C-12 | gc_apex_flagが0の場合APEXルールは除外 | E-02 (206-211行目) | ○ |
| C-13 | ルール番号とクライアント名の組み合わせは一意 | E-01 (推論: 主キー制約) | ○ |
| C-14 | JSONインポート時はMERGE文で処理 | E-05 (403-447行目) | ○ |
| C-15 | ブラックリストスキーマへの操作は制限 | E-07 (4-79行目) | ○ |
| C-16 | qa_predecessor_order_vで実行順序を決定 | E-06 (1-30行目) | ○ |
| C-17 | Rules画面(No.7)でルール一覧表示 | E-08 (14行目) | ○ |
| C-18 | Add/Edit Rule画面(No.8)でルール編集 | E-08 (17-20行目) | ○ |
| C-19 | qaru_layerはPAGE/APPLICATION/DATABASEのいずれか | E-01 (54行目コメント) | ○ |
| C-20 | qaru_app_idとqaru_page_idでAPEX対象を限定 | E-01 (59-60行目コメント) | ○ |
| C-21 | エラーレベル4以下のルールのみ実行対象 | E-02 (513行目) | ○ |
| C-22 | f_check_for_loopでループ検出 | E-02 (899-960行目) | ○ |
| C-23 | f_get_full_rule_predで全先行ルール取得 | E-02 (962-1004行目) | ○ |
| C-24 | パフォーマンス要件：1秒以内 | **根拠なし** | △ |
| C-25 | APEX管理権限での制御 | **根拠なし**（APEX認可設定要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の根拠**
  - 理由：ソースコード・設計書に明示的な性能要件の記載がない
  - 候補：非機能要件定義書 / システム設計書 / 性能テスト結果
- **APEX認可設定の詳細**
  - 理由：APEXアプリケーション定義ファイル内の認可スキーム未確認
  - 候補：`src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テーブル構造、型定義、パッケージ仕様は明確に確認済み
- **1（中リスク）**: パフォーマンス要件は推測値のため、実運用時に要検証
- **0（低リスク）**: 画面連携は画面機能マッピングで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] QA_RULESテーブルの21列がすべて正しく記載されているか
- [ ] 3カテゴリ（DDL/DML/APEX）の説明が正確か
- [ ] エラーレベルの値と意味が正しいか
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
- [ ] パフォーマンス要件の妥当性（1秒以内）を確認
- [ ] APEX認可設定の詳細を確認し、必要に応じて追記
