---
generated_at: 2026-01-21 17:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ルールJSONエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - エクスポート/インポートパッケージ
- E-02: `src/quasto_rules_template.json` - JSONテンプレート
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_export_rules_table_to_clob関数として実装 | E-01 (27-31行目, 82-239行目) | ○ |
| C-02 | pi_client_nameとpi_categoryをパラメータとする | E-01 (29-30行目) | ○ |
| C-03 | pi_categoryのデフォルト値はNULL | E-01 (30行目) | ○ |
| C-04 | 戻り値はCLOB型 | E-01 (31行目) | ○ |
| C-05 | g_version_number = 1.1 | E-01 (14行目) | ○ |
| C-06 | ルールなし時はNULL返却 | E-01 (119-125行目) | ○ |
| C-07 | json_object_t型でJSONオブジェクト構築 | E-01 (93-101行目, 170行目) | ○ |
| C-08 | json_array_t型でJSON配列構築 | E-01 (94-97行目) | ○ |
| C-09 | .put()で値追加 | E-01 (171-194行目) | ○ |
| C-10 | .append()で配列に要素追加 | E-01 (195行目, 202行目) | ○ |
| C-11 | json_serialize pretty形式で整形 | E-01 (221-223行目) | ○ |
| C-12 | 3重ループ（クライアント > カテゴリ > ルール） | E-01 (133-209行目) | ○ |
| C-13 | Rule Files画面(No.9)から呼び出し | E-03 (21行目) | ○ |
| C-14 | NO_DATA_FOUND時はログ記録して再スロー | E-01 (227-232行目) | ○ |
| C-15 | g_spool_activeでデバッグ出力制御 | E-01 (18行目, 121-124行目, 127-130行目) | ○ |
| C-16 | client_names > categories > rulesの階層構造 | E-01 (205-218行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み
- **0（低リスク）**: JSON構造はソースコードとテンプレートで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] JSON出力構造（version, qa_rules, client_names, categories, rules）が正確か
- [ ] json_object_t/json_array_tの使用方法が正確に記載されているか
- [ ] json_serialize pretty形式の説明が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
