---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-ルールJSONインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **権限制御**：コード上の権限チェックロジック不明
  2. **バージョン検証**：JSONバージョン番号の扱いについて追加確認推奨
  3. **トランザクション範囲**：暗黙コミットの動作について実機確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_export_import_rules_pkg.sql` （エクスポート/インポートパッケージ）
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` （APEXアプリパッケージ）
- E-03: `src/ddl/tab/qa_import_files.sql` （インポートファイルテーブルDDL）
- E-04: `src/ddl/tab/qa_rules.sql` （ルールテーブルDDL）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_import_clob_to_rules_tableがJSONインポートの主処理である | E-01（367-463行目） | ○ |
| C-02 | f_import_clob_to_qa_import_filesがCLOBをQA_IMPORT_FILESに保存する | E-01（318-364行目） | ○ |
| C-03 | p_upload_rules_jsonがAPEXからのエントリーポイントである | E-02（117-161行目） | ○ |
| C-04 | MIMEタイプがapplication/json以外の場合はエラーとなる | E-02（143-146行目） | ○ |
| C-05 | APEX_APPLICATION_TEMP_FILESからファイルを取得する | E-02（134-141行目） | ○ |
| C-06 | QA_IMPORT_FILESテーブルにファイル履歴を保存する | E-01（340-348行目）、E-03 | ○ |
| C-07 | JSON_TABLEを使用してJSONをパースする | E-01（385-399行目） | ○ |
| C-08 | MERGE文で挿入または更新を行う | E-01（403-447行目） | ○ |
| C-09 | client_nameとrule_numberの組み合わせがマッチキーである | E-01（405行目） | ○ |
| C-10 | QA_IMPORT_FILESにはqaif_filename, qaif_mimetype, qaif_clob_dataカラムがある | E-03（5-8行目） | ○ |
| C-11 | QA_RULESにはqaru_client_name, qaru_rule_numberカラムがある | E-04（7-8行目） | ○ |
| C-12 | Rule Files画面（画面No.9）からインポート操作を行う | E-05（22行目） | ○ |
| C-13 | 機能名は「ルールJSONインポート」で、機能番号は11である | E-06（12行目） | ○ |
| C-14 | qa_export_import_rules_pkg.p_import_clob_to_rules_tableが使用される | E-06（12行目: 備考欄） | ○ |
| C-15 | JSONにはversion, qa_rules, client_names, categories, rulesの階層がある | E-01（385-399行目: JSON_TABLEのパス定義） | ○ |
| C-16 | バージョン番号1.1がエクスポートで設定される | E-01（14行目: g_version_number） | ○ |
| C-17 | qa_logger_pkgでエラーログを記録する | E-01（228-231, 305-308行目等） | ○ |
| C-18 | NO_DATA_FOUND例外を捕捉して処理する | E-01（304, 351, 450行目） | ○ |
| C-19 | RETURNING句でINSERT後のIDを取得する | E-01（348行目） | ○ |
| C-20 | BLOBをCLOBに変換してから処理する | E-02（134行目: to_clob(blob_content)） | ○ |
| C-21 | qaru_sql等12個のフィールドがMERGE対象となる | E-01（408-446行目） | ○ |
| C-22 | DBMS_OUTPUT.PUT_LINEで処理経過を出力する | E-01（401行目） | ○ |
| C-23 | qaif_id, qaif_filename, qaif_mimetypeがNOT NULL制約を持つ | E-03（5-7行目） | ○ |
| C-24 | 権限チェックはAPEXアプリケーションレベルに依存する | **根拠なし** | △ |
| C-25 | トランザクションは暗黙コミットで処理される | E-01（コード内に明示的COMMIT/ROLLBACKなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- 権限制御の詳細（APEXアプリケーションの認可設定）
  - 候補：APEXアプリケーション定義ファイル / 認可スキーム設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JSON形式検証はMIMEタイプのみで、JSON構造の妥当性は検証されない
- 1: 中リスク - インポート時にJSONバージョン番号の互換性チェックが行われない
- 0: 低リスク - MERGE文により既存ルールが上書きされる可能性がある（仕様通り）

## 6) レビュアーチェックリスト（最小）
- [ ] JSON構造が不正な場合のエラーハンドリングを確認
- [ ] 大量ルールインポート時のパフォーマンスを確認
- [ ] APEX認可設定で適切なアクセス制御がされているか確認
- [ ] 本番環境でのMERGE動作（既存ルール上書き）が許容されるか確認
