---
generated_at: 2026-01-21 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-インポートファイル管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. qaif_status/qaif_error_logの使用目的について確認推奨
  3. シーケンス定義の存在確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_export_import_rules_pkg.sql` （エクスポート/インポートパッケージ）
- E-02: `src/ddl/tab/qa_import_files.sql` （インポートファイルテーブルDDL）
- E-03: `src/plsql/pkg/qa_apex_app_pkg.sql` （呼び出し元）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_import_clob_to_qa_import_filesがメイン関数である | E-01（318-364行目）、E-04（13行目） | ○ |
| C-02 | 入力パラメータはpi_clob, pi_filename, pi_mimetypeの3つ | E-01（320-323行目） | ○ |
| C-03 | RETURNING句でqaif_idを取得する | E-01（348行目） | ○ |
| C-04 | QA_IMPORT_FILESにINSERTする | E-01（340-348行目） | ○ |
| C-05 | qa_logger_pkg.append_paramでパラメータをログ記録 | E-01（331-338行目） | ○ |
| C-06 | CLOBは先頭4000バイトのみログに記録される | E-01（331行目: dbms_lob.substr(pi_clob,4000,1)） | ○ |
| C-07 | QA_IMPORT_FILESには10カラムある | E-02（5-14行目） | ○ |
| C-08 | qaif_created_onにはDEFAULT sysdate | E-02（11行目） | ○ |
| C-09 | qaif_created_byにはDEFAULT user | E-02（12行目） | ○ |
| C-10 | qaif_updated_onにはDEFAULT sysdate | E-02（13行目） | ○ |
| C-11 | qaif_updated_byにはDEFAULT user | E-02（14行目） | ○ |
| C-12 | NO_DATA_FOUND例外を捕捉する | E-01（351-357行目） | ○ |
| C-13 | OTHERS例外を捕捉する | E-01（358-363行目） | ○ |
| C-14 | 例外時にqa_logger_pkg.p_qa_logでログ記録 | E-01（353-356, 359-362行目） | ○ |
| C-15 | p_upload_rules_jsonから呼び出される | E-03（148-150行目） | ○ |
| C-16 | to_clob関数でCLOBに変換する | E-01（347行目） | ○ |
| C-17 | 機能名は「インポートファイル管理」で番号は12 | E-04（13行目） | ○ |
| C-18 | qaif_statusとqaif_error_logはNULLで保存される | E-01（340-348行目: 該当カラムへの値設定なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- シーケンス定義（qaif_idの採番方法の詳細）
  - 候補：`src/ddl/seq/`ディレクトリまたはトリガー定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなINSERT処理
- 0: 低リスク - トランザクション制御は呼び出し元に委譲
- 0: 低リスク - qaif_status/qaif_error_logは将来拡張用と推測

## 6) レビュアーチェックリスト（最小）
- [ ] qaif_idの採番シーケンスが存在するか確認
- [ ] qaif_status/qaif_error_logの使用予定を確認
- [ ] 大容量CLOB保存時のパフォーマンスを確認
